/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.de;

import com.brandon3055.brandonscore.common.utills.InfoHelper;
import com.brandon3055.draconicevolution.client.render.IRenderTweak;
import com.brandon3055.draconicevolution.common.handler.BalanceConfigHandler;
import com.brandon3055.draconicevolution.common.items.weapons.IEnergyContainerWeaponItem;
import com.brandon3055.draconicevolution.common.utills.IConfigurableItem;
import com.brandon3055.draconicevolution.common.utills.IInventoryTool;
import com.brandon3055.draconicevolution.common.utills.IUpgradableItem;
import com.brandon3055.draconicevolution.common.utills.ItemConfigField;
import com.denfop.IUCore;
import com.denfop.integration.de.DraconicIntegration;
import com.denfop.integration.de.MiningTool;
import com.denfop.integration.de.ToolHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class ChaosDistructionStaff
extends MiningTool
implements IInventoryTool,
IRenderTweak,
IEnergyContainerWeaponItem {
    public ChaosDistructionStaff() {
        super(DraconicIntegration.CHAOS);
        this.func_77655_b("ChaosDistructionStaff");
        this.setHarvestLevel("pickaxe", 15);
        this.setHarvestLevel("shovel", 15);
        this.setHarvestLevel("axe", 15);
        this.setCapacity(BalanceConfigHandler.draconicToolsBaseStorage * 2 + BalanceConfigHandler.draconicWeaponsBaseStorage * 2);
        this.setMaxExtract(BalanceConfigHandler.draconicToolsMaxTransfer * 2 + BalanceConfigHandler.draconicWeaponsMaxTransfer * 2);
        this.setMaxReceive(BalanceConfigHandler.draconicToolsMaxTransfer * 2 + BalanceConfigHandler.draconicWeaponsMaxTransfer * 2);
        this.energyPerOperation = BalanceConfigHandler.draconicToolsEnergyPerAction * 2;
        DraconicIntegration.register(this);
        this.func_77637_a(IUCore.TAB_ITEMS);
    }

    @Override
    public float func_150893_a(ItemStack stack, Block block) {
        return this.getEfficiency(stack);
    }

    @Override
    public List<ItemConfigField> getFields(ItemStack stack, int slot) {
        List<ItemConfigField> list = super.getFields(stack, slot);
        list.add(new ItemConfigField(2, slot, "ToolDigAOE").setMinMaxAndIncromente((Object)0, (Object)IUpgradableItem.EnumUpgrade.DIG_AOE.getUpgradePoints(stack), (Object)1).readFromItem(stack, (Object)0).setModifier("AOE"));
        list.add(new ItemConfigField(2, slot, "ToolDigDepth").setMinMaxAndIncromente((Object)1, (Object)IUpgradableItem.EnumUpgrade.DIG_DEPTH.getUpgradePoints(stack), (Object)1).readFromItem(stack, (Object)1));
        list.add(new ItemConfigField(2, slot, "WeaponAttackAOE").setMinMaxAndIncromente((Object)0, (Object)IUpgradableItem.EnumUpgrade.ATTACK_AOE.getUpgradePoints(stack), (Object)1).readFromItem(stack, (Object)1).setModifier("AOE"));
        list.add(new ItemConfigField(6, slot, "ToolVoidJunk").readFromItem(stack, (Object)Boolean.FALSE));
        return list;
    }

    public String getInventoryName() {
        return StatCollector.func_74838_a((String)"info.de.toolInventoryOblit.txt");
    }

    public int getInventorySlots() {
        return 9;
    }

    public boolean isEnchantValid(Enchantment enchant) {
        return enchant.field_77351_y == EnumEnchantmentType.digger || enchant.field_77351_y == EnumEnchantmentType.weapon;
    }

    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        entity.field_70172_ad = 0;
        ToolHandler.damageEntityBasedOnHealth(entity, player, 0.3f);
        ToolHandler.AOEAttack(player, entity, stack, IConfigurableItem.ProfileHelper.getInteger((ItemStack)stack, (String)"WeaponAttackAOE", (int)0));
        return true;
    }

    @Override
    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        return super.func_77659_a(stack, world, player);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean extended) {
        super.func_77624_a(stack, player, list, extended);
        list.add("");
        list.add(EnumChatFormatting.BLUE + "+" + ToolHandler.getBaseAttackDamage(stack) + " " + StatCollector.func_74838_a((String)"info.de.attackDamage.txt"));
        list.add(EnumChatFormatting.BLUE + "+30% " + StatCollector.func_74838_a((String)"info.de.bonusHealthDamage.txt"));
    }

    public void tweakRender(IItemRenderer.ItemRenderType type) {
        GL11.glTranslated((double)0.77, (double)0.19, (double)-0.15);
        GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)-35.0f, (float)0.0f, (float)-1.0f, (float)0.0f);
        GL11.glScaled((double)0.7, (double)0.7, (double)0.7);
        if (type == IItemRenderer.ItemRenderType.INVENTORY) {
            GL11.glScalef((float)6.0f, (float)6.0f, (float)6.0f);
            GL11.glRotatef((float)145.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glTranslated((double)-1.7, (double)0.0, (double)1.8);
        } else if (type == IItemRenderer.ItemRenderType.ENTITY) {
            GL11.glRotatef((float)-34.5f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glTranslated((double)-1.1, (double)0.0, (double)-0.2);
        } else if (type == IItemRenderer.ItemRenderType.EQUIPPED_FIRST_PERSON) {
            GL11.glTranslated((double)0.0, (double)0.4, (double)0.0);
        }
    }

    public int getUpgradeCap(ItemStack itemstack) {
        return BalanceConfigHandler.draconicStaffMaxUpgrades;
    }

    public int getMaxTier(ItemStack itemstack) {
        return 3;
    }

    public int getMaxUpgradePoints(int upgradeIndex) {
        if (upgradeIndex == IUpgradableItem.EnumUpgrade.RF_CAPACITY.index) {
            return BalanceConfigHandler.draconicStaffMaxCapacityUpgradePoints;
        }
        if (upgradeIndex == IUpgradableItem.EnumUpgrade.DIG_AOE.index) {
            return 7;
        }
        if (upgradeIndex == IUpgradableItem.EnumUpgrade.DIG_DEPTH.index) {
            return 15;
        }
        if (upgradeIndex == IUpgradableItem.EnumUpgrade.ATTACK_AOE.index) {
            return 17;
        }
        if (upgradeIndex == IUpgradableItem.EnumUpgrade.ATTACK_DAMAGE.index) {
            return 110;
        }
        return BalanceConfigHandler.draconicStaffMaxUpgradePoints + 6;
    }

    public int getBaseUpgradePoints(int upgradeIndex) {
        if (upgradeIndex == IUpgradableItem.EnumUpgrade.DIG_AOE.index) {
            return 5;
        }
        if (upgradeIndex == IUpgradableItem.EnumUpgrade.DIG_DEPTH.index) {
            return 11;
        }
        if (upgradeIndex == IUpgradableItem.EnumUpgrade.ATTACK_AOE.index) {
            return 7;
        }
        if (upgradeIndex == IUpgradableItem.EnumUpgrade.ATTACK_DAMAGE.index) {
            return 10;
        }
        return 0;
    }

    @Override
    public int getCapacity(ItemStack stack) {
        int points = IUpgradableItem.EnumUpgrade.RF_CAPACITY.getUpgradePoints(stack);
        return BalanceConfigHandler.draconicToolsBaseStorage * 2 + BalanceConfigHandler.draconicWeaponsBaseStorage * 2 + points * (BalanceConfigHandler.draconicToolsStoragePerUpgrade * 2 + BalanceConfigHandler.draconicWeaponsStoragePerUpgrade * 2);
    }

    @Override
    public List<IUpgradableItem.EnumUpgrade> getUpgrades(ItemStack itemstack) {
        List<IUpgradableItem.EnumUpgrade> list = super.getUpgrades(itemstack);
        list.add(IUpgradableItem.EnumUpgrade.ATTACK_AOE);
        list.add(IUpgradableItem.EnumUpgrade.ATTACK_DAMAGE);
        list.add(IUpgradableItem.EnumUpgrade.DIG_DEPTH);
        list.add(IUpgradableItem.EnumUpgrade.DIG_AOE);
        list.add(IUpgradableItem.EnumUpgrade.DIG_SPEED);
        list.add(IUpgradableItem.EnumUpgrade.RF_CAPACITY);
        return list;
    }

    @Override
    public boolean hasEffect(ItemStack par1ItemStack, int pass) {
        return true;
    }

    @Override
    public List<String> getUpgradeStats(ItemStack stack) {
        List<String> list = super.getUpgradeStats(stack);
        list.add(InfoHelper.ITC() + StatCollector.func_74838_a((String)"info.de.attackDamage.txt") + ": " + InfoHelper.HITC() + ToolHandler.getBaseAttackDamage(stack));
        return list;
    }

    public int getEnergyPerAttack() {
        return BalanceConfigHandler.draconicWeaponsEnergyPerAttack;
    }
}

