/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.de;

import com.brandon3055.draconicevolution.client.render.IRenderTweak;
import com.brandon3055.draconicevolution.common.ModItems;
import com.brandon3055.draconicevolution.common.handler.ConfigHandler;
import com.denfop.IUItem;
import com.denfop.integration.de.BlockDESolarPanel;
import com.denfop.integration.de.ChaosArmor;
import com.denfop.integration.de.ChaosAxe;
import com.denfop.integration.de.ChaosBow;
import com.denfop.integration.de.ChaosDistructionStaff;
import com.denfop.integration.de.ChaosFluxCapacitor;
import com.denfop.integration.de.ChaosPickaxe;
import com.denfop.integration.de.ChaosShovel;
import com.denfop.integration.de.ChaosSword;
import com.denfop.integration.de.DEItem;
import com.denfop.integration.de.ItemDC;
import com.denfop.integration.de.RenderArmor;
import com.denfop.integration.de.RenderBowModel;
import com.denfop.integration.de.RenderTool;
import com.denfop.utils.IntegrationsHelper;
import cpw.mods.fml.common.registry.GameRegistry;
import ic2.api.recipe.IRecipeInput;
import ic2.api.recipe.RecipeInputItemStack;
import ic2.api.recipe.Recipes;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.common.util.EnumHelper;

public class DraconicIntegration {
    public static final Item.ToolMaterial CHAOS = EnumHelper.addToolMaterial((String)"CHAOS", (int)15, (int)-1, (float)600.0f, (float)90.0f, (int)60);
    private static final ItemArmor.ArmorMaterial CHAOS_ARMOR = EnumHelper.addArmorMaterial((String)"CHAOS_ARMOR", (int)-1, (int[])new int[]{5, 10, 8, 6}, (int)30);
    public static Item chaosDestructionStaff;
    public static Item chaosPickaxe;
    public static Item chaosAxe;
    public static ItemArmor chaosHelm;
    public static Item chaosShovel;
    public static Item chaosSword;
    public static Item chaosBow;
    public static ItemArmor chaosChest;
    public static ItemArmor chaosLeggs;
    public static ItemArmor chaosBoots;
    public static Item chaosEnergyCore;
    public static ItemDC chaosFluxCapacitor;
    public static Item chaosIngot;
    public static Block blockDraconicSP;

    public static void init() {
        if (IntegrationsHelper.isDraconicIntegrationValid) {
            chaosEnergyCore = new DEItem("ChaosEnergyCore");
            chaosFluxCapacitor = new ChaosFluxCapacitor();
            chaosDestructionStaff = new ChaosDistructionStaff();
            chaosPickaxe = new ChaosPickaxe();
            chaosAxe = new ChaosAxe();
            chaosShovel = new ChaosShovel();
            chaosSword = new ChaosSword();
            chaosBow = new ChaosBow();
            chaosHelm = new ChaosArmor(CHAOS_ARMOR, 0, "ChaosHelm");
            chaosChest = new ChaosArmor(CHAOS_ARMOR, 1, "ChaosChest");
            chaosLeggs = new ChaosArmor(CHAOS_ARMOR, 2, "ChaosLeggs");
            chaosBoots = new ChaosArmor(CHAOS_ARMOR, 3, "ChaosBoots");
            chaosIngot = new DEItem("chaosIngot");
            blockDraconicSP = new BlockDESolarPanel();
        }
    }

    public static void register(ItemDC item) {
        String name = item.getUnwrappedUnlocalizedName(item.func_77658_a());
        if (DraconicIntegration.isEnabled(item)) {
            GameRegistry.registerItem((Item)item, (String)name.substring(name.indexOf(":") + 1));
        }
    }

    public static boolean isEnabled(Item item) {
        return !ConfigHandler.disabledNamesList.contains(item.func_77658_a());
    }

    public static void loadRecipes() {
        GameRegistry.addRecipe((ItemStack)new ItemStack(chaosEnergyCore, 1), (Object[])new Object[]{" B ", "BAB", " B ", Character.valueOf('B'), new ItemStack(chaosIngot, 1), Character.valueOf('A'), ModItems.draconicEnergyCore});
        Recipes.compressor.addRecipe((IRecipeInput)new RecipeInputItemStack(new ItemStack((Item)ModItems.chaosFragment, 1, 2), 1), null, new ItemStack[]{new ItemStack(chaosIngot, 1)});
        GameRegistry.addRecipe((ItemStack)new ItemStack((Item)chaosHelm), (Object[])new Object[]{"CDC", "CAC", "CBC", Character.valueOf('B'), new ItemStack(chaosEnergyCore, 1), Character.valueOf('A'), new ItemStack((Item)ModItems.draconicHelm), Character.valueOf('D'), ModItems.chaoticCore, Character.valueOf('C'), chaosIngot});
        GameRegistry.addRecipe((ItemStack)new ItemStack((Item)chaosChest, 1), (Object[])new Object[]{"CDC", "CAC", "CBC", Character.valueOf('B'), new ItemStack(chaosEnergyCore, 1), Character.valueOf('A'), new ItemStack((Item)ModItems.draconicChest), Character.valueOf('D'), ModItems.chaoticCore, Character.valueOf('C'), chaosIngot});
        GameRegistry.addRecipe((ItemStack)new ItemStack((Item)chaosLeggs, 1), (Object[])new Object[]{"CDC", "CAC", "CBC", Character.valueOf('B'), new ItemStack(chaosEnergyCore, 1), Character.valueOf('A'), ModItems.draconicLeggs, Character.valueOf('D'), ModItems.chaoticCore, Character.valueOf('C'), chaosIngot});
        GameRegistry.addRecipe((ItemStack)new ItemStack((Item)chaosBoots, 1), (Object[])new Object[]{"CDC", "CAC", "CBC", Character.valueOf('B'), new ItemStack(chaosEnergyCore, 1), Character.valueOf('A'), ModItems.draconicBoots, Character.valueOf('D'), ModItems.chaoticCore, Character.valueOf('C'), chaosIngot});
        GameRegistry.addRecipe((ItemStack)new ItemStack(chaosPickaxe, 1), (Object[])new Object[]{" D ", "CAC", " B ", Character.valueOf('B'), new ItemStack(chaosEnergyCore, 1), Character.valueOf('A'), ModItems.draconicPickaxe, Character.valueOf('D'), ModItems.chaoticCore, Character.valueOf('C'), chaosIngot});
        GameRegistry.addRecipe((ItemStack)new ItemStack(chaosAxe, 1), (Object[])new Object[]{" D ", "CAC", " B ", Character.valueOf('B'), new ItemStack(chaosEnergyCore, 1), Character.valueOf('A'), ModItems.draconicAxe, Character.valueOf('D'), ModItems.chaoticCore, Character.valueOf('C'), chaosIngot});
        GameRegistry.addRecipe((ItemStack)new ItemStack(chaosShovel, 1), (Object[])new Object[]{" D ", "CAC", " B ", Character.valueOf('B'), new ItemStack(chaosEnergyCore, 1), Character.valueOf('A'), ModItems.draconicShovel, Character.valueOf('D'), ModItems.chaoticCore, Character.valueOf('C'), chaosIngot});
        GameRegistry.addRecipe((ItemStack)new ItemStack(chaosSword, 1), (Object[])new Object[]{" D ", "CAC", " B ", Character.valueOf('B'), new ItemStack(chaosEnergyCore, 1), Character.valueOf('A'), ModItems.draconicSword, Character.valueOf('D'), ModItems.chaoticCore, Character.valueOf('C'), chaosIngot});
        GameRegistry.addRecipe((ItemStack)new ItemStack(chaosBow, 1), (Object[])new Object[]{" D ", "CAC", " B ", Character.valueOf('B'), new ItemStack(chaosEnergyCore, 1), Character.valueOf('A'), ModItems.draconicBow, Character.valueOf('D'), ModItems.chaoticCore, Character.valueOf('C'), chaosIngot});
        GameRegistry.addRecipe((ItemStack)new ItemStack(chaosDestructionStaff, 1), (Object[])new Object[]{"CDC", "ACE", "CBC", Character.valueOf('B'), new ItemStack(chaosSword, 1), Character.valueOf('A'), chaosPickaxe, Character.valueOf('D'), ModItems.chaoticCore, Character.valueOf('C'), chaosIngot, Character.valueOf('E'), chaosShovel});
        GameRegistry.addRecipe((ItemStack)new ItemStack((Item)chaosFluxCapacitor, 1), (Object[])new Object[]{"CDC", "CAC", "CBC", Character.valueOf('B'), new ItemStack(chaosEnergyCore, 1), Character.valueOf('A'), ModItems.draconicFluxCapacitor, Character.valueOf('D'), ModItems.chaoticCore, Character.valueOf('C'), chaosIngot});
        GameRegistry.addRecipe((ItemStack)new ItemStack(blockDraconicSP, 1, 0), (Object[])new Object[]{" B ", "BAB", " B ", Character.valueOf('B'), new ItemStack(IUItem.blockSP, 1), Character.valueOf('A'), ModItems.wyvernCore});
        GameRegistry.addRecipe((ItemStack)new ItemStack(blockDraconicSP, 1, 1), (Object[])new Object[]{"AB ", "BAB", " BA", Character.valueOf('B'), new ItemStack(blockDraconicSP, 1, 0), Character.valueOf('A'), ModItems.awakenedCore});
        GameRegistry.addRecipe((ItemStack)new ItemStack(blockDraconicSP, 1, 2), (Object[])new Object[]{"ABC", "BAB", "CBA", Character.valueOf('B'), new ItemStack(blockDraconicSP, 1, 1), Character.valueOf('A'), ModItems.chaoticCore, Character.valueOf('C'), chaosEnergyCore});
        GameRegistry.addRecipe((ItemStack)new ItemStack(IUItem.panelUpgradeKit, 1, 14), (Object[])new Object[]{"   ", "BAB", " B ", Character.valueOf('B'), new ItemStack(IUItem.blockSP, 1), Character.valueOf('A'), ModItems.wyvernCore});
        GameRegistry.addRecipe((ItemStack)new ItemStack(IUItem.panelUpgradeKit, 1, 15), (Object[])new Object[]{"A  ", "BAB", " BA", Character.valueOf('B'), new ItemStack(blockDraconicSP, 1, 0), Character.valueOf('A'), ModItems.awakenedCore});
        GameRegistry.addRecipe((ItemStack)new ItemStack(IUItem.panelUpgradeKit, 1, 16), (Object[])new Object[]{"A C", "BAB", "CBA", Character.valueOf('B'), new ItemStack(blockDraconicSP, 1, 1), Character.valueOf('A'), ModItems.chaoticCore, Character.valueOf('C'), chaosEnergyCore});
    }

    public static void render() {
        MinecraftForgeClient.registerItemRenderer((Item)chaosBow, (IItemRenderer)new RenderBowModel(true));
        MinecraftForgeClient.registerItemRenderer((Item)chaosSword, (IItemRenderer)new RenderTool("models/tools/DraconicSword.obj", "textures/models/tools/DraconicSword.png", (IRenderTweak)chaosSword));
        MinecraftForgeClient.registerItemRenderer((Item)chaosPickaxe, (IItemRenderer)new RenderTool("models/tools/DraconicPickaxe.obj", "textures/models/tools/DraconicPickaxe.png", (IRenderTweak)chaosPickaxe));
        MinecraftForgeClient.registerItemRenderer((Item)chaosAxe, (IItemRenderer)new RenderTool("models/tools/DraconicLumberAxe.obj", "textures/models/tools/DraconicLumberAxe.png", (IRenderTweak)chaosAxe));
        MinecraftForgeClient.registerItemRenderer((Item)chaosShovel, (IItemRenderer)new RenderTool("models/tools/DraconicShovel.obj", "textures/models/tools/DraconicShovel.png", (IRenderTweak)chaosShovel));
        MinecraftForgeClient.registerItemRenderer((Item)chaosDestructionStaff, (IItemRenderer)new RenderTool("models/tools/DraconicStaffOfPower.obj", "textures/models/tools/DraconicStaffOfPower.png", (IRenderTweak)chaosDestructionStaff));
        MinecraftForgeClient.registerItemRenderer((Item)chaosHelm, (IItemRenderer)new RenderArmor(chaosHelm));
        MinecraftForgeClient.registerItemRenderer((Item)chaosChest, (IItemRenderer)new RenderArmor(chaosChest));
        MinecraftForgeClient.registerItemRenderer((Item)chaosLeggs, (IItemRenderer)new RenderArmor(chaosLeggs));
        MinecraftForgeClient.registerItemRenderer((Item)chaosBoots, (IItemRenderer)new RenderArmor(chaosBoots));
    }
}

