/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.TemplateRecipeHandler;
import com.denfop.api.Recipes;
import ic2.core.util.GuiTooltipHelper;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;
import org.lwjgl.opengl.GL11;

public class NEIGeneratorSunnarium
extends TemplateRecipeHandler {
    int ticks;

    public String getRecipeName() {
        return StatCollector.func_74838_a((String)"blockSolarGeneratorEnergy.name");
    }

    public String getRecipeId() {
        return "iu.blockSolarGeneratorEnergy";
    }

    public String getGuiTexture() {
        return "industrialupgrade:textures/gui/SunnariumGenerator.png";
    }

    public String getOverlayIdentifier() {
        return "sunnariumgenerator";
    }

    public Map<NBTTagCompound, ItemStack> getRecipeList() {
        return Recipes.sunnariumGen.getRecipes();
    }

    public void drawBackground(int i) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiDraw.changeTexture((String)this.getGuiTexture());
        GuiDraw.drawTexturedModalRect((int)0, (int)0, (int)3, (int)3, (int)160, (int)75);
    }

    public void drawExtras(int i) {
        float f = this.ticks <= 20 ? (float)this.ticks / 20.0f : 1.0f;
        this.drawProgressBar(120, 35, 176, 18, 24, 9, f, 0);
        this.drawLiquidTooltip(i);
    }

    private void drawLiquidTooltip(int recipe) {
        GuiRecipe gui = (GuiRecipe)Minecraft.func_71410_x().field_71462_r;
        Point mouse = GuiDraw.getMousePosition();
        Point offset = gui.getRecipePosition(recipe);
        String tooltip = "SE: 7500 EU";
        GuiTooltipHelper.drawAreaTooltip((int)(mouse.x - (gui.field_146294_l - 176) / 2 - offset.x), (int)(mouse.y - (gui.field_146295_m - 176) / 2 - offset.y), (String)tooltip, (int)120, (int)35, (int)146, (int)47);
    }

    public void onUpdate() {
        super.onUpdate();
        ++this.ticks;
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals(this.getRecipeId())) {
            for (Map.Entry<NBTTagCompound, ItemStack> entry : this.getRecipeList().entrySet()) {
                this.arecipes.add(new GenerationSunnariumRecipe(entry.getValue()));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        for (Map.Entry<NBTTagCompound, ItemStack> entry : this.getRecipeList().entrySet()) {
            if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)entry.getValue(), (ItemStack)result)) continue;
            this.arecipes.add(new GenerationSunnariumRecipe(entry.getValue()));
        }
    }

    public int recipiesPerPage() {
        return 1;
    }

    public class GenerationSunnariumRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        public final PositionedStack output;
        public final List<PositionedStack> ingredients;

        public GenerationSunnariumRecipe(ItemStack output1) {
            super((TemplateRecipeHandler)NEIGeneratorSunnarium.this);
            this.ingredients = new ArrayList<PositionedStack>();
            this.output = new PositionedStack((Object)output1, 66, 32);
        }

        public List<PositionedStack> getIngredients() {
            return this.getCycledIngredients(NEIGeneratorSunnarium.this.cycleticks / 20, this.ingredients);
        }

        public PositionedStack getResult() {
            return this.output;
        }
    }
}

