/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.TemplateRecipeHandler;
import com.denfop.api.IFluidRecipeManager;
import com.denfop.api.Recipes;
import com.denfop.gui.GUIOilRefiner;
import ic2.core.util.DrawUtil;
import ic2.core.util.GuiTooltipHelper;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;
import org.lwjgl.opengl.GL11;

public class NEIRefiner
extends TemplateRecipeHandler {
    int ticks;

    public Class<? extends GuiContainer> getGuiClass() {
        return GUIOilRefiner.class;
    }

    public String getRecipeName() {
        return StatCollector.func_74838_a((String)"blockOilRefiner.name");
    }

    public String getRecipeId() {
        return "iu.blockOilRefiner";
    }

    public String getGuiTexture() {
        return "industrialupgrade:textures/gui/GUIOilRefiner.png";
    }

    public String getOverlayIdentifier() {
        return "refiner";
    }

    public Map<IFluidRecipeManager.Input, FluidStack[]> getRecipeList() {
        return Recipes.oilRefiner.getRecipes();
    }

    private void drawLiquid(FluidStack stack, int x) {
        IIcon fluidIcon = new ItemStack(stack.getFluid().getBlock()).func_77954_c();
        GuiDraw.renderEngine.func_110577_a(TextureMap.field_110575_b);
        int liquidHeight = (int)((float)stack.amount / 8000.0f * 47.0f);
        DrawUtil.drawRepeated((IIcon)fluidIcon, (double)x, (double)(52 - liquidHeight), (double)12.0, (double)liquidHeight, (double)GuiDraw.gui.getZLevel());
        GuiDraw.changeTexture((String)this.getGuiTexture());
        GuiDraw.drawTexturedModalRect((int)x, (int)7, (int)176, (int)57, (int)12, (int)46);
    }

    private void drawLiquidTooltip(FluidStack stack, int recipe, int x) {
        GuiRecipe gui = (GuiRecipe)Minecraft.func_71410_x().field_71462_r;
        Point mouse = GuiDraw.getMousePosition();
        Point offset = gui.getRecipePosition(recipe);
        String tooltip = stack.getLocalizedName() + " (" + stack.amount + "mb)";
        GuiTooltipHelper.drawAreaTooltip((int)(mouse.x - (gui.field_146294_l - 176) / 2 - offset.x), (int)(mouse.y - (gui.field_146295_m - 176) / 2 - offset.y), (String)tooltip, (int)x, (int)5, (int)(x + 12), (int)52);
    }

    public void drawBackground(int i) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiDraw.changeTexture((String)this.getGuiTexture());
        GuiDraw.drawTexturedModalRect((int)0, (int)0, (int)5, (int)5, (int)140, (int)75);
        RefinerRecipe recipe = (RefinerRecipe)((Object)this.arecipes.get(i));
        this.drawLiquid(recipe.fluidstack, 11);
        this.drawLiquid(recipe.output[0], 73);
        this.drawLiquid(recipe.output[1], 105);
    }

    public void drawExtras(int i) {
        float f = this.ticks <= 20 ? (float)this.ticks / 20.0f : 1.0f;
        this.drawProgressBar(34, 64, 177, 104, 29, 9, f, 0);
        RefinerRecipe recipe = (RefinerRecipe)((Object)this.arecipes.get(i));
        this.drawLiquidTooltip(recipe.fluidstack, i, 11);
        this.drawLiquidTooltip(recipe.output[0], i, 73);
        this.drawLiquidTooltip(recipe.output[1], i, 105);
    }

    public void onUpdate() {
        super.onUpdate();
        ++this.ticks;
    }

    public void loadTransferRects() {
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals(this.getRecipeId())) {
            for (Map.Entry<IFluidRecipeManager.Input, FluidStack[]> entry : this.getRecipeList().entrySet()) {
                this.arecipes.add(new RefinerRecipe(entry.getKey().fluidStack, entry.getValue()));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public int recipiesPerPage() {
        return 1;
    }

    public void loadCraftingRecipes(ItemStack result) {
        FluidStack stack = null;
        Item item = result.func_77973_b();
        if (item instanceof IFluidContainerItem) {
            IFluidContainerItem container = (IFluidContainerItem)item;
            stack = container.getFluid(result);
        } else if (result.func_77973_b() instanceof ItemBlock && Block.func_149634_a((Item)result.func_77973_b()) instanceof BlockFluidBase) {
            stack = new FluidStack(((BlockFluidBase)Block.func_149634_a((Item)result.func_77973_b())).getFluid(), 1000);
        }
        if (stack != null && stack.getFluid() != null) {
            for (Map.Entry<IFluidRecipeManager.Input, FluidStack[]> inputEntry : this.getRecipeList().entrySet()) {
                for (FluidStack fluid : inputEntry.getValue()) {
                    if (!stack.isFluidEqual(fluid)) continue;
                    this.arecipes.add(new RefinerRecipe(inputEntry.getKey().fluidStack, inputEntry.getValue()));
                }
            }
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        FluidStack stack = null;
        if (ingredient.func_77973_b() instanceof IFluidContainerItem) {
            stack = ((IFluidContainerItem)ingredient.func_77973_b()).getFluid(ingredient);
        } else if (ingredient.func_77973_b() instanceof ItemBlock && Block.func_149634_a((Item)ingredient.func_77973_b()) instanceof BlockFluidBase) {
            stack = new FluidStack(((BlockFluidBase)Block.func_149634_a((Item)ingredient.func_77973_b())).getFluid(), 1000);
        }
        Iterator<Map.Entry<IFluidRecipeManager.Input, FluidStack[]>> var3 = this.getRecipeList().entrySet().iterator();
        while (var3.hasNext()) {
            Map.Entry<IFluidRecipeManager.Input, FluidStack[]> entry = var3.next();
            if (stack == null || stack.getFluid() == null || !stack.getFluid().equals(entry.getKey().fluidStack.getFluid())) continue;
            this.arecipes.add(new RefinerRecipe(entry.getKey().fluidStack, entry.getValue()));
        }
        return;
    }

    public class RefinerRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        public final FluidStack[] output;
        public final List<PositionedStack> ingredients;
        public final FluidStack fluidstack;

        public RefinerRecipe(FluidStack fluidstack, FluidStack[] output1) {
            super((TemplateRecipeHandler)NEIRefiner.this);
            this.ingredients = new ArrayList<PositionedStack>();
            this.output = output1;
            this.fluidstack = fluidstack;
        }

        public List<PositionedStack> getIngredients() {
            return this.getCycledIngredients(NEIRefiner.this.cycleticks / 20, this.ingredients);
        }

        public PositionedStack getResult() {
            return null;
        }
    }
}

