/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import com.denfop.api.ISunnariumRecipeManager;
import com.denfop.api.Recipes;
import com.denfop.gui.GUISunnariumMaker;
import ic2.api.recipe.IRecipeInput;
import ic2.api.recipe.RecipeOutput;
import ic2.core.util.StackUtil;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import org.lwjgl.opengl.GL11;

public class NEISunnarium
extends TemplateRecipeHandler {
    int ticks;

    public Class<? extends GuiContainer> getGuiClass() {
        return GUISunnariumMaker.class;
    }

    public String getRecipeName() {
        return StatCollector.func_74838_a((String)"blockSunnariumMaker.name");
    }

    public String getRecipeId() {
        return "iu.sunnarium_gen";
    }

    public String getGuiTexture() {
        return "industrialupgrade:textures/gui/GUISunnariumMaker.png";
    }

    public String getOverlayIdentifier() {
        return "sunnarium_gen";
    }

    public Map<ISunnariumRecipeManager.Input, RecipeOutput> getRecipeList() {
        return Recipes.sunnariumMaker.getRecipes();
    }

    public void drawBackground(int i) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiDraw.changeTexture((String)this.getGuiTexture());
        GuiDraw.drawTexturedModalRect((int)0, (int)0, (int)3, (int)3, (int)140, (int)77);
    }

    public void drawExtras(int i) {
        float f = this.ticks >= 20 ? (float)((this.ticks - 20) % 20) / 20.0f : 0.0f;
        this.drawProgressBar(52, 17, 176, 31, 18, 31, f, 0);
        f = this.ticks <= 20 ? (float)this.ticks / 20.0f : 1.0f;
        this.drawProgressBar(9, 59, 176, 0, 14, 14, f, 3);
    }

    public void onUpdate() {
        super.onUpdate();
        ++this.ticks;
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(52, 14, 17, 31), this.getRecipeId(), new Object[0]));
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals(this.getRecipeId())) {
            for (Map.Entry<ISunnariumRecipeManager.Input, RecipeOutput> entry : this.getRecipeList().entrySet()) {
                this.arecipes.add(new SunnariumRecipe(entry.getKey().container, entry.getKey().fill, entry.getKey().fill2, entry.getKey().fill3, entry.getValue()));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        for (Map.Entry<ISunnariumRecipeManager.Input, RecipeOutput> entry : this.getRecipeList().entrySet()) {
            for (ItemStack output : entry.getValue().items) {
                if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)output, (ItemStack)result)) continue;
                this.arecipes.add(new SunnariumRecipe(entry.getKey().container, entry.getKey().fill, entry.getKey().fill2, entry.getKey().fill3, entry.getValue()));
            }
        }
    }

    public int recipiesPerPage() {
        return 1;
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        for (Map.Entry<ISunnariumRecipeManager.Input, RecipeOutput> entry : this.getRecipeList().entrySet()) {
            if (!entry.getKey().container.matches(ingredient) && !entry.getKey().fill.matches(ingredient) && !entry.getKey().fill2.matches(ingredient) && !entry.getKey().fill3.matches(ingredient)) continue;
            this.arecipes.add(new SunnariumRecipe(entry.getKey().container, entry.getKey().fill, entry.getKey().fill2, entry.getKey().fill3, entry.getValue()));
        }
    }

    public class SunnariumRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        public final PositionedStack output;
        public final List<PositionedStack> ingredients;

        public SunnariumRecipe(IRecipeInput container, IRecipeInput fill, IRecipeInput fill1, IRecipeInput fill2, RecipeOutput output1) {
            super((TemplateRecipeHandler)NEISunnarium.this);
            this.ingredients = new ArrayList<PositionedStack>();
            ArrayList<ItemStack> containerItems = new ArrayList<ItemStack>();
            ArrayList<ItemStack> fillItems = new ArrayList<ItemStack>();
            ArrayList<ItemStack> fillItems1 = new ArrayList<ItemStack>();
            ArrayList<ItemStack> fillItems2 = new ArrayList<ItemStack>();
            for (ItemStack item : container.getInputs()) {
                containerItems.add(StackUtil.copyWithSize((ItemStack)item, (int)container.getAmount()));
            }
            for (ItemStack item : fill.getInputs()) {
                fillItems.add(StackUtil.copyWithSize((ItemStack)item, (int)fill.getAmount()));
            }
            for (ItemStack item : fill1.getInputs()) {
                fillItems1.add(StackUtil.copyWithSize((ItemStack)item, (int)fill1.getAmount()));
            }
            for (ItemStack item : fill2.getInputs()) {
                fillItems2.add(StackUtil.copyWithSize((ItemStack)item, (int)fill2.getAmount()));
            }
            this.ingredients.add(new PositionedStack(containerItems, 35, 14));
            this.ingredients.add(new PositionedStack(fillItems, 71, 14));
            this.ingredients.add(new PositionedStack(fillItems1, 35, 36));
            this.ingredients.add(new PositionedStack(fillItems2, 71, 36));
            this.output = new PositionedStack(output1.items.get(0), 112, 31);
        }

        public List<PositionedStack> getIngredients() {
            return this.getCycledIngredients(NEISunnarium.this.cycleticks / 20, this.ingredients);
        }

        public PositionedStack getResult() {
            return this.output;
        }
    }
}

