/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import com.denfop.api.IDoubleMachineRecipeManager;
import com.denfop.api.Recipes;
import com.denfop.gui.GUISynthesis;
import com.denfop.utils.Helpers;
import ic2.api.recipe.IRecipeInput;
import ic2.api.recipe.RecipeOutput;
import ic2.core.util.StackUtil;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import org.lwjgl.opengl.GL11;

public class NeiSynthesis
extends TemplateRecipeHandler {
    int ticks;

    public Class<? extends GuiContainer> getGuiClass() {
        return GUISynthesis.class;
    }

    public String getRecipeName() {
        return StatCollector.func_74838_a((String)"iu.synthesis.name");
    }

    public String getRecipeId() {
        return "iu.synthesis";
    }

    public String getGuiTexture() {
        return "industrialupgrade:textures/gui/GUISynthesis.png";
    }

    public String getOverlayIdentifier() {
        return "synthesis";
    }

    public Map<IDoubleMachineRecipeManager.Input, RecipeOutput> getRecipeList() {
        return Recipes.synthesis.getRecipes();
    }

    public void drawBackground(int i) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiDraw.changeTexture((String)this.getGuiTexture());
        GuiDraw.drawTexturedModalRect((int)0, (int)0, (int)3, (int)3, (int)148, (int)80);
        SynthesisRecipe recipe = (SynthesisRecipe)((Object)this.arecipes.get(i));
        int percent = recipe.meta.func_74762_e("percent");
        GuiDraw.drawString((String)(EnumChatFormatting.GREEN + StatCollector.func_74838_a((String)"chance") + " " + percent + "%"), (int)68, (int)64, (int)Helpers.convertRGBcolorToInt(217, 217, 217), (boolean)false);
    }

    public void drawExtras(int i) {
        float f = this.ticks >= 20 ? (float)((this.ticks - 20) % 20) / 20.0f : 0.0f;
        this.drawProgressBar(36, 34, 177, 35, 10, 9, f, 0);
        f = this.ticks >= 20 ? (float)((this.ticks - 20) % 20) / 20.0f : 0.0f;
        this.drawProgressBar(79, 27, 177, 52, 24, 23, f, 0);
        f = this.ticks <= 20 ? (float)this.ticks / 20.0f : 1.0f;
        this.drawProgressBar(21, 53, 176, 0, 14, 14, f, 3);
    }

    public void onUpdate() {
        super.onUpdate();
        ++this.ticks;
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(74, 19, 25, 14), this.getRecipeId(), new Object[0]));
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals(this.getRecipeId())) {
            for (Map.Entry<IDoubleMachineRecipeManager.Input, RecipeOutput> entry : this.getRecipeList().entrySet()) {
                this.arecipes.add(new SynthesisRecipe(entry.getKey().container, entry.getKey().fill, entry.getValue()));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        for (Map.Entry<IDoubleMachineRecipeManager.Input, RecipeOutput> entry : this.getRecipeList().entrySet()) {
            for (ItemStack output : entry.getValue().items) {
                if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)output, (ItemStack)result)) continue;
                this.arecipes.add(new SynthesisRecipe(entry.getKey().container, entry.getKey().fill, entry.getValue()));
            }
        }
    }

    public int recipiesPerPage() {
        return 3;
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        for (Map.Entry<IDoubleMachineRecipeManager.Input, RecipeOutput> entry : this.getRecipeList().entrySet()) {
            if (!entry.getKey().container.matches(ingredient) && !entry.getKey().fill.matches(ingredient)) continue;
            this.arecipes.add(new SynthesisRecipe(entry.getKey().container, entry.getKey().fill, entry.getValue()));
        }
    }

    public class SynthesisRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        public final PositionedStack output;
        public final List<PositionedStack> ingredients;
        private final NBTTagCompound meta;

        public SynthesisRecipe(IRecipeInput container, IRecipeInput fill, RecipeOutput output1) {
            super((TemplateRecipeHandler)NeiSynthesis.this);
            this.ingredients = new ArrayList<PositionedStack>();
            ArrayList<ItemStack> containerItems = new ArrayList<ItemStack>();
            ArrayList<ItemStack> fillItems = new ArrayList<ItemStack>();
            for (ItemStack item : container.getInputs()) {
                containerItems.add(StackUtil.copyWithSize((ItemStack)item, (int)container.getAmount()));
            }
            for (ItemStack item : fill.getInputs()) {
                fillItems.add(StackUtil.copyWithSize((ItemStack)item, (int)fill.getAmount()));
            }
            this.ingredients.add(new PositionedStack(containerItems, 11, 31));
            this.ingredients.add(new PositionedStack(fillItems, 61, 31));
            this.output = new PositionedStack(output1.items.get(0), 107, 31);
            this.meta = output1.metadata;
        }

        public List<PositionedStack> getIngredients() {
            return this.getCycledIngredients(NeiSynthesis.this.cycleticks / 20, this.ingredients);
        }

        public PositionedStack getResult() {
            return this.output;
        }
    }
}

