/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.item;

import com.denfop.IUCore;
import com.denfop.IUItem;
import com.denfop.api.IFluidItem;
import com.denfop.block.base.BlockIUFluid;
import com.denfop.block.base.BlocksItems;
import com.denfop.utils.LiquidUtil;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.core.IC2;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;

public class ItemCell
extends Item
implements IFluidItem {
    private final Map<Integer, String> names = new HashMap<Integer, String>();
    private final Map<Block, ItemStack> cells = new IdentityHashMap<Block, ItemStack>();
    private List<String> itemNames;
    private IIcon[] IIconsList;

    public ItemCell() {
        this.func_77627_a(true);
        IUItem.cell = this.addCell(0, "itemCellEmpty", new Block[0]);
        IUItem.uuMatterCell = this.addRegisterCell(1, "itemCellNeutron", "fluidNeutron");
        IUItem.heliumCell = this.addRegisterCell(2, "itemCellHelium", "fluidHelium");
        IUItem.oilCell = this.addRegisterCell(3, "itemCellneft", "fluidneft");
        IUItem.BenzCell = this.addRegisterCell(4, "itemCellbenz", "fluidbenz");
        IUItem.DizelCell = this.addRegisterCell(5, "itemCelldizel", "fluiddizel");
        IUItem.polyethCell = this.addRegisterCell(6, "itemCellpolyeth", "fluidpolyeth");
        IUItem.polypropCell = this.addRegisterCell(7, "itemCellpolyprop", "fluidpolyprop");
        IUItem.oxyCell = this.addRegisterCell(8, "itemCelloxy", "fluidoxy");
        IUItem.hybCell = this.addRegisterCell(9, "itemCellhyd", "fluidhyd");
        this.itemNames = new ArrayList<String>();
        this.addItemsNames();
        this.func_77637_a(IUCore.TAB_ITEMS);
        GameRegistry.registerItem((Item)this, (String)"cell");
    }

    public String func_77667_c(ItemStack stack) {
        if (this.itemNames == null) {
            this.itemNames = new ArrayList<String>();
            this.addItemsNames();
        }
        return this.itemNames.get(stack.func_77960_j());
    }

    public IIcon func_77617_a(int par1) {
        return this.IIconsList[par1];
    }

    public void addItemsNames() {
        this.itemNames.add("itemCellEmpty");
        this.itemNames.add("itemCellNeutron");
        this.itemNames.add("itemCellHelium");
        this.itemNames.add("itemCellneft");
        this.itemNames.add("itemCellbenz");
        this.itemNames.add("itemCelldizel");
        this.itemNames.add("itemCellpolyeth");
        this.itemNames.add("itemCellpolyprop");
        this.itemNames.add("itemCelloxy");
        this.itemNames.add("itemCellhyd");
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister IIconRegister2) {
        this.IIconsList = new IIcon[this.itemNames.size()];
        for (int i = 0; i < this.itemNames.size(); ++i) {
            this.IIconsList[i] = IIconRegister2.func_94245_a("industrialupgrade:" + this.itemNames.get(i));
        }
    }

    public void func_150895_a(Item item, CreativeTabs tabs, List itemList) {
        for (int meta = 0; meta <= this.itemNames.size() - 1; ++meta) {
            ItemStack stack = new ItemStack((Item)this, 1, meta);
            itemList.add(stack);
        }
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float xOffset, float yOffset, float zOffset) {
        if (!IC2.platform.isSimulating()) {
            return false;
        }
        MovingObjectPosition position = this.func_77621_a(world, player, true);
        if (position == null) {
            return false;
        }
        if (position.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
            x = position.field_72311_b;
            y = position.field_72312_c;
            z = position.field_72309_d;
            if (!world.func_72962_a(player, x, y, z)) {
                return false;
            }
            if (!player.func_82247_a(x, y, z, position.field_72310_e, stack)) {
                return false;
            }
            if (stack.func_77960_j() == 0) {
                if (world.func_147439_a(x, y, z) instanceof BlockIUFluid) {
                    Block block = world.func_147439_a(x, y, z);
                    String name = block.func_149739_a();
                    Fluid fluid = BlocksItems.getFluid(name);
                    name = fluid.getName().substring(name.indexOf("fluid"));
                    if (this.itemNames.contains("itemCell" + name)) {
                        ItemStack stack1;
                        int meta = 0;
                        for (int i = 0; i < this.itemNames.size(); ++i) {
                            if (!this.itemNames.get(i).equals("itemCell" + name)) continue;
                            meta = i;
                            break;
                        }
                        if (player.field_71071_by.func_70441_a(stack1 = new ItemStack(IUItem.cell.func_77973_b(), 1, meta))) {
                            --stack.field_77994_a;
                            world.func_147468_f(x, y, z);
                            player.field_71069_bz.func_75142_b();
                        }
                    }
                }
            } else {
                FluidStack fs = FluidContainerRegistry.getFluidForFilledItem((ItemStack)stack);
                ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[position.field_72310_e];
                if (LiquidUtil.placeFluid(fs, world, x, y, z) || player.func_82247_a(x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ, position.field_72310_e, stack) && LiquidUtil.placeFluid(fs, world, x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ)) {
                    if (!player.field_71075_bZ.field_75098_d) {
                        --stack.field_77994_a;
                    }
                    ItemStack stack1 = new ItemStack(IUItem.cell.func_77973_b(), 1, 0);
                    if (!player.field_71075_bZ.field_75098_d) {
                        player.field_71071_by.func_70441_a(stack1);
                    }
                    player.field_71069_bz.func_75142_b();
                    return true;
                }
            }
        }
        return false;
    }

    private ItemStack addCell(int meta, String name, Block ... blocks) {
        this.names.put(meta, name);
        ItemStack ret = new ItemStack((Item)this, 1, meta);
        for (Block block : blocks) {
            this.cells.put(block, ret);
        }
        return ret;
    }

    private ItemStack addRegisterCell(int meta, String name, String blockName) {
        ItemStack ret = this.addCell(meta, name, BlocksItems.getFluidBlock(blockName));
        FluidContainerRegistry.registerFluidContainer((Fluid)BlocksItems.getFluid(blockName), (ItemStack)ret.func_77946_l(), (ItemStack)IUItem.cell.func_77946_l());
        return ret;
    }

    @Override
    public ItemStack getItemEmpty() {
        return new ItemStack((Item)this, 1, 0);
    }
}

