/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.item.armour;

import cofh.api.energy.IEnergyContainerItem;
import com.brandon3055.draconicevolution.common.utills.IConfigurableItem;
import com.denfop.IUCore;
import com.denfop.IUItem;
import com.denfop.config.ArmorsConfig;
import com.denfop.config.IUConfig;
import com.denfop.item.energy.ItemBattery;
import com.denfop.item.energy.ItemMagnet;
import com.denfop.proxy.CommonProxy;
import com.denfop.utils.EnumInfoUpgradeModules;
import com.denfop.utils.Helpers;
import com.denfop.utils.KeyboardClient;
import com.denfop.utils.NBTData;
import com.denfop.utils.SomeUtils;
import com.event.EventUtils;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.item.ElectricItem;
import ic2.api.item.ICustomDamageItem;
import ic2.api.item.IElectricItem;
import ic2.api.item.IItemHudInfo;
import ic2.api.item.IMetalArmor;
import ic2.core.IC2;
import ic2.core.IC2Potion;
import ic2.core.init.MainConfig;
import ic2.core.util.Config;
import ic2.core.util.ConfigUtil;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import org.lwjgl.input.Keyboard;

public class ItemArmorImprovemedQuantum
extends ItemArmor
implements ISpecialArmor,
IElectricItem,
IItemHudInfo,
ICustomDamageItem,
IMetalArmor {
    protected static final Map<Integer, Integer> potionRemovalCost = new HashMap<Integer, Integer>();
    protected final double maxCharge;
    protected final double transferLimit;
    protected final int tier;
    private final ThreadLocal<Boolean> allowDamaging;
    private final String armorName;
    private IIcon[] textures;
    private float jumpCharge;

    public ItemArmorImprovemedQuantum(String name, int armorType, double maxCharge, double transferLimit, int tier) {
        super(ItemArmor.ArmorMaterial.DIAMOND, IUCore.proxy.addArmor(name), armorType);
        if (armorType == 3) {
            MinecraftForge.EVENT_BUS.register((Object)this);
        }
        potionRemovalCost.put(Potion.field_76436_u.field_76415_H, 100);
        potionRemovalCost.put(IC2Potion.radiation.field_76415_H, 20);
        potionRemovalCost.put(Potion.field_82731_v.field_76415_H, 100);
        potionRemovalCost.put(Potion.field_76438_s.field_76415_H, 200);
        this.allowDamaging = new ThreadLocal();
        this.maxCharge = maxCharge;
        this.tier = tier;
        this.transferLimit = transferLimit;
        this.func_77656_e(27);
        this.func_77625_d(1);
        this.setNoRepair();
        this.armorName = name;
        this.func_77655_b(name);
        this.func_77637_a(IUCore.TAB_ITEMS);
        GameRegistry.registerItem((Item)this, (String)name);
    }

    public static boolean hasCompleteHazmat(EntityLivingBase living) {
        for (int i = 1; i < 5; ++i) {
            ItemStack stack = living.func_71124_b(i);
            if (stack != null && stack.func_77973_b() instanceof ItemArmorImprovemedQuantum) continue;
            return false;
        }
        return true;
    }

    public List<String> getHudInfo(ItemStack itemStack) {
        LinkedList<String> info = new LinkedList<String>();
        info.add(ElectricItem.manager.getToolTip(itemStack));
        info.add(StatCollector.func_74838_a((String)"ic2.item.tooltip.PowerTier") + " " + this.tier);
        return info;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(ItemStack itemStack, int pass) {
        return SomeUtils.mode(itemStack, this.textures);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        String name = this.func_77658_a();
        this.textures = new IIcon[6];
        this.textures[0] = iconRegister.func_94245_a("industrialupgrade:" + name);
        this.textures[1] = iconRegister.func_94245_a("industrialupgrade:" + name + "_zelen");
        this.textures[2] = iconRegister.func_94245_a("industrialupgrade:" + name + "_demon");
        this.textures[3] = iconRegister.func_94245_a("industrialupgrade:" + name + "_dark");
        this.textures[4] = iconRegister.func_94245_a("industrialupgrade:" + name + "_cold");
        this.textures[5] = iconRegister.func_94245_a("industrialupgrade:" + name + "_ender");
    }

    public String getArmorTexture(ItemStack stack, Entity entity, int slot, String type) {
        int suffix = this.field_77881_a == 2 ? 2 : 1;
        NBTTagCompound nbtData = NBTData.getOrCreateNbtData(stack);
        if (!nbtData.func_74779_i("mode").isEmpty()) {
            return "industrialupgrade:textures/armor/" + this.armorName + "_" + nbtData.func_74779_i("mode") + "_" + suffix + ".png";
        }
        return "industrialupgrade:textures/armor/" + this.armorName + "_" + suffix + ".png";
    }

    public String func_77658_a() {
        return "supersolarpanels." + super.func_77658_a().substring(5);
    }

    public String func_77667_c(ItemStack itemStack) {
        return this.func_77658_a();
    }

    public String func_77653_i(ItemStack itemStack) {
        return StatCollector.func_74838_a((String)this.func_77667_c(itemStack));
    }

    public boolean isMetalArmor(ItemStack itemstack, EntityPlayer player) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs var2, List var3) {
        ItemStack var4 = new ItemStack((Item)this, 1);
        ElectricItem.manager.charge(var4, 2.147483647E9, Integer.MAX_VALUE, true, false);
        var3.add(var4);
        var3.add(new ItemStack((Item)this, 1, this.func_77612_l()));
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77623_v() {
        return true;
    }

    public boolean func_82816_b_(ItemStack aStack) {
        return this.func_82814_b(aStack) != 10511680;
    }

    @Optional.Method(modid="Thaumcraft")
    public boolean showIngamePopups(ItemStack itemstack, EntityLivingBase player) {
        return IConfigurableItem.ProfileHelper.getBoolean((ItemStack)itemstack, (String)"GogglesOfRevealing", (boolean)true);
    }

    @Optional.Method(modid="Thaumcraft")
    public boolean showNodes(ItemStack itemstack, EntityLivingBase player) {
        return IConfigurableItem.ProfileHelper.getBoolean((ItemStack)itemstack, (String)"GogglesOfRevealing", (boolean)true);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77618_c(int par1, int par2) {
        return this.func_77617_a(par1);
    }

    public void func_82815_c(ItemStack par1ItemStack) {
        NBTTagCompound tNBT = par1ItemStack.func_77978_p();
        if (tNBT != null && (tNBT = tNBT.func_74775_l("display")).func_74764_b("color")) {
            tNBT.func_82580_o("color");
        }
    }

    public int func_82814_b(ItemStack aStack) {
        NBTTagCompound tNBT = aStack.func_77978_p();
        if (tNBT == null) {
            return 10511680;
        }
        return (tNBT = tNBT.func_74775_l("display")) == null ? 10511680 : (tNBT.func_74764_b("color") ? tNBT.func_74762_e("color") : 10511680);
    }

    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, ItemStack armor, DamageSource source, double damage, int slot) {
        if (ArmorsConfig.enable_imp_quantum_protection) {
            double absorptionRatio = this.getBaseAbsorptionRatio() * this.getDamageAbsorptionRatio();
            NBTTagCompound nbt = SomeUtils.getNBT(armor);
            int protect = 0;
            for (int i = 0; i < 4; ++i) {
                if (!nbt.func_74779_i("mode_module" + i).equals("protect")) continue;
                ++protect;
            }
            protect = Math.min(protect, EnumInfoUpgradeModules.PROTECTION.max);
            int energyPerDamage = (int)((double)this.getEnergyPerDamage() - (double)this.getEnergyPerDamage() * 0.2 * (double)protect);
            int damageLimit = (int)(energyPerDamage > 0 ? 25.0 * ElectricItem.manager.getCharge(armor) / (double)energyPerDamage : 0.0);
            return new ISpecialArmor.ArmorProperties(0, absorptionRatio, damageLimit);
        }
        if (source == DamageSource.field_76379_h && this.field_77881_a == 3) {
            NBTTagCompound nbt = SomeUtils.getNBT(armor);
            int protect = 0;
            for (int i = 0; i < 4; ++i) {
                if (!nbt.func_74779_i("mode_module" + i).equals("protect")) continue;
                ++protect;
            }
            protect = Math.min(protect, EnumInfoUpgradeModules.PROTECTION.max);
            int energyPerDamage = (int)((double)this.getEnergyPerDamage() - (double)this.getEnergyPerDamage() * 0.2 * (double)protect);
            int damageLimit = Integer.MAX_VALUE;
            if (energyPerDamage > 0) {
                damageLimit = (int)Math.min((double)damageLimit, 25.0 * ElectricItem.manager.getCharge(armor) / (double)energyPerDamage);
            }
            return new ISpecialArmor.ArmorProperties(10, 1.0, damageLimit);
        }
        return this.getProperties1(armor, source);
    }

    public ISpecialArmor.ArmorProperties getProperties1(ItemStack armor, DamageSource source) {
        if (source.func_76363_c()) {
            return new ISpecialArmor.ArmorProperties(0, 0.0, 0);
        }
        double absorptionRatio = this.getBaseAbsorptionRatio() * this.getDamageAbsorptionRatio();
        int energyPerDamage = this.getEnergyPerDamage();
        int damageLimit = Integer.MAX_VALUE;
        if (energyPerDamage > 0) {
            damageLimit = (int)Math.min((double)damageLimit, 25.0 * ElectricItem.manager.getCharge(armor) / (double)energyPerDamage);
        }
        return new ISpecialArmor.ArmorProperties(0, absorptionRatio, damageLimit);
    }

    public void damageArmor(EntityLivingBase entity, ItemStack stack, DamageSource source, int damage, int slot) {
        NBTTagCompound nbt = SomeUtils.getNBT(stack);
        int protect = 0;
        for (int i = 0; i < 4; ++i) {
            if (!nbt.func_74779_i("mode_module" + i).equals("protect")) continue;
            ++protect;
        }
        protect = Math.min(protect, EnumInfoUpgradeModules.PROTECTION.max);
        ElectricItem.manager.discharge(stack, (double)damage * ((double)this.getEnergyPerDamage() - (double)this.getEnergyPerDamage() * 0.2 * (double)protect) * 2.0, Integer.MAX_VALUE, true, false, false);
    }

    public Item getChargedItem(ItemStack itemStack) {
        return this;
    }

    public Item getEmptyItem(ItemStack itemStack) {
        return this;
    }

    @SubscribeEvent
    public void onEntityLivingFallEvent(LivingFallEvent event) {
        EntityLivingBase entity;
        ItemStack armor;
        Entity entity2;
        if (IC2.platform.isSimulating() && (entity2 = event.entity) instanceof EntityLivingBase && (armor = (entity = (EntityLivingBase)entity2).func_71124_b(1)) != null && armor.func_77973_b() == this) {
            int fallDamage = Math.max((int)event.distance - 10, 0);
            double energyCost = this.getEnergyPerDamage() * fallDamage;
            if (energyCost <= ElectricItem.manager.getCharge(armor)) {
                ElectricItem.manager.discharge(armor, energyCost, Integer.MAX_VALUE, true, false, false);
                event.setCanceled(true);
            }
        }
    }

    public ItemStack func_77659_a(ItemStack itemStack, World world, EntityPlayer entityplayer) {
        if (this.field_77881_a == 1) {
            if (entityplayer.func_70093_af()) {
                if (IC2.platform.isSimulating()) {
                    int mode = SomeUtils.nbtGetInteger(itemStack, "mode1");
                    if (++mode > 2 || mode < 0) {
                        mode = 0;
                    }
                    SomeUtils.nbtSetInteger(itemStack, "mode1", mode);
                    CommonProxy.sendPlayerMessage(entityplayer, EnumChatFormatting.GREEN + Helpers.formatMessage("message.text.mode") + ": " + Helpers.formatMessage("message.magnet.mode." + mode));
                    return itemStack;
                }
            } else {
                return super.func_77659_a(itemStack, world, entityplayer);
            }
        }
        return itemStack;
    }

    public double getDamageAbsorptionRatio() {
        if (this.field_77881_a == 1) {
            return 1.1;
        }
        return 1.0;
    }

    private double getBaseAbsorptionRatio() {
        return 0.7;
    }

    public int getEnergyPerDamage() {
        return 25000;
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.epic;
    }

    public boolean canProvideEnergy(ItemStack itemStack) {
        return true;
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack itemStack) {
        NBTTagCompound nbtData = NBTData.getOrCreateNbtData(itemStack);
        byte toggleTimer = nbtData.func_74771_c("toggleTimer");
        boolean ret = false;
        int resistance = 0;
        int repaired = 0;
        for (int i = 0; i < 4; ++i) {
            if (nbtData.func_74779_i("mode_module" + i).equals("invisibility")) {
                player.func_70690_d(new PotionEffect(Potion.field_76441_p.field_76415_H, 300));
            }
            if (nbtData.func_74779_i("mode_module" + i).equals("resistance")) {
                ++resistance;
            }
            if (!nbtData.func_74779_i("mode_module" + i).equals("repaired")) continue;
            ++repaired;
        }
        if (repaired != 0 && world.field_73011_w.getWorldTime() % 80L == 0L) {
            ElectricItem.manager.charge(itemStack, this.getMaxCharge(itemStack) * 1.0E-5 * (double)repaired, Integer.MAX_VALUE, true, false);
        }
        if (resistance != 0) {
            player.func_70690_d(new PotionEffect(Potion.field_76429_m.field_76415_H, 300, resistance));
        }
        switch (this.field_77881_a) {
            case 0: {
                IC2.platform.profilerStartSection("QuantumHelmet");
                int air = player.func_70086_ai();
                if (ElectricItem.manager.canUse(itemStack, 1000.0) && air < 100) {
                    player.func_70050_g(air + 200);
                    ElectricItem.manager.use(itemStack, 1000.0, null);
                    ret = true;
                } else if (air <= 0) {
                    IC2.achievements.issueAchievement(player, "starveWithQHelmet");
                }
                if (ElectricItem.manager.canUse(itemStack, 1000.0) && player.func_71024_bL().func_75121_c()) {
                    int slot = -1;
                    for (int i = 0; i < player.field_71071_by.field_70462_a.length; ++i) {
                        if (player.field_71071_by.field_70462_a[i] == null || !(player.field_71071_by.field_70462_a[i].func_77973_b() instanceof ItemFood)) continue;
                        slot = i;
                        break;
                    }
                    if (slot > -1) {
                        ItemStack stack = player.field_71071_by.field_70462_a[slot];
                        ItemFood can = (ItemFood)stack.func_77973_b();
                        stack = can.func_77654_b(stack, world, player);
                        if (stack.field_77994_a <= 0) {
                            player.field_71071_by.field_70462_a[slot] = null;
                        }
                        ElectricItem.manager.use(itemStack, 1000.0, null);
                        ret = true;
                    }
                } else if (player.func_71024_bL().func_75116_a() <= 0) {
                    IC2.achievements.issueAchievement(player, "starveWithQHelmet");
                }
                for (PotionEffect effect : new LinkedList(player.func_70651_bq())) {
                    int id = effect.func_76456_a();
                    Integer cost = potionRemovalCost.get(id);
                    if (cost == null || !ElectricItem.manager.canUse(itemStack, (double)(cost = Integer.valueOf(cost * (effect.func_76458_c() + 1))).intValue())) continue;
                    ElectricItem.manager.use(itemStack, (double)cost.intValue(), null);
                    IC2.platform.removePotion((EntityLivingBase)player, id);
                }
                boolean nightvision = nbtData.func_74767_n("nightvision");
                short hubmode = nbtData.func_74765_d("HudMode");
                if (IC2.keyboard.isAltKeyDown(player) && IC2.keyboard.isModeSwitchKeyDown(player) && toggleTimer == 0) {
                    toggleTimer = 10;
                    boolean bl = nightvision = !nightvision;
                    if (IC2.platform.isSimulating()) {
                        nbtData.func_74757_a("nightvision", nightvision);
                        if (nightvision) {
                            IC2.platform.messagePlayer(player, "\u041d\u043e\u0447\u043d\u043e\u0435 \u0437\u0440\u0435\u043d\u0438\u0435 \u0432\u043a\u043b\u044e\u0447\u0435\u043d\u043e", new Object[0]);
                        } else {
                            IC2.platform.messagePlayer(player, "\u041d\u043e\u0447\u043d\u043e\u0435 \u0437\u0440\u0435\u043d\u0438\u0435 \u043e\u0442\u043a\u043b\u044e\u0447\u0435\u043d\u043e", new Object[0]);
                        }
                    }
                }
                if (IC2.keyboard.isAltKeyDown(player) && IC2.keyboard.isHudModeKeyDown(player) && toggleTimer == 0) {
                    toggleTimer = 10;
                    hubmode = hubmode == 2 ? (short)0 : (short)(hubmode + 1);
                    if (IC2.platform.isSimulating()) {
                        nbtData.func_74777_a("HudMode", hubmode);
                        switch (hubmode) {
                            case 0: {
                                IC2.platform.messagePlayer(player, "HUD \u043e\u0442\u043a\u043b\u044e\u0447\u0451\u043d.", new Object[0]);
                                break;
                            }
                            case 1: {
                                IC2.platform.messagePlayer(player, "HUD (\u0431\u0430\u0437\u043e\u0432\u044b\u0439) \u0432\u043a\u043b\u044e\u0447\u0451\u043d.", new Object[0]);
                                break;
                            }
                            case 2: {
                                IC2.platform.messagePlayer(player, "HUD (\u0440\u0430\u0441\u0448\u0438\u0440\u0435\u043d\u043d\u044b\u0439) \u0432\u043a\u043b\u044e\u0447\u0451\u043d", new Object[0]);
                            }
                        }
                    }
                }
                if (IC2.platform.isSimulating() && toggleTimer > 0) {
                    toggleTimer = (byte)(toggleTimer - 1);
                    nbtData.func_74774_a("toggleTimer", toggleTimer);
                }
                if (nightvision && IC2.platform.isSimulating() && ElectricItem.manager.use(itemStack, 1.0, (EntityLivingBase)player)) {
                    int x = MathHelper.func_76128_c((double)player.field_70165_t);
                    int z = MathHelper.func_76128_c((double)player.field_70161_v);
                    int y = MathHelper.func_76128_c((double)player.field_70163_u);
                    int skylight = player.field_70170_p.func_72957_l(x, y, z);
                    if (skylight > 8) {
                        IC2.platform.removePotion((EntityLivingBase)player, Potion.field_76439_r.field_76415_H);
                    } else {
                        player.func_70690_d(new PotionEffect(Potion.field_76439_r.field_76415_H, 300, 0, true));
                    }
                    ret = true;
                }
                NBTTagCompound nbt = SomeUtils.getNBT(itemStack);
                boolean waterBreathing = false;
                for (int i = 0; i < 4; ++i) {
                    if (!nbt.func_74779_i("mode_module" + i).equals("waterBreathing")) continue;
                    waterBreathing = true;
                    break;
                }
                if (waterBreathing) {
                    player.func_70690_d(new PotionEffect(Potion.field_76427_o.field_76415_H, 300));
                }
                IC2.platform.profilerEndSection();
                break;
            }
            case 1: {
                IEnergyContainerItem item;
                boolean magnet;
                if (nbtData.func_74767_n("jetpack")) {
                    if (ElectricItem.manager.canUse(itemStack, 25.0)) {
                        ElectricItem.manager.use(itemStack, 25.0, null);
                    } else {
                        nbtData.func_74757_a("jetpack", false);
                    }
                }
                boolean jetpack = nbtData.func_74767_n("jetpack");
                boolean vertical = nbtData.func_74767_n("vertical");
                boolean hoverMode = nbtData.func_74767_n("hoverMode");
                if (IC2.keyboard.isJumpKeyDown(player) && IC2.keyboard.isModeSwitchKeyDown(player) && toggleTimer == 0) {
                    ItemStack jetpack1 = player.field_71071_by.field_70460_b[2];
                    ElectricItem.manager.discharge(jetpack1, 3000.0, Integer.MAX_VALUE, true, false, false);
                    toggleTimer = 10;
                    boolean bl = hoverMode = !hoverMode;
                    if (IC2.platform.isSimulating()) {
                        nbtData.func_74757_a("hoverMode", hoverMode);
                        if (hoverMode) {
                            IC2.platform.messagePlayer(player, "\u0420\u0435\u0436\u0438\u043c \u043f\u043b\u0430\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f \u0432\u043a\u043b\u044e\u0447\u0451\u043d.", new Object[0]);
                        } else {
                            IC2.platform.messagePlayer(player, "\u0420\u0435\u0436\u0438\u043c \u043f\u043b\u0430\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f \u0432\u044b\u043a\u043b\u044e\u0447\u0435\u043d.", new Object[0]);
                        }
                    }
                }
                if (IUCore.keyboard.isVerticalMode(player) && toggleTimer == 0) {
                    toggleTimer = 10;
                    boolean bl = vertical = !vertical;
                    if (IC2.platform.isSimulating()) {
                        nbtData.func_74757_a("vertical", vertical);
                        if (vertical) {
                            IC2.platform.messagePlayer(player, "\u0412\u0435\u0440\u0442\u0438\u043a\u0430\u043b\u044c\u043d\u044b\u0439 \u0440\u0435\u0436\u0438\u043c \u0432\u043a\u043b\u044e\u0447\u0451\u043d.", new Object[0]);
                        } else {
                            IC2.platform.messagePlayer(player, "\u0412\u0435\u0440\u0442\u0438\u043a\u0430\u043b\u044c\u043d\u044b\u0435 \u0440\u0435\u0436\u0438\u043c \u0432\u044b\u043a\u043b\u044e\u0447\u0435\u043d.", new Object[0]);
                        }
                    }
                }
                if (vertical && jetpack) {
                    double motion = 0.0;
                    if (IC2.keyboard.isJumpKeyDown(player)) {
                        motion = 0.3;
                    }
                    if (player.func_70093_af()) {
                        motion = -0.3;
                    }
                    player.field_70181_x += motion;
                }
                if (nbtData.func_74767_n("magnet")) {
                    int mode = SomeUtils.nbtGetInteger(itemStack, "mode1");
                    int radius = 11;
                    if (mode != 0) {
                        AxisAlignedBB axisalignedbb = AxisAlignedBB.func_72330_a((double)(player.field_70165_t - (double)radius), (double)(player.field_70163_u - (double)radius), (double)(player.field_70161_v - (double)radius), (double)(player.field_70165_t + (double)radius), (double)(player.field_70163_u + (double)radius), (double)(player.field_70161_v + (double)radius));
                        List list = world.func_72872_a(EntityItem.class, axisalignedbb);
                        for (Entity entityItem : list) {
                            ItemStack stack;
                            String displayName;
                            if (player.field_70170_p.field_72995_K || !(entityItem instanceof EntityItem)) continue;
                            EntityItem item2 = (EntityItem)entityItem;
                            if (EventUtils.EVENTS.cantBreak(player, item2.field_70165_t, item2.field_70163_u, item2.field_70161_v) || (displayName = (stack = item2.func_92059_d()).func_82833_r()).contains("QuickShop") || !ElectricItem.manager.canUse(itemStack, 700.0)) continue;
                            if (!(stack.func_77973_b() instanceof ItemMagnet)) {
                                boolean zcoord;
                                boolean xcoord = item2.field_70165_t + 2.0 >= player.field_70165_t && item2.field_70165_t - 2.0 <= player.field_70165_t;
                                boolean bl = zcoord = item2.field_70161_v + 2.0 >= player.field_70161_v && item2.field_70161_v - 2.0 <= player.field_70161_v;
                                if (mode == 1) {
                                    if (player.field_71071_by.func_70441_a(stack)) {
                                        ElectricItem.manager.use(itemStack, 1000.0, (EntityLivingBase)player);
                                    } else if (!xcoord && !zcoord) {
                                        item2.func_70107_b(player.field_70165_t, player.field_70163_u - 1.0, player.field_70161_v);
                                        item2.field_145804_b = 5;
                                        world.func_147479_m((int)player.field_70165_t, (int)player.field_70163_u - 1, (int)player.field_70161_v);
                                    }
                                } else if (mode == 2 && !xcoord && !zcoord) {
                                    item2.func_70107_b(player.field_70165_t, player.field_70163_u - 1.0, player.field_70161_v);
                                    item2.field_145804_b = 5;
                                    world.func_147479_m((int)player.field_70165_t, (int)player.field_70163_u - 1, (int)player.field_70161_v);
                                }
                            }
                            player.field_71069_bz.func_75142_b();
                        }
                    }
                }
                if (IUCore.keyboard.isStreakKeyDown(player) && toggleTimer == 0) {
                    toggleTimer = 10;
                    player.openGui((Object)IUCore.instance, 4, player.field_70170_p, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
                }
                boolean bl = magnet = !nbtData.func_74767_n("magnet");
                if (IUCore.keyboard.isChangeKeyDown(player) && IC2.keyboard.isSneakKeyDown(player) && toggleTimer == 0) {
                    toggleTimer = 10;
                    if (IC2.platform.isSimulating()) {
                        if (magnet) {
                            IC2.platform.messagePlayer(player, "\u0420\u0435\u0436\u0438\u043c \u043c\u0430\u0433\u043d\u0438\u0442\u0430 \u0432\u043a\u043b\u044e\u0447\u0451\u043d", new Object[0]);
                        }
                        if (!magnet) {
                            IC2.platform.messagePlayer(player, "\u0420\u0435\u0436\u0438\u043c \u043c\u0430\u0433\u043d\u0438\u0442\u0430 \u043e\u0442\u043a\u043b\u044e\u0447\u0451\u043d", new Object[0]);
                        }
                        nbtData.func_74757_a("magnet", magnet);
                    }
                }
                if (IUCore.keyboard.isFlyModeKeyDown(player) && toggleTimer == 0) {
                    toggleTimer = 10;
                    boolean bl2 = jetpack = !jetpack;
                    if (IC2.platform.isSimulating()) {
                        nbtData.func_74757_a("jetpack", jetpack);
                        if (jetpack) {
                            IC2.platform.messagePlayer(player, "\u0414\u0436\u0435\u0442\u043f\u0430\u043a \u0432\u043a\u043b\u044e\u0447\u0451\u043d", new Object[0]);
                            player.field_71075_bZ.field_75100_b = true;
                            player.field_71075_bZ.field_75101_c = true;
                            player.field_70143_R = 0.0f;
                            player.field_70140_Q = 0.0f;
                        } else {
                            IC2.platform.messagePlayer(player, "\u0414\u0436\u0435\u0442\u043f\u0430\u043a \u0432\u044b\u043a\u043b\u044e\u0447\u0435\u043d.", new Object[0]);
                        }
                    }
                }
                for (int i = 0; i < player.field_71071_by.field_70460_b.length; ++i) {
                    double sentPacket;
                    if (player.field_71071_by.field_70460_b[i] != null && player.field_71071_by.field_70460_b[i].func_77973_b() instanceof IElectricItem && ElectricItem.manager.getCharge(itemStack) > 0.0 && (sentPacket = ElectricItem.manager.charge(player.field_71071_by.field_70460_b[i], ElectricItem.manager.getCharge(itemStack), Integer.MAX_VALUE, true, false)) > 0.0) {
                        ElectricItem.manager.discharge(itemStack, sentPacket, Integer.MAX_VALUE, true, false, false);
                        ret = true;
                    }
                    if (player.field_71071_by.field_70460_b[i] == null || !(player.field_71071_by.field_70460_b[i].func_77973_b() instanceof IEnergyContainerItem) || !(ElectricItem.manager.getCharge(itemStack) > 0.0) || (item = (IEnergyContainerItem)player.field_71071_by.field_70460_b[i].func_77973_b()) == null) continue;
                    int amountRfCanBeReceivedIncludesLimit = item.receiveEnergy(player.field_71071_by.field_70460_b[i], Integer.MAX_VALUE, true);
                    double realSentEnergyRF = Math.min((double)amountRfCanBeReceivedIncludesLimit, ElectricItem.manager.getCharge(itemStack) * (double)IUConfig.coefficient_rf_eu);
                    item.receiveEnergy(player.field_71071_by.field_70460_b[i], (int)realSentEnergyRF, false);
                    ElectricItem.manager.discharge(itemStack, realSentEnergyRF / (double)IUConfig.coefficient_rf_eu, Integer.MAX_VALUE, true, false, false);
                }
                for (int j = 0; j < player.field_71071_by.field_70462_a.length; ++j) {
                    double sentPacket;
                    if (player.field_71071_by.field_70462_a[j] != null && player.field_71071_by.field_70462_a[j].func_77973_b() instanceof IElectricItem && (!(player.field_71071_by.field_70462_a[j].func_77973_b() instanceof ItemBattery) || !((ItemBattery)player.field_71071_by.field_70462_a[j].func_77973_b()).wirellesCharge) && ElectricItem.manager.getCharge(itemStack) > 0.0 && (sentPacket = ElectricItem.manager.charge(player.field_71071_by.field_70462_a[j], ElectricItem.manager.getCharge(itemStack), Integer.MAX_VALUE, true, false)) > 0.0) {
                        ElectricItem.manager.discharge(itemStack, sentPacket, Integer.MAX_VALUE, true, false, false);
                        ret = true;
                    }
                    if (player.field_71071_by.field_70462_a[j] == null || !(player.field_71071_by.field_70462_a[j].func_77973_b() instanceof IEnergyContainerItem) || !(ElectricItem.manager.getCharge(itemStack) > 0.0) || (item = (IEnergyContainerItem)player.field_71071_by.field_70462_a[j].func_77973_b()) == null) continue;
                    int amountRfCanBeReceivedIncludesLimit = item.receiveEnergy(player.field_71071_by.field_70462_a[j], Integer.MAX_VALUE, true);
                    double realSentEnergyRF = Math.min((double)amountRfCanBeReceivedIncludesLimit, ElectricItem.manager.getCharge(itemStack) * (double)IUConfig.coefficient_rf_eu);
                    item.receiveEnergy(player.field_71071_by.field_70462_a[j], (int)realSentEnergyRF, false);
                    ElectricItem.manager.discharge(itemStack, realSentEnergyRF / (double)IUConfig.coefficient_rf_eu, Integer.MAX_VALUE, true, false, false);
                }
                if (IC2.platform.isSimulating() && toggleTimer > 0) {
                    toggleTimer = (byte)(toggleTimer - 1);
                    nbtData.func_74774_a("toggleTimer", toggleTimer);
                }
                NBTTagCompound nbt = SomeUtils.getNBT(itemStack);
                boolean fireResistance = false;
                for (int i = 0; i < 4; ++i) {
                    if (!nbt.func_74779_i("mode_module" + i).equals("fireResistance")) continue;
                    fireResistance = true;
                    break;
                }
                if (fireResistance) {
                    player.func_70690_d(new PotionEffect(Potion.field_76426_n.field_76415_H, 300));
                }
                if (ret) {
                    player.field_71069_bz.func_75142_b();
                }
                player.func_70066_B();
                break;
            }
            case 2: {
                IC2.platform.profilerStartSection("QuantumLeggings");
                boolean enableQuantumSpeedOnSprint = IC2.platform.isRendering() ? ConfigUtil.getBool((Config)MainConfig.get(), (String)"misc/quantumSpeedOnSprint") : true;
                if (ElectricItem.manager.canUse(itemStack, 1000.0) && (player.field_70122_E || player.func_70090_H()) && IC2.keyboard.isForwardKeyDown(player) && (enableQuantumSpeedOnSprint && player.func_70051_ag() || !enableQuantumSpeedOnSprint && IC2.keyboard.isBoostKeyDown(player))) {
                    byte speedTicker = nbtData.func_74771_c("speedTicker");
                    if ((speedTicker = (byte)(speedTicker + 1)) >= 10) {
                        speedTicker = 0;
                        ElectricItem.manager.use(itemStack, 1000.0, null);
                        ret = true;
                    }
                    nbtData.func_74774_a("speedTicker", speedTicker);
                    float speed = 0.22f;
                    if (player.func_70090_H()) {
                        speed = 0.1f;
                        if (IC2.keyboard.isJumpKeyDown(player)) {
                            player.field_70181_x += (double)0.1f;
                        }
                    }
                    player.func_70060_a(0.0f, 1.0f, speed);
                }
                NBTTagCompound nbt = SomeUtils.getNBT(itemStack);
                boolean moveSpeed = false;
                for (int i = 0; i < 4; ++i) {
                    if (!nbt.func_74779_i("mode_module" + i).equals("moveSpeed")) continue;
                    moveSpeed = true;
                    break;
                }
                if (moveSpeed) {
                    player.func_70690_d(new PotionEffect(Potion.field_76424_c.field_76415_H, 300));
                }
                IC2.platform.profilerEndSection();
                break;
            }
            case 3: {
                IC2.platform.profilerStartSection("QuantumBoots");
                if (IC2.platform.isSimulating()) {
                    boolean wasOnGround;
                    boolean bl = wasOnGround = !nbtData.func_74764_b("wasOnGround") || nbtData.func_74767_n("wasOnGround");
                    if (wasOnGround && !player.field_70122_E && IC2.keyboard.isJumpKeyDown(player) && IC2.keyboard.isBoostKeyDown(player)) {
                        ElectricItem.manager.use(itemStack, 4000.0, null);
                        ret = true;
                    }
                    if (player.field_70122_E != wasOnGround) {
                        nbtData.func_74757_a("wasOnGround", player.field_70122_E);
                    }
                } else {
                    if (ElectricItem.manager.canUse(itemStack, 4000.0) && player.field_70122_E) {
                        this.jumpCharge = 1.0f;
                    }
                    if (player.field_70181_x >= 0.0 && this.jumpCharge > 0.0f && !player.func_70090_H()) {
                        if (IC2.keyboard.isJumpKeyDown(player) && IC2.keyboard.isBoostKeyDown(player)) {
                            if (this.jumpCharge == 1.0f) {
                                player.field_70159_w *= 3.5;
                                player.field_70179_y *= 3.5;
                            }
                            player.field_70181_x += (double)(this.jumpCharge * 0.3f);
                            this.jumpCharge = (float)((double)this.jumpCharge * 0.75);
                        } else if (this.jumpCharge < 1.0f) {
                            this.jumpCharge = 0.0f;
                        }
                    }
                }
                NBTTagCompound nbt = SomeUtils.getNBT(itemStack);
                boolean jump = false;
                for (int i = 0; i < 4; ++i) {
                    if (!nbt.func_74779_i("mode_module" + i).equals("jump")) continue;
                    jump = true;
                    break;
                }
                if (jump) {
                    player.func_70690_d(new PotionEffect(Potion.field_76430_j.field_76415_H, 300));
                }
                IC2.platform.profilerEndSection();
            }
        }
        if (ret) {
            player.field_71069_bz.func_75142_b();
        }
    }

    public double getMaxCharge(ItemStack itemStack) {
        return this.maxCharge;
    }

    public int getTier(ItemStack itemStack) {
        return this.tier;
    }

    public double getTransferLimit(ItemStack itemStack) {
        return this.transferLimit;
    }

    public boolean func_82789_a(ItemStack par1ItemStack, ItemStack par2ItemStack) {
        return false;
    }

    public void func_77624_a(ItemStack itemStack, EntityPlayer player, List info, boolean b) {
        NBTTagCompound nbtData = NBTData.getOrCreateNbtData(itemStack);
        if (itemStack.func_77973_b() == IUItem.quantumBodyarmor) {
            info.add(StatCollector.func_74838_a((String)"iu.fly") + " " + SomeUtils.getBoolean(nbtData.func_74767_n("jetpack")));
            if (!Keyboard.isKeyDown((int)42)) {
                info.add(StatCollector.func_74838_a((String)"press.lshift"));
            }
            if (Keyboard.isKeyDown((int)42)) {
                info.add(StatCollector.func_74838_a((String)"iu.changemode_fly") + ": " + Keyboard.getKeyName((int)KeyboardClient.flymode.func_151463_i()));
                info.add(StatCollector.func_74838_a((String)"iu.vertical") + ": " + Keyboard.getKeyName((int)KeyboardClient.verticalmode.func_151463_i()));
                info.add(StatCollector.func_74838_a((String)"iu.streak") + ": " + Keyboard.getKeyName((int)KeyboardClient.streakmode.func_151463_i()));
                info.add(StatCollector.func_74838_a((String)"iu.magnet_mode") + ": " + Keyboard.getKeyName((int)KeyboardClient.changemode.func_151463_i()) + " + " + Keyboard.getKeyName((int)42));
            }
            for (PotionEffect effect : new LinkedList(player.func_70651_bq())) {
                int id = effect.func_76456_a();
                if (id != Potion.field_76426_n.field_76415_H) continue;
                info.add(StatCollector.func_74838_a((String)"iu.effect") + " " + SomeUtils.getBoolean(true));
            }
        }
        SomeUtils.mode(itemStack, info);
    }

    public int getArmorDisplay(EntityPlayer player, ItemStack armor, int slot) {
        if (ElectricItem.manager.getCharge(armor) >= (double)this.getEnergyPerDamage()) {
            return (int)Math.round(20.0 * this.getBaseAbsorptionRatio() * this.getDamageAbsorptionRatio());
        }
        return 0;
    }

    public int getCustomDamage(ItemStack stack) {
        return stack.func_77960_j();
    }

    public int getMaxCustomDamage(ItemStack stack) {
        return stack.func_77958_k();
    }

    public void setCustomDamage(ItemStack stack, int damage) {
        this.allowDamaging.set(Boolean.TRUE);
        stack.func_77964_b(damage);
        this.allowDamaging.set(Boolean.FALSE);
    }

    public boolean applyCustomDamage(ItemStack stack, int damage, EntityLivingBase src) {
        if (src != null) {
            stack.func_77972_a(damage, src);
            return true;
        }
        return stack.func_96631_a(damage, IC2.random);
    }
}

