/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.item.energy;

import com.denfop.IUCore;
import com.denfop.audio.PositionSpec;
import com.denfop.utils.EnumInfoUpgradeModules;
import com.denfop.utils.KeyboardClient;
import com.denfop.utils.SomeUtils;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import ic2.core.IC2;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.client.resources.I18n;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.ArrowLooseEvent;
import net.minecraftforge.event.entity.player.ArrowNockEvent;
import org.lwjgl.input.Keyboard;

public class EnergyBow
extends ItemBow
implements IElectricItem {
    static final int[] CHARGE = new int[]{1500, 750, 2000, 5000, 1000};
    static final String[] MODE = new String[]{"normal", "rapidfire", "spread", "sniper", "flame"};
    private static float type;
    public final IIcon[] icons;
    private final String name;
    private final double nanoBowBoost;
    private final int tier;
    private final int transferenergy;
    private final int maxenergy;

    public EnergyBow(String name, double nanoBowBoost, int tier, int transferenergy, int maxenergy, float type) {
        this.func_77656_e(27);
        this.func_77664_n();
        this.func_77637_a(IUCore.TAB_ITEMS);
        this.icons = new IIcon[4];
        this.name = name;
        this.nanoBowBoost = nanoBowBoost;
        this.tier = tier;
        this.transferenergy = transferenergy;
        this.maxenergy = maxenergy;
        EnergyBow.type = type;
        this.func_77655_b(name);
        GameRegistry.registerItem((Item)this, (String)name);
    }

    public static float getArrowVelocity(int charge) {
        float f = (float)charge / 20.0f;
        f = (f * f + f * 2.0f) / 3.0f;
        return Math.min(f, 1.5f);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List tooltip, boolean advanced) {
        NBTTagCompound nbt = SomeUtils.getNBT(stack);
        IElectricItem item = (IElectricItem)stack.func_77973_b();
        if (!nbt.func_74767_n("loaded")) {
            if (nbt.func_74762_e("tier") == 0) {
                nbt.func_74768_a("tier", item.getTier(stack));
            }
            if (nbt.func_74769_h("transferLimit") == 0.0) {
                nbt.func_74780_a("transferLimit", item.getTransferLimit(stack));
            }
            if (nbt.func_74769_h("maxCharge") == 0.0) {
                nbt.func_74780_a("maxCharge", item.getMaxCharge(stack));
            }
            nbt.func_74757_a("loaded", true);
        }
        if (nbt.func_74769_h("transferLimit") != item.getTransferLimit(stack)) {
            tooltip.add(String.format(I18n.func_135052_a((String)"info.transferspeed", (Object[])new Object[0]), nbt.func_74769_h("transferLimit")));
        }
        if (nbt.func_74762_e("tier") != item.getTier(stack)) {
            tooltip.add(String.format(I18n.func_135052_a((String)"info.chargingtier", (Object[])new Object[0]), nbt.func_74762_e("tier")));
        }
        if (!Keyboard.isKeyDown((int)42)) {
            tooltip.add(StatCollector.func_74838_a((String)"press.lshift"));
        }
        if (Keyboard.isKeyDown((int)42)) {
            tooltip.add(StatCollector.func_74838_a((String)"iu.changemode_key") + " " + Keyboard.getKeyName((int)KeyboardClient.changemode.func_151463_i()) + StatCollector.func_74838_a((String)"iu.changemode_rcm"));
        }
    }

    public void func_150895_a(Item item, CreativeTabs tabs, List items) {
        ItemStack charged = new ItemStack((Item)this, 1);
        ElectricItem.manager.charge(charged, 2.147483647E9, Integer.MAX_VALUE, true, false);
        items.add(charged);
        items.add(new ItemStack((Item)this, 1, this.func_77612_l()));
    }

    public boolean isRepairable() {
        return false;
    }

    public int func_77619_b() {
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister ir) {
        this.icons[0] = ir.func_94245_a("industrialupgrade:" + this.name);
        this.icons[1] = ir.func_94245_a("industrialupgrade:" + this.name + "_1");
        this.icons[2] = ir.func_94245_a("industrialupgrade:" + this.name + "_2");
        this.icons[3] = ir.func_94245_a("industrialupgrade:" + this.name + "_3");
        this.field_77791_bV = this.icons[0];
    }

    public IIcon getIcon(ItemStack stack, int renderPass, EntityPlayer player, ItemStack usingItem, int useRemaining) {
        if (usingItem != null) {
            NBTTagCompound nbt = SomeUtils.getNBT(stack);
            int mode = nbt.func_74762_e("bowMode");
            int i1 = 18;
            int i2 = 13;
            if (mode == 3) {
                i1 = 36;
                i2 = 26;
            } else if (mode == 1) {
                i1 = 5;
                i2 = 3;
            }
            int k = usingItem.func_77988_m() - useRemaining;
            if (k >= i1) {
                return this.icons[3];
            }
            if (k > i2) {
                return this.icons[2];
            }
            if (k > 0) {
                return this.icons[1];
            }
        }
        return this.icons[0];
    }

    public void func_77615_a(ItemStack stack, World world, EntityPlayer player, int timeLeft) {
        float f;
        NBTTagCompound nbt = SomeUtils.getNBT(stack);
        int mode = nbt.func_74762_e("bowMode");
        int charge = this.func_77626_a(stack) - timeLeft;
        ArrowLooseEvent event = new ArrowLooseEvent(player, stack, charge);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.isCanceled()) {
            return;
        }
        charge = event.charge;
        if (mode == 3) {
            charge /= 2;
        }
        if (mode == 1) {
            charge *= 4;
        }
        if ((double)(f = EnergyBow.getArrowVelocity(charge)) < 0.1) {
            return;
        }
        if (!world.field_72995_K) {
            EntityArrow arrow = new EntityArrow(world, (EntityLivingBase)player, f);
            if (f == 1.5f) {
                arrow.func_70243_d(true);
            }
            int bowdamage = 0;
            for (int i = 0; i < 4; ++i) {
                if (!nbt.func_74779_i("mode_module" + i).equals("bowdamage")) continue;
                ++bowdamage;
            }
            bowdamage = Math.min(bowdamage, EnumInfoUpgradeModules.BOWDAMAGE.max);
            arrow.func_70239_b(arrow.func_70242_d() + (double)type * 2.5 + 0.5 + (double)type * 2.5 * 0.25 * (double)bowdamage);
            int j = EnchantmentHelper.func_77506_a((int)Enchantment.field_77345_t.field_77352_x, (ItemStack)stack);
            if (j > 0) {
                arrow.func_70239_b(arrow.func_70242_d() + (double)j * 0.5 + 0.5);
            }
            if (mode == 0 && arrow.func_70241_g()) {
                j += 3;
            } else if (mode == 1 && arrow.func_70241_g()) {
                ++j;
            } else if (mode == 3 && arrow.func_70241_g()) {
                j += 8;
            }
            if (j > 0) {
                arrow.func_70239_b(arrow.func_70242_d() + (double)j * 0.5 + 0.5);
            }
            if (this.nanoBowBoost > 0.0) {
                arrow.func_70239_b(arrow.func_70242_d() + this.nanoBowBoost * 0.5 + 0.5);
            }
            int k = EnchantmentHelper.func_77506_a((int)Enchantment.field_77344_u.field_77352_x, (ItemStack)stack);
            if (mode == 0 && arrow.func_70241_g()) {
                ++k;
            } else if (mode == 3 && arrow.func_70241_g()) {
                k += 5;
            }
            if (k > 0) {
                arrow.func_70240_a(k);
            }
            if (EnchantmentHelper.func_77506_a((int)Enchantment.field_77343_v.field_77352_x, (ItemStack)stack) > 0) {
                arrow.func_70015_d(100);
            }
            if (mode == 4 && arrow.func_70241_g()) {
                arrow.func_70015_d(2000);
            }
            arrow.field_70251_a = 2;
            int bowenergy = 0;
            for (int i = 0; i < 4; ++i) {
                if (!nbt.func_74779_i("mode_module" + i).equals("bowenergy")) continue;
                ++bowenergy;
            }
            bowenergy = Math.min(bowenergy, EnumInfoUpgradeModules.BOWENERGY.max);
            if (mode == 2) {
                if (ElectricItem.manager.canUse(stack, (double)CHARGE[mode] - (double)CHARGE[mode] * 0.1 * (double)bowenergy)) {
                    ElectricItem.manager.use(stack, (double)CHARGE[mode] - (double)CHARGE[mode] * 0.1 * (double)bowenergy, (EntityLivingBase)player);
                    world.func_72838_d((Entity)arrow);
                    if (arrow.func_70241_g()) {
                        EntityArrow arrow2 = new EntityArrow(world, (EntityLivingBase)player, f * 2.0f);
                        arrow2.func_70107_b(arrow2.field_70165_t + 0.25, arrow2.field_70163_u, arrow2.field_70161_v);
                        arrow2.func_70243_d(true);
                        arrow2.field_70251_a = 2;
                        EntityArrow arrow3 = new EntityArrow(world, (EntityLivingBase)player, f * 2.0f);
                        arrow3.func_70107_b(arrow3.field_70165_t, arrow3.field_70163_u + 0.25, arrow3.field_70161_v);
                        arrow3.func_70243_d(true);
                        arrow3.field_70251_a = 2;
                        EntityArrow arrow4 = new EntityArrow(world, (EntityLivingBase)player, f * 2.0f);
                        arrow4.func_70107_b(arrow4.field_70165_t - 0.25, arrow4.field_70163_u, arrow4.field_70161_v);
                        arrow4.func_70243_d(true);
                        arrow4.field_70251_a = 2;
                        EntityArrow arrow5 = new EntityArrow(world, (EntityLivingBase)player, f * 2.0f);
                        arrow5.func_70107_b(arrow5.field_70165_t, arrow5.field_70163_u - 0.25, arrow5.field_70161_v);
                        arrow5.func_70243_d(true);
                        arrow5.field_70251_a = 2;
                        world.func_72838_d((Entity)arrow2);
                        world.func_72838_d((Entity)arrow3);
                        world.func_72838_d((Entity)arrow4);
                        world.func_72838_d((Entity)arrow5);
                    }
                }
            } else if (ElectricItem.manager.canUse(stack, (double)CHARGE[mode] - (double)CHARGE[mode] * 0.1 * (double)bowenergy)) {
                ElectricItem.manager.use(stack, (double)CHARGE[mode] - (double)CHARGE[mode] * 0.1 * (double)bowenergy, (EntityLivingBase)player);
                world.func_72838_d((Entity)arrow);
            }
        }
        if (IC2.platform.isRendering()) {
            IUCore.audioManager.playOnce(player, PositionSpec.Hand, "Tools/bow.ogg", true, IC2.audioManager.getDefaultVolume());
        }
    }

    public int func_77626_a(ItemStack stack) {
        int n;
        NBTTagCompound nbt = SomeUtils.getNBT(stack);
        switch (nbt.func_74762_e("bowMode")) {
            case 3: 
            case 5: {
                n = 144000;
                break;
            }
            case 1: {
                n = 18000;
                break;
            }
            default: {
                n = 72000;
            }
        }
        return n;
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        NBTTagCompound nbt = SomeUtils.getNBT(stack);
        int mode = nbt.func_74762_e("bowMode");
        int bowenergy = 0;
        for (int i = 0; i < 4; ++i) {
            if (!nbt.func_74779_i("mode_module" + i).equals("bowenergy")) continue;
            ++bowenergy;
        }
        bowenergy = Math.min(bowenergy, EnumInfoUpgradeModules.BOWENERGY.max);
        if (IUCore.keyboard.isChangeKeyDown(player) && nbt.func_74771_c("toggleTimer") == 0) {
            if (!world.field_72995_K) {
                byte toggle = 10;
                nbt.func_74774_a("toggleTimer", toggle);
                if (++mode > 4) {
                    mode = 0;
                }
                nbt.func_74768_a("bowMode", mode);
                player.func_145747_a((IChatComponent)new ChatComponentTranslation("info.nanobow." + MODE[mode], new Object[0]));
            }
        } else if (player.field_71075_bZ.field_75098_d || ElectricItem.manager.canUse(stack, (double)CHARGE[mode] - (double)CHARGE[mode] * 0.1 * (double)bowenergy)) {
            player.func_71008_a(stack, this.func_77626_a(stack));
        }
        ArrowNockEvent event = new ArrowNockEvent(player, stack);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.isCanceled()) {
            return event.result;
        }
        return stack;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        NBTTagCompound nbt = SomeUtils.getNBT(stack);
        byte toggle = nbt.func_74771_c("toggleTimer");
        if (toggle > 0) {
            toggle = (byte)(toggle - 1);
            nbt.func_74774_a("toggleTimer", toggle);
        }
    }

    public void onUsingTick(ItemStack stack, EntityPlayer player, int i) {
        NBTTagCompound nbt = SomeUtils.getNBT(stack);
        int mode = nbt.func_74762_e("bowMode");
        if (mode == 1) {
            int bowenergy = 0;
            for (int k = 0; k < 4; ++k) {
                if (!nbt.func_74779_i("mode_module" + k).equals("bowenergy")) continue;
                ++bowenergy;
            }
            bowenergy = Math.min(bowenergy, EnumInfoUpgradeModules.BOWENERGY.max);
            int j = this.func_77626_a(stack) - i;
            if (j >= 10 && ElectricItem.manager.canUse(stack, (double)CHARGE[1] - (double)CHARGE[1] * 0.1 * (double)bowenergy)) {
                player.func_71034_by();
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.uncommon;
    }

    public boolean canProvideEnergy(ItemStack is) {
        return false;
    }

    public double getMaxCharge(ItemStack stack) {
        NBTTagCompound nbt = SomeUtils.getNBT(stack);
        if (nbt.func_74769_h("maxCharge") == 0.0) {
            nbt.func_74780_a("maxCharge", (double)this.getDefaultMaxCharge());
        }
        return nbt.func_74769_h("maxCharge");
    }

    public int getTier(ItemStack stack) {
        NBTTagCompound nbt = SomeUtils.getNBT(stack);
        if (nbt.func_74762_e("tier") == 0) {
            nbt.func_74768_a("tier", this.getDefaultTier());
        }
        return nbt.func_74762_e("tier");
    }

    public double getTransferLimit(ItemStack stack) {
        NBTTagCompound nbt = SomeUtils.getNBT(stack);
        if (nbt.func_74769_h("transferLimit") == 0.0) {
            nbt.func_74780_a("transferLimit", (double)this.getDefaultTransferLimit());
        }
        return nbt.func_74769_h("transferLimit");
    }

    public Item getChargedItem(ItemStack stack) {
        return stack == null ? null : stack.func_77973_b();
    }

    public Item getEmptyItem(ItemStack stack) {
        return stack == null ? null : stack.func_77973_b();
    }

    public int getDefaultMaxCharge() {
        return this.maxenergy;
    }

    public int getDefaultTier() {
        return this.tier;
    }

    public int getDefaultTransferLimit() {
        return this.transferenergy;
    }
}

