/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.item.energy;

import com.denfop.IUCore;
import com.denfop.proxy.CommonProxy;
import com.denfop.utils.Helpers;
import com.denfop.utils.SomeUtils;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import ic2.api.item.IItemHudInfo;
import ic2.core.IC2;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import org.lwjgl.input.Keyboard;

public class ItemBattery
extends Item
implements IElectricItem,
IItemHudInfo {
    public final boolean wirellesCharge;
    protected final double maxCharge;
    protected final double transferLimit;
    protected final int tier;
    protected IIcon[] textures;
    private int rarity;

    public ItemBattery(String name, double maxCharge, double transferLimit, int tier, boolean wirellescharge) {
        this.maxCharge = maxCharge;
        this.transferLimit = transferLimit;
        this.tier = tier;
        this.func_77656_e(27);
        this.func_77625_d(1);
        this.setNoRepair();
        this.func_77655_b(name);
        this.setRarity(1);
        this.func_77637_a(IUCore.TAB_ITEMS);
        this.wirellesCharge = wirellescharge;
        GameRegistry.registerItem((Item)this, (String)name);
    }

    public void setRarity(int aRarity) {
        this.rarity = aRarity;
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.values()[this.rarity];
    }

    public String getTextureName(int index) {
        if (index < 5) {
            return this.func_77658_a().substring(3) + index;
        }
        return null;
    }

    public String func_77658_a() {
        return "iu" + super.func_77658_a().substring(4);
    }

    public String func_77667_c(ItemStack itemStack) {
        return this.func_77658_a();
    }

    public String func_77653_i(ItemStack itemStack) {
        return StatCollector.func_74838_a((String)this.func_77667_c(itemStack));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        int indexCount = 0;
        while (this.getTextureName(indexCount) != null) {
            if (++indexCount <= Short.MAX_VALUE) continue;
            throw new RuntimeException("More Item Icons than actually possible @ " + this.func_77658_a());
        }
        this.textures = new IIcon[indexCount];
        for (int index = 0; index < indexCount; ++index) {
            this.textures[index] = iconRegister.func_94245_a("industrialupgrade:" + this.getTextureName(index));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77617_a(int meta) {
        if (meta <= 1) {
            return this.textures[4];
        }
        if (meta >= this.func_77612_l() - 1) {
            return this.textures[0];
        }
        return this.textures[3 - 3 * (meta - 2) / (this.func_77612_l() - 4 + 1)];
    }

    public boolean canProvideEnergy(ItemStack itemStack) {
        return true;
    }

    public double getTransferLimit(ItemStack itemStack) {
        return this.transferLimit;
    }

    public void func_77663_a(ItemStack itemStack, World p_77663_2_, Entity p_77663_3_, int p_77663_4_, boolean p_77663_5_) {
        if (!(p_77663_3_ instanceof EntityPlayer)) {
            return;
        }
        if (this.wirellesCharge) {
            int mode = SomeUtils.nbtGetInteger(itemStack, "mode");
            EntityPlayer entityplayer = (EntityPlayer)p_77663_3_;
            if (mode == 1) {
                if (IC2.platform.isSimulating()) {
                    boolean transferred = false;
                    for (int i = 0; i < 9; ++i) {
                        double transfer;
                        ItemStack stack = entityplayer.field_71071_by.field_70462_a[i];
                        if (stack == null || stack.func_77973_b() instanceof ic2.core.item.ItemBattery || (transfer = ElectricItem.manager.discharge(itemStack, 2.0 * this.transferLimit, Integer.MAX_VALUE, true, true, true)) <= 0.0 || (transfer = ElectricItem.manager.charge(stack, transfer, Integer.MAX_VALUE, true, false)) <= 0.0) continue;
                        ElectricItem.manager.discharge(itemStack, transfer, Integer.MAX_VALUE, true, true, false);
                        transferred = true;
                    }
                    if (transferred && !IC2.platform.isRendering()) {
                        entityplayer.field_71070_bA.func_75142_b();
                    }
                }
            } else if (mode == 2) {
                if (IC2.platform.isSimulating()) {
                    boolean transferred = false;
                    for (int i = 0; i < entityplayer.field_71071_by.field_70462_a.length; ++i) {
                        double transfer;
                        ItemStack stack = entityplayer.field_71071_by.field_70462_a[i];
                        if (stack == null || stack.func_77973_b() instanceof ic2.core.item.ItemBattery || (transfer = ElectricItem.manager.discharge(itemStack, 2.0 * this.transferLimit, Integer.MAX_VALUE, true, true, true)) <= 0.0 || (transfer = ElectricItem.manager.charge(stack, transfer, Integer.MAX_VALUE, true, false)) <= 0.0) continue;
                        ElectricItem.manager.discharge(itemStack, transfer, Integer.MAX_VALUE, true, true, false);
                        transferred = true;
                    }
                    if (transferred && !IC2.platform.isRendering()) {
                        entityplayer.field_71070_bA.func_75142_b();
                    }
                }
            } else if (mode == 3) {
                if (IC2.platform.isSimulating()) {
                    boolean transferred = false;
                    for (int i = 0; i < entityplayer.field_71071_by.field_70460_b.length; ++i) {
                        double transfer;
                        ItemStack stack = entityplayer.field_71071_by.field_70460_b[i];
                        if (stack == null || stack.func_77973_b() instanceof ic2.core.item.ItemBattery || (transfer = ElectricItem.manager.discharge(itemStack, 2.0 * this.transferLimit, Integer.MAX_VALUE, true, true, true)) <= 0.0 || (transfer = ElectricItem.manager.charge(stack, transfer, Integer.MAX_VALUE, true, false)) <= 0.0) continue;
                        ElectricItem.manager.discharge(itemStack, transfer, Integer.MAX_VALUE, true, true, false);
                        transferred = true;
                    }
                    if (transferred && !IC2.platform.isRendering()) {
                        entityplayer.field_71070_bA.func_75142_b();
                    }
                }
            } else if (mode == 4) {
                double transfer;
                ItemStack stack;
                int i;
                boolean transferred;
                if (IC2.platform.isSimulating()) {
                    transferred = false;
                    for (i = 0; i < entityplayer.field_71071_by.field_70460_b.length; ++i) {
                        stack = entityplayer.field_71071_by.field_70460_b[i];
                        if (stack == null || stack.func_77973_b() instanceof ic2.core.item.ItemBattery || (transfer = ElectricItem.manager.discharge(itemStack, 2.0 * this.transferLimit, Integer.MAX_VALUE, true, true, true)) <= 0.0 || (transfer = ElectricItem.manager.charge(stack, transfer, Integer.MAX_VALUE, true, false)) <= 0.0) continue;
                        ElectricItem.manager.discharge(itemStack, transfer, Integer.MAX_VALUE, true, true, false);
                        transferred = true;
                    }
                    if (transferred && !IC2.platform.isRendering()) {
                        entityplayer.field_71070_bA.func_75142_b();
                    }
                }
                if (IC2.platform.isSimulating()) {
                    transferred = false;
                    for (i = 0; i < entityplayer.field_71071_by.field_70462_a.length; ++i) {
                        stack = entityplayer.field_71071_by.field_70462_a[i];
                        if (stack == null || stack.func_77973_b() instanceof ic2.core.item.ItemBattery || (transfer = ElectricItem.manager.discharge(itemStack, 2.0 * this.transferLimit, Integer.MAX_VALUE, true, true, true)) <= 0.0 || (transfer = ElectricItem.manager.charge(stack, transfer, Integer.MAX_VALUE, true, false)) <= 0.0) continue;
                        ElectricItem.manager.discharge(itemStack, transfer, Integer.MAX_VALUE, true, true, false);
                        transferred = true;
                    }
                    if (transferred && !IC2.platform.isRendering()) {
                        entityplayer.field_71070_bA.func_75142_b();
                    }
                }
            }
        }
    }

    public boolean hasEffect(ItemStack par1ItemStack, int pass) {
        int mode = SomeUtils.nbtGetInteger(par1ItemStack, "mode");
        return mode != 0;
    }

    public ItemStack func_77659_a(ItemStack itemStack, World world, EntityPlayer entityplayer) {
        if (IC2.platform.isSimulating() && this.wirellesCharge) {
            int mode = SomeUtils.nbtGetInteger(itemStack, "mode");
            if (++mode > 4 || mode < 0) {
                mode = 0;
            }
            SomeUtils.nbtSetInteger(itemStack, "mode", mode);
            CommonProxy.sendPlayerMessage(entityplayer, EnumChatFormatting.GREEN + Helpers.formatMessage("message.text.mode") + ": " + Helpers.formatMessage("message.battery.mode." + mode));
        }
        return itemStack;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List par3List, boolean par4) {
        super.func_77624_a(par1ItemStack, par2EntityPlayer, par3List, par4);
        if (this.wirellesCharge) {
            if (!Keyboard.isKeyDown((int)42)) {
                par3List.add(StatCollector.func_74838_a((String)"press.lshift"));
            }
            if (Keyboard.isKeyDown((int)42)) {
                par3List.add(StatCollector.func_74838_a((String)"iu.changemodebattery"));
            }
        }
    }

    public Item getChargedItem(ItemStack itemStack) {
        return this;
    }

    public List<String> getHudInfo(ItemStack itemStack) {
        LinkedList<String> info = new LinkedList<String>();
        info.add(ElectricItem.manager.getToolTip(itemStack));
        return info;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs par2CreativeTabs, List itemList) {
        ItemStack charged;
        ItemStack itemStack = new ItemStack((Item)this, 1);
        if (this.getChargedItem(itemStack) == this) {
            charged = new ItemStack((Item)this, 1);
            ElectricItem.manager.charge(charged, Double.POSITIVE_INFINITY, Integer.MAX_VALUE, true, false);
            itemList.add(charged);
        }
        if (this.getEmptyItem(itemStack) == this) {
            charged = new ItemStack((Item)this, 1);
            ElectricItem.manager.charge(charged, 0.0, Integer.MAX_VALUE, true, false);
            itemList.add(charged);
        }
    }

    public double getMaxCharge(ItemStack itemStack) {
        return this.maxCharge;
    }

    public int getTier(ItemStack itemStack) {
        return this.tier;
    }

    public Item getEmptyItem(ItemStack itemStack) {
        return itemStack.func_77973_b();
    }
}

