/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.item.energy;

import com.denfop.IUCore;
import com.denfop.utils.EnumInfoUpgradeModules;
import com.denfop.utils.SomeUtils;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.item.ElectricItem;
import ic2.api.item.IBoxable;
import ic2.api.item.IElectricItem;
import ic2.api.item.IItemHudInfo;
import ic2.core.IC2;
import ic2.core.item.armor.ItemArmorNanoSuit;
import ic2.core.item.armor.ItemArmorQuantumSuit;
import ic2.core.util.StackUtil;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import org.lwjgl.input.Keyboard;

public class ItemQuantumSaber
extends ItemTool
implements IElectricItem,
IBoxable,
IItemHudInfo {
    public static final int ticker = 0;
    public static int activedamage;
    private static int damage1;
    public final int maxCharge;
    public final int transferLimit;
    public final int tier;
    private final EnumSet<ToolClass> toolClasses = EnumSet.of(ToolClass.Sword);
    @SideOnly(value=Side.CLIENT)
    private IIcon[] textures;
    private int soundTicker = 0;

    public ItemQuantumSaber(String internalName, int maxCharge, int transferLimit, int tier, int activedamage, int damage) {
        this(internalName, HarvestLevel.Diamond, maxCharge, transferLimit, tier, activedamage, damage);
    }

    public ItemQuantumSaber(String name, HarvestLevel harvestLevel, int maxCharge, int transferLimit, int tier, int activedamage, int damage) {
        super(0.0f, harvestLevel.toolMaterial, null);
        this.maxCharge = maxCharge;
        this.transferLimit = transferLimit;
        this.tier = tier;
        ItemQuantumSaber.activedamage = activedamage;
        damage1 = damage;
        this.func_77656_e(27);
        this.func_77625_d(1);
        this.setNoRepair();
        this.func_77655_b(name);
        this.func_77637_a(IUCore.TAB_ITEMS);
        for (ToolClass toolClass : this.toolClasses) {
            if (toolClass.name == null) continue;
            this.setHarvestLevel(toolClass.name, harvestLevel.level);
        }
        GameRegistry.registerItem((Item)this, (String)name);
    }

    public static void drainSaber(ItemStack itemStack, double amount, EntityLivingBase entity) {
        NBTTagCompound nbt = SomeUtils.getNBT(itemStack);
        int saberenergy = 0;
        for (int i = 0; i < 4; ++i) {
            if (!nbt.func_74779_i("mode_module" + i).equals("saberenergy")) continue;
            ++saberenergy;
        }
        if (!ElectricItem.manager.use(itemStack, amount - amount * 0.15 * (double)(saberenergy = Math.min(saberenergy, EnumInfoUpgradeModules.SABERENERGY.max)), entity)) {
            NBTTagCompound nbtData = StackUtil.getOrCreateNbtData((ItemStack)itemStack);
            nbtData.func_74757_a("active", false);
            ItemQuantumSaber.updateAttributes(nbtData);
        }
    }

    private static void updateAttributes(NBTTagCompound nbtData) {
        boolean active = nbtData.func_74767_n("active");
        int saberdamage = 0;
        for (int i = 0; i < 4; ++i) {
            if (!nbtData.func_74779_i("mode_module" + i).equals("saberdamage")) continue;
            ++saberdamage;
        }
        saberdamage = Math.min(saberdamage, EnumInfoUpgradeModules.SABER_DAMAGE.max);
        int damage = (int)((double)damage1 + (double)damage1 * 0.15 * (double)saberdamage);
        if (active) {
            damage = (int)((double)activedamage + (double)activedamage * 0.15 * (double)saberdamage);
        }
        NBTTagCompound entry = new NBTTagCompound();
        entry.func_74778_a("AttributeName", SharedMonsterAttributes.field_111264_e.func_111108_a());
        entry.func_74772_a("UUIDMost", field_111210_e.getMostSignificantBits());
        entry.func_74772_a("UUIDLeast", field_111210_e.getLeastSignificantBits());
        entry.func_74778_a("Name", "Tool modifier");
        entry.func_74780_a("Amount", (double)damage);
        entry.func_74768_a("Operation", 0);
        NBTTagList list = new NBTTagList();
        list.func_74742_a((NBTBase)entry);
        nbtData.func_74782_a("AttributeModifiers", (NBTBase)list);
    }

    public void func_77624_a(ItemStack itemStack, EntityPlayer player, List info, boolean b) {
        info.add(StatCollector.func_74838_a((String)"iu.spectralsaberactive") + " " + activedamage);
        info.add(StatCollector.func_74838_a((String)"ic2.item.tooltip.PowerTier") + " " + this.tier);
        info.add(StatCollector.func_74838_a((String)"iu.maxCharge") + " " + this.maxCharge + " EU");
        info.add(StatCollector.func_74838_a((String)"iu.transferLimit") + " " + this.transferLimit);
        if (!Keyboard.isKeyDown((int)42)) {
            info.add(StatCollector.func_74838_a((String)"press.lshift"));
        }
        if (Keyboard.isKeyDown((int)42)) {
            info.add(StatCollector.func_74838_a((String)"iu.saberon"));
        }
    }

    public double getMaxCharge(ItemStack itemStack) {
        return this.maxCharge;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        this.textures = new IIcon[2];
        this.textures[0] = iconRegister.func_94245_a("industrialupgrade:" + this.func_77658_a().substring(3) + ".off");
        this.textures[1] = iconRegister.func_94245_a("industrialupgrade:" + this.func_77658_a().substring(3) + ".active");
    }

    public boolean canProvideEnergy(ItemStack itemStack) {
        return true;
    }

    public int func_77619_b() {
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, List subs) {
        ItemStack stack = new ItemStack((Item)this, 1);
        ElectricItem.manager.charge(stack, 2.147483647E9, Integer.MAX_VALUE, true, false);
        subs.add(stack);
        ItemStack itemstack = new ItemStack((Item)this, 1, this.func_77612_l());
        subs.add(itemstack);
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack var1) {
        return EnumRarity.uncommon;
    }

    public Item getChargedItem(ItemStack itemStack) {
        return this;
    }

    public Item getEmptyItem(ItemStack itemStack) {
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77623_v() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(ItemStack itemStack, int pass) {
        NBTTagCompound nbtData = StackUtil.getOrCreateNbtData((ItemStack)itemStack);
        if (nbtData.func_74767_n("active")) {
            return this.textures[1];
        }
        return this.textures[0];
    }

    public float getDigSpeed(ItemStack itemStack, Block block, int meta) {
        NBTTagCompound nbtData = StackUtil.getOrCreateNbtData((ItemStack)itemStack);
        if (nbtData.func_74767_n("active")) {
            ++this.soundTicker;
            if (this.soundTicker % 4 == 0) {
                IC2.platform.playSoundSp(this.getRandomSwingSound(), 1.0f, 1.0f);
            }
            return 4.0f;
        }
        return 1.0f;
    }

    public Multimap<Object, Object> getAttributeModifiers(ItemStack stack) {
        NBTTagCompound nbtData;
        NBTTagCompound nbt = SomeUtils.getNBT(stack);
        int saberdamage = 0;
        for (int i = 0; i < 4; ++i) {
            if (!nbt.func_74779_i("mode_module" + i).equals("saberdamage")) continue;
            ++saberdamage;
        }
        saberdamage = Math.min(saberdamage, EnumInfoUpgradeModules.SABER_DAMAGE.max);
        int dmg = (int)((double)damage1 + (double)damage1 * 0.15 * (double)saberdamage);
        if (ElectricItem.manager.canUse(stack, 400.0) && (nbtData = StackUtil.getOrCreateNbtData((ItemStack)stack)).func_74767_n("active")) {
            dmg = (int)((double)activedamage + (double)activedamage * 0.15 * (double)saberdamage);
        }
        HashMultimap hashMultimap = HashMultimap.create();
        hashMultimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Tool modifier", (double)dmg, 0));
        return hashMultimap;
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase source) {
        NBTTagCompound nbtData = StackUtil.getOrCreateNbtData((ItemStack)stack);
        if (!nbtData.func_74767_n("active")) {
            return true;
        }
        if (IC2.platform.isSimulating()) {
            int i;
            ItemQuantumSaber.drainSaber(stack, 400.0, source);
            NBTTagCompound nbt = SomeUtils.getNBT(stack);
            int vampires = 0;
            boolean wither = false;
            boolean poison = false;
            for (i = 0; i < 4; ++i) {
                if (nbt.func_74779_i("mode_module" + i).equals("vampires")) {
                    ++vampires;
                }
                if (nbt.func_74779_i("mode_module" + i).equals("wither")) {
                    wither = true;
                }
                if (!nbt.func_74779_i("mode_module" + i).equals("poison")) continue;
                poison = true;
            }
            if ((vampires = Math.min(vampires, EnumInfoUpgradeModules.VAMPIRES.max)) != 0) {
                target.func_70690_d(new PotionEffect(Potion.field_76428_l.field_76415_H, 40, vampires));
            }
            if (wither) {
                target.func_70690_d(new PotionEffect(Potion.field_82731_v.field_76415_H, 60));
            }
            if (poison) {
                target.func_70690_d(new PotionEffect(Potion.field_76436_u.field_76415_H, 60));
            }
            if (!(source instanceof EntityPlayer) || MinecraftServer.func_71276_C().func_71219_W() || !(target instanceof EntityPlayer)) {
                for (i = 0; i < 4 && ElectricItem.manager.canUse(stack, 2000.0); ++i) {
                    ItemStack armor = target.func_71124_b(i + 1);
                    if (armor == null) continue;
                    double amount = 0.0;
                    if (armor.func_77973_b() instanceof ItemArmorNanoSuit) {
                        amount = 48000.0;
                    } else if (armor.func_77973_b() instanceof ItemArmorQuantumSuit) {
                        amount = 300000.0;
                    }
                    if (!(amount > 0.0)) continue;
                    ElectricItem.manager.discharge(armor, amount, this.tier, true, false, false);
                    if (!ElectricItem.manager.canUse(armor, 1.0)) {
                        target.func_70062_b(i + 1, null);
                    }
                    ItemQuantumSaber.drainSaber(stack, 2000.0, source);
                }
            }
        }
        if (IC2.platform.isRendering()) {
            IC2.platform.playSoundSp(this.getRandomSwingSound(), 1.0f, 1.0f);
        }
        return true;
    }

    public String getRandomSwingSound() {
        switch (IC2.random.nextInt(3)) {
            default: {
                return "Tools/Nanosabre/NanosabreSwing1.ogg";
            }
            case 1: {
                return "Tools/Nanosabre/NanosabreSwing2.ogg";
            }
            case 2: 
        }
        return "Tools/Nanosabre/NanosabreSwing3.ogg";
    }

    public boolean onBlockStartBreak(ItemStack itemStack, int i, int j, int k, EntityPlayer player) {
        NBTTagCompound nbtData = StackUtil.getOrCreateNbtData((ItemStack)itemStack);
        if (nbtData.func_74767_n("active")) {
            ItemQuantumSaber.drainSaber(itemStack, 80.0, (EntityLivingBase)player);
        }
        return false;
    }

    public boolean func_77662_d() {
        return true;
    }

    public ItemStack func_77659_a(ItemStack itemStack, World world, EntityPlayer entityplayer) {
        if (!IC2.platform.isSimulating()) {
            return itemStack;
        }
        NBTTagCompound nbtData = StackUtil.getOrCreateNbtData((ItemStack)itemStack);
        if (nbtData.func_74767_n("active")) {
            nbtData.func_74757_a("active", false);
            ItemQuantumSaber.updateAttributes(nbtData);
        } else if (ElectricItem.manager.canUse(itemStack, 16.0)) {
            nbtData.func_74757_a("active", true);
            ItemQuantumSaber.updateAttributes(nbtData);
            IC2.platform.playSoundSp("Tools/Nanosabre/NanosabrePowerup.ogg", 1.0f, 1.0f);
        }
        return super.func_77659_a(itemStack, world, entityplayer);
    }

    public void func_77663_a(ItemStack itemStack, World world, Entity entity, int slot, boolean par5) {
        NBTTagCompound nbtData = StackUtil.getOrCreateNbtData((ItemStack)itemStack);
        if (!nbtData.func_74767_n("active")) {
            return;
        }
        int loot = 0;
        int fire = 0;
        for (int i = 0; i < 4; ++i) {
            if (nbtData.func_74779_i("mode_module" + i).equals("loot")) {
                ++loot;
            }
            if (!nbtData.func_74779_i("mode_module" + i).equals("fire")) continue;
            ++fire;
        }
        loot = Math.min(loot, EnumInfoUpgradeModules.LOOT.max);
        fire = Math.min(fire, EnumInfoUpgradeModules.FIRE.max);
        Map enchantmentMap = EnchantmentHelper.func_82781_a((ItemStack)itemStack);
        if (loot != 0) {
            enchantmentMap.put(Enchantment.field_77335_o.field_77352_x, loot);
        }
        if (fire != 0) {
            enchantmentMap.put(Enchantment.field_77334_n.field_77352_x, fire);
        }
        EnchantmentHelper.func_82782_a((Map)enchantmentMap, (ItemStack)itemStack);
        if (entity instanceof EntityPlayerMP) {
            if (slot < 9) {
                ItemQuantumSaber.drainSaber(itemStack, 64.0, (EntityLivingBase)entity);
            } else {
                ItemQuantumSaber.drainSaber(itemStack, 16.0, (EntityLivingBase)entity);
            }
        }
    }

    public String func_77658_a() {
        return "iu" + super.func_77658_a().substring(4);
    }

    public String func_77667_c(ItemStack itemStack) {
        return this.func_77658_a();
    }

    public String func_77653_i(ItemStack itemStack) {
        return StatCollector.func_74838_a((String)this.func_77667_c(itemStack));
    }

    public List<String> getHudInfo(ItemStack itemStack) {
        LinkedList<String> info = new LinkedList<String>();
        info.add(ElectricItem.manager.getToolTip(itemStack));
        info.add(StatCollector.func_74838_a((String)"ic2.item.tooltip.PowerTier") + " " + this.tier);
        return info;
    }

    public int getTier(ItemStack itemStack) {
        return this.tier;
    }

    public double getTransferLimit(ItemStack itemStack) {
        return this.transferLimit;
    }

    public boolean canHarvestBlock(Block block, ItemStack stack) {
        Material material = block.func_149688_o();
        for (ToolClass toolClass : this.toolClasses) {
            if (!toolClass.whitelist.contains(block) && !toolClass.whitelist.contains(material)) continue;
            return true;
        }
        return super.canHarvestBlock(block, stack);
    }

    public boolean canBeStoredInToolbox(ItemStack itemstack) {
        return true;
    }

    public float func_150893_a(ItemStack stack, Block block) {
        if (this.canHarvestBlock(block, stack)) {
            return this.field_77864_a;
        }
        return super.func_150893_a(stack, block);
    }

    public boolean isRepairable() {
        return false;
    }

    public boolean func_150894_a(ItemStack p_150894_1_, World p_150894_2_, Block p_150894_3_, int p_150894_4_, int p_150894_5_, int p_150894_6_, EntityLivingBase p_150894_7_) {
        return true;
    }

    protected static enum HarvestLevel {
        Diamond;

        public final int level;
        public final Item.ToolMaterial toolMaterial = Item.ToolMaterial.EMERALD;

        private HarvestLevel() {
            this.level = 3;
        }
    }

    protected static enum ToolClass {
        Sword(Blocks.field_150321_G, Material.field_151585_k, Material.field_151582_l, Material.field_151589_v, Material.field_151584_j, Material.field_151572_C);

        public final String name;
        public final Set<Object> whitelist;

        private ToolClass(Object ... whitelist) {
            this.name = "sword";
            this.whitelist = new HashSet<Object>(Arrays.asList(whitelist));
        }
    }
}

