/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.item.upgrade;

import com.denfop.IUCore;
import com.denfop.IUItem;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.item.IItemHudInfo;
import ic2.core.upgrade.IUpgradableBlock;
import ic2.core.upgrade.IUpgradeItem;
import ic2.core.upgrade.UpgradableProperty;
import ic2.core.upgrade.UpgradeRegistry;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class ItemUpgradeModule
extends Item
implements IUpgradeItem,
IItemHudInfo {
    private static final DecimalFormat decimalformat = new DecimalFormat("0.##");
    private final List<String> itemNames;
    private final IIcon[] IIconsList;

    public ItemUpgradeModule() {
        this.func_77627_a(true);
        this.func_77637_a(IUCore.TAB_ITEMS);
        IUItem.overclockerUpgrade = UpgradeRegistry.register((ItemStack)new ItemStack((Item)this, 1, Type.Overclocker1.ordinal()));
        IUItem.overclockerUpgrade1 = UpgradeRegistry.register((ItemStack)new ItemStack((Item)this, 1, Type.Overclocker2.ordinal()));
        IUItem.tranformerUpgrade = UpgradeRegistry.register((ItemStack)new ItemStack((Item)this, 1, Type.transformer.ordinal()));
        IUItem.tranformerUpgrade1 = UpgradeRegistry.register((ItemStack)new ItemStack((Item)this, 1, Type.transformer1.ordinal()));
        this.itemNames = new ArrayList<String>();
        this.IIconsList = new IIcon[4];
        this.addItemsNames();
        GameRegistry.registerItem((Item)this, (String)"upgrademodule");
    }

    public static Type getType(int meta) {
        if (meta < 0 || meta >= Type.Values.length) {
            return null;
        }
        return Type.Values[meta];
    }

    public String func_77667_c(ItemStack stack) {
        return this.itemNames.get(stack.func_77960_j());
    }

    public IIcon func_77617_a(int par1) {
        return this.IIconsList[par1];
    }

    public void addItemsNames() {
        this.itemNames.add("iu.overclockerUpgrade1");
        this.itemNames.add("iu.overclockerUpgrade2");
        this.itemNames.add("iu.transformerUpgrade1");
        this.itemNames.add("iu.transformerUpgrade2");
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister IIconRegister2) {
        this.IIconsList[0] = IIconRegister2.func_94245_a("industrialupgrade:overclockerUpgrade1");
        this.IIconsList[1] = IIconRegister2.func_94245_a("industrialupgrade:overclockerUpgrade2");
        this.IIconsList[2] = IIconRegister2.func_94245_a("industrialupgrade:transformerUpgrade1");
        this.IIconsList[3] = IIconRegister2.func_94245_a("industrialupgrade:transformerUpgrade2");
    }

    public String func_77653_i(ItemStack itemStack) {
        return StatCollector.func_74838_a((String)this.func_77667_c(itemStack));
    }

    public IIcon getIcon(ItemStack stack, int pass) {
        Type type = ItemUpgradeModule.getType(stack.func_77960_j());
        if (type == null) {
            return null;
        }
        return super.getIcon(stack, pass);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77623_v() {
        return true;
    }

    public List<String> getHudInfo(ItemStack stack) {
        LinkedList<String> info = new LinkedList<String>();
        info.add("Machine Upgrade");
        return info;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        Type type = ItemUpgradeModule.getType(stack.func_77960_j());
        if (type == null) {
            return;
        }
        super.func_77624_a(stack, player, list, par4);
        switch (type) {
            case Overclocker1: 
            case Overclocker2: {
                list.add(StatCollector.func_74837_a((String)"ic2.tooltip.upgrade.overclocker.time", (Object[])new Object[]{decimalformat.format(100.0 * Math.pow(this.getProcessTimeMultiplier(stack, null), stack.field_77994_a))}));
                list.add(StatCollector.func_74837_a((String)"ic2.tooltip.upgrade.overclocker.power", (Object[])new Object[]{decimalformat.format(100.0 * Math.pow(this.getEnergyDemandMultiplier(stack, null), stack.field_77994_a))}));
                break;
            }
            case transformer: 
            case transformer1: {
                list.add(StatCollector.func_74837_a((String)"ic2.tooltip.upgrade.transformer", (Object[])new Object[]{this.getExtraTier(stack, null) * stack.field_77994_a}));
            }
        }
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer entityplayer, World world, int x, int y, int z, int side, float xOffset, float yOffset, float zOffset) {
        return false;
    }

    public void func_150895_a(Item item, CreativeTabs tabs, List itemList) {
        for (int meta = 0; meta <= this.itemNames.size() - 1; ++meta) {
            ItemStack stack = new ItemStack((Item)this, 1, meta);
            itemList.add(stack);
        }
    }

    public boolean isSuitableFor(ItemStack stack, Set<UpgradableProperty> types) {
        boolean bl;
        Type type = ItemUpgradeModule.getType(stack.func_77960_j());
        if (type == null) {
            return false;
        }
        switch (type) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case Overclocker1: 
            case Overclocker2: {
                if (types.contains(UpgradableProperty.Processing) || types.contains(UpgradableProperty.Augmentable)) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case transformer: 
            case transformer1: {
                bl = types.contains(UpgradableProperty.Transformer);
            }
        }
        return bl;
    }

    public int getAugmentation(ItemStack stack, IUpgradableBlock parent) {
        int n;
        Type type = ItemUpgradeModule.getType(stack.func_77960_j());
        if (type == null) {
            return 0;
        }
        switch (type) {
            case Overclocker1: 
            case Overclocker2: {
                n = 1;
                break;
            }
            default: {
                n = 0;
            }
        }
        return n;
    }

    public int getExtraProcessTime(ItemStack stack, IUpgradableBlock parent) {
        return 0;
    }

    public double getProcessTimeMultiplier(ItemStack stack, IUpgradableBlock parent) {
        double d;
        Type type = ItemUpgradeModule.getType(stack.func_77960_j());
        if (type == null) {
            return 1.0;
        }
        switch (type) {
            case Overclocker1: {
                d = 0.6;
                break;
            }
            case Overclocker2: {
                d = 0.5;
                break;
            }
            default: {
                d = 1.0;
            }
        }
        return d;
    }

    public int getExtraEnergyDemand(ItemStack stack, IUpgradableBlock parent) {
        return 0;
    }

    public double getEnergyDemandMultiplier(ItemStack stack, IUpgradableBlock parent) {
        double d;
        Type type = ItemUpgradeModule.getType(stack.func_77960_j());
        if (type == null) {
            return 1.0;
        }
        switch (type) {
            case Overclocker1: {
                d = 1.9;
                break;
            }
            case Overclocker2: {
                d = 2.3;
                break;
            }
            default: {
                d = 1.0;
            }
        }
        return d;
    }

    public int getExtraEnergyStorage(ItemStack itemStack, IUpgradableBlock iUpgradableBlock) {
        return 0;
    }

    public int getExtraTier(ItemStack stack, IUpgradableBlock parent) {
        int n;
        Type type = ItemUpgradeModule.getType(stack.func_77960_j());
        if (type == null) {
            return 0;
        }
        switch (type) {
            case transformer: {
                n = 2;
                break;
            }
            case transformer1: {
                n = 4;
                break;
            }
            default: {
                n = 0;
            }
        }
        return n;
    }

    public double getEnergyStorageMultiplier(ItemStack stack, IUpgradableBlock parent) {
        return 1.0;
    }

    public boolean modifiesRedstoneInput(ItemStack stack, IUpgradableBlock parent) {
        return false;
    }

    public int getRedstoneInput(ItemStack stack, IUpgradableBlock parent, int externalInput) {
        return externalInput;
    }

    public boolean onTick(ItemStack stack, IUpgradableBlock parent) {
        return false;
    }

    public void onProcessEnd(ItemStack stack, IUpgradableBlock parent, List<ItemStack> output) {
    }

    private static enum Type {
        Overclocker1,
        Overclocker2,
        transformer,
        transformer1;

        public static final Type[] Values;

        static {
            Values = Type.values();
        }
    }
}

