/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.network;

import com.denfop.IUCore;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.FMLEventChannel;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import ic2.api.network.INetworkClientTileEntityEventListener;
import ic2.api.network.INetworkItemEventListener;
import ic2.core.ContainerBase;
import ic2.core.IC2;
import ic2.core.WorldData;
import ic2.core.network.ClientModifiable;
import ic2.core.network.DataEncoder;
import ic2.core.network.IPlayerItemDataListener;
import ic2.core.util.LogCategory;
import ic2.core.util.ReflectionUtil;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.Unpooled;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class NetworkManager {
    private static FMLEventChannel channel;

    public NetworkManager() {
        if (channel == null) {
            channel = NetworkRegistry.INSTANCE.newEventDrivenChannel("IU");
        }
        channel.register((Object)this);
    }

    private static void retrieveFieldData(Object object, String fieldName, OutputStream out) throws IOException {
        DataOutputStream os = new DataOutputStream(out);
        os.writeUTF(fieldName);
        try {
            DataEncoder.encode((DataOutputStream)os, (Object)ReflectionUtil.getValueRecursive((Object)object, (String)fieldName));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        os.flush();
    }

    private static FMLProxyPacket makePacket(byte[] data) {
        return new FMLProxyPacket(Unpooled.wrappedBuffer((byte[])data), "IU");
    }

    protected boolean isClient() {
        return false;
    }

    public void onTickEnd(World world) {
        int ticksLeftToNetworkUpdate;
        WorldData value;
        WorldData worldData = value = WorldData.get((World)world);
        value.ticksLeftToNetworkUpdate = ticksLeftToNetworkUpdate = value.ticksLeftToNetworkUpdate - 1;
        if (ticksLeftToNetworkUpdate == 0) {
            this.sendUpdatePacket(world);
            worldData.ticksLeftToNetworkUpdate = 1;
        }
    }

    public void updateTileEntityField(TileEntity tileEntity, String field) {
        if (!this.isClient()) {
            return;
        }
        Field modifiableField = this.getClientModifiableField(tileEntity.getClass(), field);
        if (modifiableField == null) {
            return;
        }
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(buffer);
        try {
            dataOutputStream.writeByte(13);
            DataEncoder.encode((DataOutputStream)dataOutputStream, (Object)tileEntity, (boolean)false);
            NetworkManager.retrieveFieldData(tileEntity, field, dataOutputStream);
            dataOutputStream.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        byte[] packetData = buffer.toByteArray();
        this.sendPacket(packetData);
    }

    private Field getClientModifiableField(Class<?> cls, String fieldName) {
        Field field = ReflectionUtil.getFieldRecursive(cls, (String)fieldName);
        if (field == null) {
            IC2.log.warn(LogCategory.Network, "Can't find field %s in %s.", new Object[]{fieldName, cls.getName()});
            return null;
        }
        if (field.getAnnotation(ClientModifiable.class) == null) {
            IC2.log.warn(LogCategory.Network, "The field %s in %s is not modifiable.", new Object[]{fieldName, cls.getName()});
            return null;
        }
        return field;
    }

    public void initiateTileEntityEvent(TileEntity te, int event, boolean limitRange) {
        if (te.func_145831_w().field_73010_i.isEmpty()) {
            return;
        }
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        DataOutputStream os = new DataOutputStream(buffer);
        try {
            os.writeByte(1);
            DataEncoder.encode((DataOutputStream)os, (Object)te, (boolean)false);
            os.writeInt(event);
            os.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        byte[] packetData = buffer.toByteArray();
        int maxDistance = limitRange ? 400 : MinecraftServer.func_71276_C().func_71203_ab().func_72372_a() + 16;
        for (Object obj : te.func_145831_w().field_73010_i) {
            if (!(obj instanceof EntityPlayerMP)) continue;
            EntityPlayerMP entityPlayer = (EntityPlayerMP)obj;
            int distanceX = te.field_145851_c - (int)entityPlayer.field_70165_t;
            int distanceZ = te.field_145849_e - (int)entityPlayer.field_70161_v;
            int distance = limitRange ? distanceX * distanceX + distanceZ * distanceZ : Math.max(Math.abs(distanceX), Math.abs(distanceZ));
            if (distance > maxDistance) continue;
            this.sendPacket(packetData, entityPlayer);
        }
    }

    public void initiateClientTileEntityEvent(TileEntity te, int event) {
    }

    private void sendUpdatePacket(World world) {
        WorldData worldData = WorldData.get((World)world);
        if (worldData.networkedFieldsToUpdate.isEmpty()) {
            return;
        }
        worldData.networkedFieldsToUpdate.clear();
    }

    @SubscribeEvent
    public void onPacket(FMLNetworkEvent.ServerCustomPacketEvent event) {
        if (this.getClass() == NetworkManager.class) {
            this.onPacketData((InputStream)new ByteBufInputStream(event.packet.payload()), (EntityPlayer)((NetHandlerPlayServer)event.handler).field_147369_b);
        }
    }

    protected void onPacketData(InputStream isRaw, EntityPlayer player) {
        try {
            if (isRaw.available() == 0) {
                return;
            }
            int id = isRaw.read();
            DataInputStream is = new DataInputStream(isRaw);
            switch (id) {
                case 1: {
                    ItemStack stack = (ItemStack)DataEncoder.decode((DataInputStream)is, ItemStack.class);
                    int event = is.readInt();
                    if (stack.func_77973_b() instanceof INetworkItemEventListener) {
                        ((INetworkItemEventListener)stack.func_77973_b()).onNetworkEvent(stack, player, event);
                    }
                    break;
                }
                case 2: {
                    int keyState = is.readInt();
                    IUCore.keyboard.processKeyUpdate(player, keyState);
                    break;
                }
                case 3: {
                    TileEntity te = (TileEntity)DataEncoder.decode((DataInputStream)is, TileEntity.class);
                    int event = is.readInt();
                    if (te instanceof INetworkClientTileEntityEventListener) {
                        ((INetworkClientTileEntityEventListener)te).onNetworkEvent(player, event);
                    }
                    break;
                }
                case 10: {
                    ItemStack itemStack;
                    byte slot = is.readByte();
                    Item item = (Item)DataEncoder.decode((DataInputStream)is, Item.class);
                    int dataCount = is.readShort();
                    Object[] subData = new Object[dataCount];
                    for (int i = 0; i < dataCount; ++i) {
                        subData[i] = DataEncoder.decode((DataInputStream)is);
                    }
                    if (slot >= 0 && slot <= 9 && (itemStack = player.field_71071_by.field_70462_a[slot]) != null && itemStack.func_77973_b() == item && item instanceof IPlayerItemDataListener) {
                        ((IPlayerItemDataListener)item).onPlayerItemNetworkData(player, (int)slot, subData);
                    }
                    break;
                }
                case 11: {
                    int windowId = DataEncoder.readVarInt((DataInputStream)is);
                    String fieldName = is.readUTF();
                    Object value = DataEncoder.decode((DataInputStream)is);
                    if (player.field_71070_bA instanceof ContainerBase && player.field_71070_bA.field_75152_c == windowId && (this.isClient() || this.getClientModifiableField(player.field_71070_bA.getClass(), fieldName) != null)) {
                        ReflectionUtil.setValueRecursive((Object)player.field_71070_bA, (String)fieldName, (Object)value);
                    }
                    break;
                }
                case 12: {
                    int windowId = DataEncoder.readVarInt((DataInputStream)is);
                    String event2 = is.readUTF();
                    if (player.field_71070_bA instanceof ContainerBase && player.field_71070_bA.field_75152_c == windowId) {
                        ((ContainerBase)player.field_71070_bA).onContainerEvent(event2);
                    }
                    break;
                }
                case 13: {
                    TileEntity te = (TileEntity)DataEncoder.decode((DataInputStream)is, TileEntity.class);
                    String fieldName = is.readUTF();
                    Object value = DataEncoder.decode((DataInputStream)is);
                    if (te == null || !this.isClient() && this.getClientModifiableField(te.getClass(), fieldName) == null) break;
                    ReflectionUtil.setValueRecursive((Object)te, (String)fieldName, (Object)value);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void initiateKeyUpdate(int keyState) {
    }

    protected void sendPacket(byte[] data) {
        if (IC2.platform.isSimulating()) {
            channel.sendToAll(NetworkManager.makePacket(data));
        } else {
            channel.sendToServer(NetworkManager.makePacket(data));
        }
    }

    protected void sendPacket(byte[] data, EntityPlayerMP player) {
        channel.sendTo(NetworkManager.makePacket(data), player);
    }
}

