/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.recipemanager;

import com.denfop.api.IGenStoneRecipeManager;
import ic2.api.recipe.IRecipeInput;
import ic2.api.recipe.RecipeOutput;
import ic2.core.util.StackUtil;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.ItemStack;

public class GenStoneRecipeManager
implements IGenStoneRecipeManager {
    private final Map<IGenStoneRecipeManager.Input, RecipeOutput> recipes = new HashMap<IGenStoneRecipeManager.Input, RecipeOutput>();

    @Override
    public void addRecipe(IRecipeInput container, IRecipeInput fill, ItemStack output) {
        if (container == null) {
            throw new NullPointerException("The container recipe input is null");
        }
        if (fill == null) {
            throw new NullPointerException("The fill recipe input is null");
        }
        if (output == null) {
            throw new NullPointerException("The recipe output is null");
        }
        if (!StackUtil.check((ItemStack)output)) {
            throw new IllegalArgumentException("The recipe output " + StackUtil.toStringSafe((ItemStack)output) + " is invalid");
        }
        for (IGenStoneRecipeManager.Input input : this.recipes.keySet()) {
            for (ItemStack containerStack : container.getInputs()) {
                for (ItemStack fillStack : fill.getInputs()) {
                    if (!input.matches(containerStack, fillStack)) continue;
                    throw new RuntimeException("ambiguous recipe: [" + container.getInputs() + "+" + fill.getInputs() + " -> " + output + "], conflicts with [" + input.container.getInputs() + "+" + input.fill.getInputs() + " -> " + this.recipes.get(input) + "]");
                }
            }
        }
        this.recipes.put(new IGenStoneRecipeManager.Input(container, fill), new RecipeOutput(null, new ItemStack[]{output}));
    }

    @Override
    public RecipeOutput getOutputFor(ItemStack container, ItemStack fill, boolean adjustInput, boolean acceptTest) {
        if (acceptTest ? container == null && fill == null : container == null || fill == null) {
            return null;
        }
        for (Map.Entry<IGenStoneRecipeManager.Input, RecipeOutput> entry : this.recipes.entrySet()) {
            IGenStoneRecipeManager.Input recipeInput = entry.getKey();
            if (acceptTest && container == null) {
                if (!recipeInput.fill.matches(fill)) continue;
                return entry.getValue();
            }
            if (acceptTest && fill == null) {
                if (!recipeInput.container.matches(container)) continue;
                return entry.getValue();
            }
            if (recipeInput.matches(container, fill)) {
                if (!acceptTest && (container.field_77994_a < recipeInput.container.getAmount() || fill.field_77994_a < recipeInput.fill.getAmount())) break;
                if (adjustInput) {
                    container.field_77994_a -= recipeInput.container.getAmount();
                    fill.field_77994_a -= recipeInput.fill.getAmount();
                }
                return entry.getValue();
            }
            if (!recipeInput.matches1(container, fill)) continue;
            if (!acceptTest && (container.field_77994_a < recipeInput.container.getAmount() || fill.field_77994_a < recipeInput.fill.getAmount())) break;
            if (adjustInput) {
                container.field_77994_a -= recipeInput.fill.getAmount();
                fill.field_77994_a -= recipeInput.container.getAmount();
            }
            return entry.getValue();
        }
        return null;
    }

    @Override
    public Map<IGenStoneRecipeManager.Input, RecipeOutput> getRecipes() {
        return this.recipes;
    }
}

