/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.recipemanager;

import com.denfop.api.IGeneratorRecipeItemmanager;
import com.denfop.utils.SomeUtils;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import ic2.api.recipe.IRecipeInput;
import ic2.api.recipe.RecipeInputItemStack;
import ic2.api.recipe.RecipeInputOreDict;
import ic2.api.recipe.RecipeOutput;
import ic2.core.IC2;
import ic2.core.init.MainConfig;
import ic2.core.util.LogCategory;
import ic2.core.util.StackUtil;
import ic2.core.util.Tuple;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.oredict.OreDictionary;
import org.jetbrains.annotations.NotNull;

public class GeneratorRecipeItemManager
implements IGeneratorRecipeItemmanager {
    private final Map<IRecipeInput, RecipeOutput> recipes = new HashMap<IRecipeInput, RecipeOutput>();
    private final Map<Item, Map<Integer, Tuple.T2<IRecipeInput, RecipeOutput>>> recipeCache = new IdentityHashMap<Item, Map<Integer, Tuple.T2<IRecipeInput, RecipeOutput>>>();
    private final List<Tuple.T2<IRecipeInput, RecipeOutput>> uncacheableRecipes = new ArrayList<Tuple.T2<IRecipeInput, RecipeOutput>>();
    private boolean oreRegisterEventSubscribed;

    @Override
    public void addRecipe(IRecipeInput input, Integer metadata, ItemStack ... outputs) {
        if (!this.addRecipe(input, metadata, false, outputs)) {
            this.displayError("ambiguous recipe: [" + input.getInputs() + " -> " + Arrays.asList(outputs) + "]");
        }
    }

    public boolean addRecipe(IRecipeInput input, Integer metadata, boolean overwrite, ItemStack ... outputs) {
        NBTTagCompound nbt = SomeUtils.createNBTTag();
        nbt.func_74768_a("amount", metadata.intValue());
        return this.addRecipe(input, new RecipeOutput(nbt, outputs), overwrite);
    }

    @Override
    public Map<IRecipeInput, RecipeOutput> getRecipes() {
        return new AbstractMap<IRecipeInput, RecipeOutput>(){

            @Override
            @NotNull
            public Set<Map.Entry<IRecipeInput, RecipeOutput>> entrySet() {
                return new AbstractSet<Map.Entry<IRecipeInput, RecipeOutput>>(){

                    @Override
                    @NotNull
                    public Iterator<Map.Entry<IRecipeInput, RecipeOutput>> iterator() {
                        return new Iterator<Map.Entry<IRecipeInput, RecipeOutput>>(){
                            private final Iterator<Map.Entry<IRecipeInput, RecipeOutput>> recipeIt;
                            private IRecipeInput lastInput;
                            {
                                this.recipeIt = GeneratorRecipeItemManager.this.recipes.entrySet().iterator();
                            }

                            @Override
                            public boolean hasNext() {
                                return this.recipeIt.hasNext();
                            }

                            @Override
                            public Map.Entry<IRecipeInput, RecipeOutput> next() {
                                Map.Entry<IRecipeInput, RecipeOutput> ret = this.recipeIt.next();
                                this.lastInput = ret.getKey();
                                return ret;
                            }

                            @Override
                            public void remove() {
                                this.recipeIt.remove();
                                GeneratorRecipeItemManager.this.removeCachedRecipes(this.lastInput);
                            }
                        };
                    }

                    @Override
                    public int size() {
                        return GeneratorRecipeItemManager.this.recipes.size();
                    }
                };
            }

            @Override
            public RecipeOutput put(IRecipeInput key, RecipeOutput value) {
                GeneratorRecipeItemManager.this.addRecipe(key, value, true);
                return null;
            }
        };
    }

    @SubscribeEvent
    public void onOreRegister(OreDictionary.OreRegisterEvent event) {
        ArrayList<Tuple.T2> datas = new ArrayList<Tuple.T2>();
        for (Map.Entry<IRecipeInput, RecipeOutput> entry : this.recipes.entrySet()) {
            if (entry.getKey().getClass() != RecipeInputOreDict.class) continue;
            RecipeInputOreDict recipe = (RecipeInputOreDict)entry.getKey();
            if (!recipe.input.equals(event.Name)) continue;
            datas.add(new Tuple.T2((Object)entry.getKey(), (Object)entry.getValue()));
        }
        for (Tuple.T2 t2 : datas) {
            this.addToCache(event.Ore, (Tuple.T2<IRecipeInput, RecipeOutput>)t2);
        }
    }

    private Tuple.T2 getRecipe(ItemStack input) {
        Tuple.T2<IRecipeInput, RecipeOutput> data;
        Map<Integer, Tuple.T2<IRecipeInput, RecipeOutput>> metaMap = this.recipeCache.get(input.func_77973_b());
        if (metaMap != null) {
            Tuple.T2<IRecipeInput, RecipeOutput> data2 = metaMap.get(Short.MAX_VALUE);
            if (data2 != null) {
                return data2;
            }
            int meta = input.func_77960_j();
            data2 = metaMap.get(meta);
            if (data2 != null) {
                return data2;
            }
        }
        Iterator<Tuple.T2<IRecipeInput, RecipeOutput>> var5 = this.uncacheableRecipes.iterator();
        do {
            if (!var5.hasNext()) {
                return null;
            }
            data = var5.next();
        } while (!((IRecipeInput)data.a).matches(input));
        return data;
    }

    private boolean addRecipe(IRecipeInput input, RecipeOutput output, boolean overwrite) {
        ItemStack is;
        if (input == null) {
            this.displayError("The recipe input is null");
            return false;
        }
        ListIterator<ItemStack> it = output.items.listIterator();
        while (it.hasNext()) {
            is = (ItemStack)it.next();
            if (is == null) {
                this.displayError("An output ItemStack is null.");
                return false;
            }
            if (!StackUtil.check((ItemStack)is)) {
                this.displayError("The output ItemStack " + StackUtil.toStringSafe((ItemStack)is) + " is invalid.");
                return false;
            }
            it.set(is.func_77946_l());
        }
        Iterator var7 = input.getInputs().iterator();
        while (true) {
            if (!var7.hasNext()) {
                this.recipes.put(input, output);
                this.addToCache(input, output);
                return true;
            }
            is = (ItemStack)var7.next();
            Tuple.T2 data = this.getRecipe(is);
            if (data == null) continue;
            if (!overwrite) {
                return false;
            }
            do {
                this.recipes.remove(data.a);
                this.removeCachedRecipes((IRecipeInput)data.a);
            } while ((data = this.getRecipe(is)) != null);
        }
    }

    private void addToCache(IRecipeInput input, RecipeOutput output) {
        Tuple.T2 data = new Tuple.T2((Object)input, (Object)output);
        List<ItemStack> stacks = this.getStacksFromRecipe(input);
        if (stacks != null) {
            for (ItemStack stack : stacks) {
                this.addToCache(stack, (Tuple.T2<IRecipeInput, RecipeOutput>)data);
            }
            if (input.getClass() == RecipeInputOreDict.class && !this.oreRegisterEventSubscribed) {
                MinecraftForge.EVENT_BUS.register((Object)this);
                this.oreRegisterEventSubscribed = true;
            }
        } else {
            this.uncacheableRecipes.add((Tuple.T2<IRecipeInput, RecipeOutput>)data);
        }
    }

    private void addToCache(ItemStack stack, Tuple.T2<IRecipeInput, RecipeOutput> data) {
        Item item = stack.func_77973_b();
        Map metaMap = this.recipeCache.computeIfAbsent(item, k -> new HashMap());
        int meta = stack.func_77960_j();
        metaMap.put(meta, data);
    }

    private void removeCachedRecipes(IRecipeInput input) {
        List<ItemStack> stacks = this.getStacksFromRecipe(input);
        if (stacks != null) {
            for (ItemStack stack : stacks) {
                Item item = stack.func_77973_b();
                int meta = stack.func_77960_j();
                Map<Integer, Tuple.T2<IRecipeInput, RecipeOutput>> map = this.recipeCache.get(item);
                if (map == null) {
                    IC2.log.warn(LogCategory.Recipe, "Inconsistent recipe cache, the entry for the item " + item + "(" + stack + ") is missing.");
                    continue;
                }
                map.remove(meta);
                if (!map.isEmpty()) continue;
                this.recipeCache.remove(item);
            }
        } else {
            Iterator<Tuple.T2<IRecipeInput, RecipeOutput>> it = this.uncacheableRecipes.iterator();
            while (it.hasNext()) {
                Tuple.T2<IRecipeInput, RecipeOutput> data = it.next();
                if (data.a != input) continue;
                it.remove();
            }
        }
    }

    private List<ItemStack> getStacksFromRecipe(IRecipeInput recipe) {
        if (recipe.getClass() == RecipeInputItemStack.class) {
            return recipe.getInputs();
        }
        if (recipe.getClass() == RecipeInputOreDict.class) {
            Integer meta = ((RecipeInputOreDict)recipe).meta;
            if (meta == null) {
                return recipe.getInputs();
            }
            ArrayList<ItemStack> ret = new ArrayList<ItemStack>(recipe.getInputs());
            ListIterator<ItemStack> it = ret.listIterator();
            while (it.hasNext()) {
                ItemStack stack = (ItemStack)it.next();
                if (stack.func_77960_j() == meta.intValue()) continue;
                stack = stack.func_77946_l();
                stack.func_77964_b(meta.intValue());
                it.set(stack);
            }
            return ret;
        }
        return null;
    }

    private void displayError(String msg) {
        if (!MainConfig.ignoreInvalidRecipes) {
            throw new RuntimeException(msg);
        }
        IC2.log.warn(LogCategory.Recipe, msg);
    }
}

