/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.recipemanager;

import com.denfop.api.IObsidianGenerator;
import ic2.api.recipe.RecipeOutput;
import ic2.core.util.StackUtil;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class ObsidianRecipeManager
implements IObsidianGenerator {
    private final Map<IObsidianGenerator.Input, RecipeOutput> recipes = new HashMap<IObsidianGenerator.Input, RecipeOutput>();

    @Override
    public void addRecipe(FluidStack fluidStack, FluidStack fluidStack1, ItemStack output) {
        if (fluidStack == null) {
            throw new NullPointerException("The container recipe input is null");
        }
        if (fluidStack1 == null) {
            throw new NullPointerException("The fill recipe input is null");
        }
        if (output == null) {
            throw new NullPointerException("The recipe output is null");
        }
        if (!StackUtil.check((ItemStack)output)) {
            throw new IllegalArgumentException("The recipe output " + StackUtil.toStringSafe((ItemStack)output) + " is invalid");
        }
        for (IObsidianGenerator.Input value : this.recipes.keySet()) {
            if (!value.matches(fluidStack, fluidStack1)) continue;
            throw new RuntimeException("ambiguous recipe");
        }
        this.recipes.put(new IObsidianGenerator.Input(fluidStack, fluidStack1), new RecipeOutput(null, new ItemStack[]{output}));
    }

    @Override
    public RecipeOutput getOutputFor(FluidStack fluidStack, FluidStack fluidStack1, boolean adjustInput, boolean acceptTest) {
        if (acceptTest) {
            for (Map.Entry<IObsidianGenerator.Input, RecipeOutput> inputRecipeOutputEntry : this.recipes.entrySet()) {
                IObsidianGenerator.Input input = inputRecipeOutputEntry.getKey();
                if (acceptTest && (fluidStack == null || fluidStack1 == null)) {
                    return null;
                }
                if (!input.matches(fluidStack, fluidStack1)) continue;
                if (fluidStack != null && input.fluidStack != null && fluidStack.amount >= input.fluidStack.amount && fluidStack1 != null && input.fluidStack1 != null && fluidStack1.amount >= input.fluidStack1.amount) {
                    if (!acceptTest && (fluidStack != null && fluidStack.amount <= input.fluidStack.amount || fluidStack1 != null && fluidStack1.amount <= input.fluidStack1.amount)) break;
                    if (adjustInput) {
                        fluidStack1.amount -= input.fluidStack1.amount;
                        fluidStack.amount -= input.fluidStack.amount;
                    }
                    return inputRecipeOutputEntry.getValue();
                }
                return null;
            }
        }
        return null;
    }
}

