/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.render.tank;

import com.denfop.tiles.base.TileEntityLiquidTank;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.AdvancedModelLoader;
import net.minecraftforge.client.model.IModelCustom;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public class TileEntityTankRender
extends TileEntitySpecialRenderer {
    static final IModelCustom model = AdvancedModelLoader.loadModel((ResourceLocation)new ResourceLocation("industrialupgrade", "models/tank.obj"));
    static final IModelCustom model1 = AdvancedModelLoader.loadModel((ResourceLocation)new ResourceLocation("industrialupgrade", "models/oil.obj"));

    public void func_147500_a(TileEntity tile, double x, double y, double z, float f) {
        this.render((TileEntityLiquidTank)tile, x, y, z);
    }

    private void render(TileEntityLiquidTank tile, double x, double y, double z) {
        Fluid fluid;
        GL11.glPushMatrix();
        this.setupTransformation(x, y, z, 0.6f, 0.51f, 0.7f, 1.0f, 0.8f, 1.0f);
        this.func_147499_a(tile.texture);
        model.renderAll();
        GL11.glPopMatrix();
        FluidStack fluidStack = tile.getFluidTank().getFluid();
        if (fluidStack != null && (fluid = fluidStack.getFluid()) != null && fluid.getBlock() != null) {
            GL11.glPushMatrix();
            this.setupTransformation(x, y, z, 0.6f, (float)tile.gaugeLiquidScaled(0.51), 0.7f, 1.0f, (float)Math.min(0.8, tile.gaugeLiquidScaled(0.8)), 1.0f);
            ResourceLocation texture = this.getFluidTexture(fluid);
            if (texture != null) {
                this.func_147499_a(texture);
                model1.renderAll();
            }
            GL11.glPopMatrix();
        }
    }

    private void setupTransformation(double x, double y, double z, float translateX, float translateY, float translateZ, float scaleX, float scaleY, float scaleZ) {
        GL11.glTranslated((double)x, (double)y, (double)z);
        GL11.glTranslatef((float)translateX, (float)translateY, (float)translateZ);
        GL11.glEnable((int)3042);
        GL11.glRotatef((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        GL11.glScalef((float)scaleX, (float)scaleY, (float)scaleZ);
    }

    private ResourceLocation getFluidTexture(Fluid fluid) {
        String[] parts;
        String iconName;
        ItemStack fluidBlockStack = new ItemStack(fluid.getBlock());
        String string = iconName = fluidBlockStack.func_77954_c() != null ? fluidBlockStack.func_77954_c().func_94215_i() : null;
        if (iconName == null) {
            return null;
        }
        if (fluid == FluidRegistry.LAVA || fluid == FluidRegistry.WATER) {
            return new ResourceLocation(null, "textures/blocks/" + iconName + ".png");
        }
        if (iconName.contains(":") && (parts = iconName.split(":")).length == 2) {
            return new ResourceLocation(parts[0], "textures/blocks/" + parts[1] + ".png");
        }
        return null;
    }
}

