/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.base;

import com.denfop.IUCore;
import com.denfop.audio.AudioSource;
import com.denfop.container.ContainerObsidianGenerator;
import com.denfop.invslot.InvSlotObsidianGenerator;
import ic2.api.network.INetworkTileEntityEventListener;
import ic2.api.recipe.RecipeOutput;
import ic2.core.ContainerBase;
import ic2.core.IC2;
import ic2.core.IHasGui;
import ic2.core.block.TileEntityInventory;
import ic2.core.block.invslot.InvSlotConsumableLiquidByList;
import ic2.core.block.invslot.InvSlotOutput;
import ic2.core.block.invslot.InvSlotUpgrade;
import ic2.core.block.machine.tileentity.TileEntityElectricMachine;
import ic2.core.network.NetworkManager;
import ic2.core.upgrade.IUpgradableBlock;
import ic2.core.upgrade.IUpgradeItem;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;
import org.apache.commons.lang3.mutable.MutableObject;

public abstract class TileEntityBaseObsidianGenerator
extends TileEntityElectricMachine
implements IHasGui,
INetworkTileEntityEventListener,
IUpgradableBlock,
IFluidHandler {
    public final InvSlotOutput outputSlot1;
    public final InvSlotConsumableLiquidByList fluidSlot1;
    public final InvSlotConsumableLiquidByList fluidSlot2;
    public final int defaultEnergyConsume;
    public final int defaultOperationLength;
    public final int defaultTier;
    public final int defaultEnergyStorage;
    public final InvSlotOutput outputSlot;
    public final InvSlotUpgrade upgradeSlot;
    public final FluidTank fluidTank1;
    public final FluidTank fluidTank2;
    public int energyConsume;
    public int operationLength;
    public int operationsPerTick;
    public AudioSource audioSource;
    public InvSlotObsidianGenerator inputSlotA;
    protected short progress = 0;
    protected double guiProgress;

    public TileEntityBaseObsidianGenerator(int energyPerTick, int length, int outputSlots) {
        this(energyPerTick, length, outputSlots, 1);
    }

    public TileEntityBaseObsidianGenerator(int energyPerTick, int length, int outputSlots, int aDefaultTier) {
        super(energyPerTick * length, 1, 1);
        this.defaultEnergyConsume = this.energyConsume = energyPerTick;
        this.defaultOperationLength = this.operationLength = length;
        this.defaultTier = aDefaultTier;
        this.defaultEnergyStorage = energyPerTick * length;
        this.outputSlot = new InvSlotOutput((TileEntityInventory)this, "output", 2, outputSlots);
        this.upgradeSlot = new InvSlotUpgrade((TileEntityInventory)this, "upgrade", 3, 4);
        this.outputSlot1 = new InvSlotOutput((TileEntityInventory)this, "output1", 5, 1);
        this.fluidTank1 = new FluidTank(12000);
        this.fluidTank2 = new FluidTank(12000);
        this.fluidSlot1 = new InvSlotConsumableLiquidByList((TileEntityInventory)this, "fluidSlot", 8, 1, new Fluid[]{FluidRegistry.WATER});
        this.fluidSlot2 = new InvSlotConsumableLiquidByList((TileEntityInventory)this, "fluidSlot1", 9, 1, new Fluid[]{FluidRegistry.LAVA});
    }

    public static int applyModifier(int base, int extra, double multiplier) {
        double ret = Math.round((double)(base + extra) * multiplier);
        return ret > 2.147483647E9 ? Integer.MAX_VALUE : (int)ret;
    }

    public double injectEnergy(ForgeDirection directionFrom, double amount, double voltage) {
        if (amount == 0.0) {
            return 0.0;
        }
        if (this.energy >= (double)this.maxEnergy) {
            return amount;
        }
        if (this.energy + amount >= (double)this.maxEnergy) {
            double p = (double)this.maxEnergy - this.energy;
            this.energy += p;
            return amount - p;
        }
        this.energy += amount;
        return 0.0;
    }

    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.progress = nbttagcompound.func_74765_d("progress");
        this.fluidTank1.readFromNBT(nbttagcompound.func_74775_l("fluidTank1"));
        this.fluidTank2.readFromNBT(nbttagcompound.func_74775_l("fluidTank2"));
    }

    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74777_a("progress", this.progress);
        NBTTagCompound fluidTankTag1 = new NBTTagCompound();
        this.fluidTank1.writeToNBT(fluidTankTag1);
        nbttagcompound.func_74782_a("fluidTank1", (NBTBase)fluidTankTag1);
        NBTTagCompound fluidTankTag2 = new NBTTagCompound();
        this.fluidTank2.writeToNBT(fluidTankTag2);
        nbttagcompound.func_74782_a("fluidTank2", (NBTBase)fluidTankTag2);
    }

    public double getProgress() {
        return this.guiProgress;
    }

    public void onLoaded() {
        super.onLoaded();
        if (IC2.platform.isSimulating()) {
            this.setOverclockRates();
        }
    }

    public void onUnloaded() {
        super.onUnloaded();
        if (IC2.platform.isRendering() && this.audioSource != null) {
            IC2.audioManager.removeSources((Object)this);
            this.audioSource = null;
        }
    }

    public void func_70296_d() {
        super.func_70296_d();
        if (IC2.platform.isSimulating()) {
            this.setOverclockRates();
        }
    }

    public void updateEntityServer() {
        RecipeOutput output;
        super.updateEntityServer();
        boolean needsInvUpdate = false;
        MutableObject output1 = new MutableObject();
        if (this.fluidSlot1.transferToTank((IFluidTank)this.fluidTank1, output1, true) && (output1.getValue() == null || this.outputSlot1.canAdd((ItemStack)output1.getValue()))) {
            needsInvUpdate = this.fluidSlot1.transferToTank((IFluidTank)this.fluidTank1, output1, false);
            if (output1.getValue() != null) {
                this.outputSlot1.add((ItemStack)output1.getValue());
            }
        }
        if (this.fluidSlot2.transferToTank((IFluidTank)this.fluidTank2, output1, true) && (output1.getValue() == null || this.outputSlot1.canAdd((ItemStack)output1.getValue()))) {
            needsInvUpdate = this.fluidSlot2.transferToTank((IFluidTank)this.fluidTank2, output1, false);
            if (output1.getValue() != null) {
                this.outputSlot1.add((ItemStack)output1.getValue());
            }
        }
        if ((output = this.getOutput()) != null && this.energy >= (double)this.energyConsume) {
            this.setActive(true);
            if (this.progress == 0) {
                ((NetworkManager)IC2.network.get()).initiateTileEntityEvent((TileEntity)this, 0, true);
            }
            this.progress = (short)(this.progress + 1);
            this.energy -= (double)this.energyConsume;
            double k = this.progress;
            this.guiProgress = k / (double)this.operationLength;
            if (this.progress >= this.operationLength) {
                this.guiProgress = 0.0;
                this.operate(output);
                needsInvUpdate = true;
                this.progress = 0;
                ((NetworkManager)IC2.network.get()).initiateTileEntityEvent((TileEntity)this, 2, true);
            }
        } else {
            if (this.progress != 0 && this.getActive()) {
                ((NetworkManager)IC2.network.get()).initiateTileEntityEvent((TileEntity)this, 1, true);
            }
            if (output == null) {
                this.progress = 0;
            }
            this.setActive(false);
        }
        for (int i = 0; i < this.upgradeSlot.size(); ++i) {
            ItemStack stack = this.upgradeSlot.get(i);
            if (stack == null || !(stack.func_77973_b() instanceof IUpgradeItem) || !((IUpgradeItem)stack.func_77973_b()).onTick(stack, (IUpgradableBlock)this)) continue;
            needsInvUpdate = true;
        }
        if (needsInvUpdate) {
            super.func_70296_d();
        }
    }

    public void setOverclockRates() {
        this.upgradeSlot.onChanged();
        double previousProgress = (double)this.progress / (double)this.operationLength;
        double stackOpLen = (double)(this.defaultOperationLength + this.upgradeSlot.extraProcessTime) * 64.0 * this.upgradeSlot.processTimeMultiplier;
        this.operationsPerTick = (int)Math.min(Math.ceil(64.0 / stackOpLen), 2.147483647E9);
        this.operationLength = (int)Math.round(stackOpLen * (double)this.operationsPerTick / 64.0);
        this.energyConsume = TileEntityBaseObsidianGenerator.applyModifier(this.defaultEnergyConsume, this.upgradeSlot.extraEnergyDemand, this.upgradeSlot.energyDemandMultiplier);
        this.setTier(TileEntityBaseObsidianGenerator.applyModifier(this.defaultTier, this.upgradeSlot.extraTier, 1.0));
        this.maxEnergy = TileEntityBaseObsidianGenerator.applyModifier(this.defaultEnergyStorage, this.upgradeSlot.extraEnergyStorage + this.operationLength * this.energyConsume, this.upgradeSlot.energyStorageMultiplier);
        if (this.operationLength < 1) {
            this.operationLength = 1;
        }
        this.progress = (short)Math.floor(previousProgress * (double)this.operationLength + 0.1);
    }

    public void operate(RecipeOutput output) {
        for (int i = 0; i < this.operationsPerTick; ++i) {
            List processResult = output.items;
            for (int j = 0; j < this.upgradeSlot.size(); ++j) {
                ItemStack stack = this.upgradeSlot.get(j);
                if (stack == null || !(stack.func_77973_b() instanceof IUpgradeItem)) continue;
                ((IUpgradeItem)stack.func_77973_b()).onProcessEnd(stack, (IUpgradableBlock)this, processResult);
            }
            this.operateOnce(processResult);
            output = this.getOutput();
            if (output == null) break;
        }
    }

    public void operateOnce(List<ItemStack> processResult) {
        this.inputSlotA.consume();
        this.outputSlot.add(processResult);
    }

    public RecipeOutput getOutput() {
        if (this.fluidTank2.getFluid() == null) {
            return null;
        }
        if (this.fluidTank1.getFluid() == null) {
            return null;
        }
        if (this.fluidTank2.getFluid().amount < 1000) {
            return null;
        }
        RecipeOutput output = this.inputSlotA.process();
        if (output == null) {
            return null;
        }
        if (this.outputSlot.canAdd(output.items)) {
            return output;
        }
        return null;
    }

    public abstract String func_145825_b();

    public ContainerBase<? extends TileEntityBaseObsidianGenerator> getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerObsidianGenerator(entityPlayer, this);
    }

    public String getStartSoundFile() {
        return null;
    }

    public String getInterruptSoundFile() {
        return null;
    }

    public void onNetworkEvent(int event) {
        if (this.audioSource == null && this.getStartSoundFile() != null) {
            this.audioSource = IUCore.audioManager.createSource((Object)this, this.getStartSoundFile());
        }
        switch (event) {
            case 0: {
                if (this.audioSource == null) break;
                this.audioSource.play();
                break;
            }
            case 1: {
                if (this.audioSource == null) break;
                this.audioSource.stop();
                if (this.getInterruptSoundFile() == null) break;
                IUCore.audioManager.playOnce((Object)this, this.getInterruptSoundFile());
                break;
            }
            case 2: {
                if (this.audioSource == null) break;
                this.audioSource.stop();
            }
        }
    }

    public double getEnergy() {
        return this.energy;
    }

    public boolean useEnergy(double amount) {
        if (this.energy >= amount) {
            this.energy -= amount;
            return true;
        }
        return false;
    }

    public void onGuiClosed(EntityPlayer entityPlayer) {
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return fluid == FluidRegistry.LAVA || fluid == FluidRegistry.WATER;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (this.getFluidTank1().getFluidAmount() < this.getFluidTank1().getCapacity() && resource.getFluid().equals(FluidRegistry.WATER)) {
            return this.canFill(from, resource.getFluid()) ? this.getFluidTank1().fill(resource, doFill) : 0;
        }
        if (this.getFluidTank2().getFluidAmount() < this.getFluidTank2().getCapacity() && resource.getFluid().equals(FluidRegistry.LAVA)) {
            return this.canFill(from, resource.getFluid()) ? this.getFluidTank2().fill(resource, doFill) : 0;
        }
        return 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (resource != null && resource.isFluidEqual(this.getFluidTank1().getFluid())) {
            return !this.canDrain(from, resource.getFluid()) ? null : this.getFluidTank1().drain(resource.amount, doDrain);
        }
        if (resource != null && resource.isFluidEqual(this.getFluidTank2().getFluid())) {
            return !this.canDrain(from, resource.getFluid()) ? null : this.getFluidTank2().drain(resource.amount, doDrain);
        }
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return !this.canDrain(from, null) ? null : this.getFluidTank2().drain(maxDrain, doDrain);
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.getFluidTank1().getInfo(), this.getFluidTank2().getInfo()};
    }

    public int getTankAmount1() {
        return this.getFluidTank1().getFluidAmount();
    }

    public int getTankAmount2() {
        return this.getFluidTank2().getFluidAmount();
    }

    public int gaugeLiquidScaled1(int i) {
        return this.getFluidTank1().getFluidAmount() <= 0 ? 0 : this.getFluidTank1().getFluidAmount() * i / this.getFluidTank1().getCapacity();
    }

    public int gaugeLiquidScaled2(int i) {
        return this.getFluidTank2().getFluidAmount() <= 0 ? 0 : this.getFluidTank2().getFluidAmount() * i / this.getFluidTank2().getCapacity();
    }

    public FluidTank getFluidTank1() {
        return this.fluidTank1;
    }

    public FluidTank getFluidTank2() {
        return this.fluidTank2;
    }
}

