/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.base;

import com.denfop.block.cable.BlockCable;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.registry.GameData;
import ic2.api.Direction;
import ic2.api.energy.EnergyNet;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergyAcceptor;
import ic2.api.energy.tile.IEnergyConductor;
import ic2.api.energy.tile.IEnergyEmitter;
import ic2.api.energy.tile.IEnergyTile;
import ic2.api.network.INetworkTileEntityEventListener;
import ic2.core.IC2;
import ic2.core.ITickCallback;
import ic2.core.block.IObscurable;
import ic2.core.block.TileEntityBlock;
import ic2.core.block.wiring.TileEntityLuminator;
import ic2.core.network.ClientModifiable;
import ic2.core.network.NetworkManager;
import ic2.core.util.ReflectionUtil;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Vector;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityCable
extends TileEntityBlock
implements IEnergyConductor,
INetworkTileEntityEventListener,
IObscurable {
    public final short color;
    public short cableType;
    public byte foamed = 0;
    public byte foamColor = 0;
    @ClientModifiable
    public Block[] retextureRef;
    @ClientModifiable
    public int[] retextureRefMeta;
    @ClientModifiable
    public int[] retextureRefSide;
    public byte connectivity = 0;
    public byte renderSide = 0;
    public boolean addedToEnergyNet = false;
    private byte prevFoamed = 0;
    private ITickCallback continuousTickCallback = null;

    public TileEntityCable(short type) {
        this.color = 0;
        this.cableType = type;
    }

    public TileEntityCable() {
        this.color = 0;
        this.cableType = 0;
    }

    public static double getMaxCapacity(int type) {
        double d;
        switch (type) {
            case 0: {
                d = 32768.0;
                break;
            }
            case 1: {
                d = 131072.0;
                break;
            }
            case 2: {
                d = 524288.0;
                break;
            }
            case 3: {
                d = 2097152.0;
                break;
            }
            case 4: {
                d = 8388608.0;
                break;
            }
            case 5: {
                d = 3.3554432E7;
                break;
            }
            case 6: {
                d = 1.34217728E8;
                break;
            }
            case 7: {
                d = 5.36870912E8;
                break;
            }
            case 8: {
                d = 8.58993459E9;
                break;
            }
            case 9: {
                d = 4.39804653E11;
                break;
            }
            case 10: {
                d = 1.75921861E12;
                break;
            }
            default: {
                d = 0.0;
            }
        }
        return d;
    }

    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.cableType = nbttagcompound.func_74765_d("cableType");
        this.foamed = nbttagcompound.func_74771_c("foamed");
        if (nbttagcompound.func_74764_b("retextureRefMeta")) {
            this.retextureRef = new Block[6];
            boolean found = false;
            for (int i = 0; i < 6; ++i) {
                if (!nbttagcompound.func_74764_b("retextureRef" + i)) continue;
                this.retextureRef[i] = (Block)GameData.getBlockRegistry().getRaw(nbttagcompound.func_74779_i("retextureRef" + i));
                found = found || this.retextureRef[i] != null;
            }
            if (found) {
                this.retextureRefMeta = nbttagcompound.func_74759_k("retextureRefMeta");
                this.retextureRefSide = nbttagcompound.func_74759_k("retextureRefSide");
                if (this.retextureRefMeta.length != 6 || this.retextureRefSide.length != 6) {
                    this.clearRetexture();
                }
            } else {
                this.clearRetexture();
            }
        }
    }

    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74777_a("cableType", this.cableType);
        nbttagcompound.func_74774_a("foamed", this.foamed);
        if (this.retextureRef != null) {
            for (int i = 0; i < this.retextureRef.length; ++i) {
                if (this.retextureRef[i] == null) continue;
                nbttagcompound.func_74778_a("retextureRef" + i, GameData.getBlockRegistry().func_148750_c((Object)this.retextureRef[i]));
            }
            nbttagcompound.func_74783_a("retextureRefMeta", this.retextureRefMeta);
            nbttagcompound.func_74783_a("retextureRefSide", this.retextureRefSide);
        }
    }

    public void onLoaded() {
        super.onLoaded();
        if (IC2.platform.isSimulating()) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)this));
            this.addedToEnergyNet = true;
            this.onNeighborBlockChange();
            if (this.foamed == 1) {
                this.changeFoam(this.foamed, true);
            }
        }
    }

    public void onUnloaded() {
        if (IC2.platform.isSimulating() && this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)this));
            this.addedToEnergyNet = false;
        }
        if (this.continuousTickCallback != null) {
            IC2.tickHandler.removeContinuousTickCallback(this.field_145850_b, this.continuousTickCallback);
            this.continuousTickCallback = null;
        }
        super.onUnloaded();
    }

    public void onNeighborBlockChange() {
        byte newConnectivity = 0;
        byte newRenderSide = 0;
        int mask = 1;
        for (Direction direction : Direction.directions) {
            TileEntity neighbor = EnergyNet.instance.getNeighbor((TileEntity)this, direction.toForgeDirection());
            if ((neighbor instanceof IEnergyAcceptor && ((IEnergyAcceptor)neighbor).acceptsEnergyFrom((TileEntity)this, direction.getInverse().toForgeDirection()) || neighbor instanceof IEnergyEmitter && ((IEnergyEmitter)neighbor).emitsEnergyTo((TileEntity)this, direction.getInverse().toForgeDirection())) && this.canInteractWith(neighbor)) {
                newConnectivity = (byte)(newConnectivity | mask);
                ForgeDirection dir = direction.toForgeDirection();
                int x = this.field_145851_c + dir.offsetX;
                int y = this.field_145848_d + dir.offsetY;
                int z = this.field_145849_e + dir.offsetZ;
                if (neighbor instanceof TileEntityCable) {
                    if (((TileEntityCable)neighbor).getCableThickness() < this.getCableThickness()) {
                        newRenderSide = (byte)(newRenderSide | mask);
                    }
                } else if (neighbor instanceof IEnergyConductor || !this.field_145850_b.func_147439_a(x, y, z).func_149747_d((IBlockAccess)this.field_145850_b, x, y, z, direction.getInverse().toSideValue())) {
                    newRenderSide = (byte)(newRenderSide | mask);
                }
            }
            mask *= 2;
        }
        if (this.connectivity != newConnectivity) {
            this.connectivity = newConnectivity;
            ((NetworkManager)IC2.network.get()).updateTileEntityField((TileEntity)this, "connectivity");
        }
        if (this.renderSide != newRenderSide) {
            this.renderSide = newRenderSide;
            ((NetworkManager)IC2.network.get()).updateTileEntityField((TileEntity)this, "renderSide");
        }
    }

    public boolean shouldRefresh(Block oldBlock, Block newBlock, int oldMeta, int newMeta, World world, int x, int y, int z) {
        if (oldBlock != newBlock) {
            return super.shouldRefresh(oldBlock, newBlock, oldMeta, newMeta, world, x, y, z);
        }
        return false;
    }

    public void changeFoam(byte foamed1) {
        this.changeFoam(foamed1, false);
    }

    public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, int side) {
        return false;
    }

    public boolean wrenchCanRemove(EntityPlayer entityPlayer) {
        return false;
    }

    public boolean acceptsEnergyFrom(TileEntity emitter, ForgeDirection direction) {
        return this.canInteractWith(emitter);
    }

    public boolean emitsEnergyTo(TileEntity receiver, ForgeDirection direction) {
        return this.canInteractWith(receiver);
    }

    public boolean canInteractWith(TileEntity te) {
        if (!(te instanceof IEnergyTile)) {
            return false;
        }
        if (te instanceof TileEntityCable) {
            return this.canInteractWithCable((TileEntityCable)te);
        }
        if (te instanceof TileEntityLuminator) {
            return ((TileEntityLuminator)te).canCableConnectFrom(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        return true;
    }

    public boolean canInteractWithCable(TileEntityCable cable) {
        return this.color == 0 || cable.color == 0 || this.color == cable.color;
    }

    public float getCableThickness() {
        if (this.foamed == 2) {
            return 1.0f;
        }
        return 0.25f;
    }

    public double getConductionLoss() {
        return 0.025;
    }

    public double getInsulationEnergyAbsorption() {
        return 9001.0;
    }

    public double getInsulationBreakdownEnergy() {
        return 9001.0;
    }

    public double getConductorBreakdownEnergy() {
        return TileEntityCable.getMaxCapacity(this.cableType);
    }

    public void removeInsulation() {
    }

    public void removeConductor() {
        this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        ((NetworkManager)IC2.network.get()).initiateTileEntityEvent((TileEntity)this, 0, true);
    }

    public List<String> getNetworkedFields() {
        Vector<String> ret = new Vector<String>();
        ret.add("cableType");
        ret.add("color");
        ret.add("foamed");
        ret.add("foamColor");
        ret.add("retextureRef");
        ret.add("retextureRefMeta");
        ret.add("retextureRefSide");
        ret.add("connectivity");
        ret.add("renderSide");
        ret.addAll(super.getNetworkedFields());
        return ret;
    }

    public void onNetworkUpdate(String field) {
        if (field.equals("foamed")) {
            if (this.prevFoamed != this.foamed) {
                if (this.foamed == 0 && this.prevFoamed != 1 || this.foamed == 2) {
                    this.relight();
                }
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                this.prevFoamed = this.foamed;
            }
        } else {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        super.onNetworkUpdate(field);
    }

    private void relight() {
        Method relightMethod = ReflectionUtil.getMethod(Chunk.class, (String[])new String[]{"relightBlock", "func_76615_h"}, (Class[])new Class[]{Integer.TYPE, Integer.TYPE, Integer.TYPE});
        Method propagateSkylightOcclusionMethod = ReflectionUtil.getMethod(Chunk.class, (String[])new String[]{"propagateSkylightOcclusion", "func_76595_e"}, (Class[])new Class[]{Integer.TYPE, Integer.TYPE});
        Chunk chunk = this.field_145850_b.func_72938_d(this.field_145851_c, this.field_145849_e);
        int height = chunk.func_76611_b(this.field_145851_c & 0xF, this.field_145849_e & 0xF);
        try {
            if (this.foamed == 2 && this.field_145848_d >= height) {
                relightMethod.invoke((Object)chunk, this.field_145851_c & 0xF, this.field_145848_d + 1, this.field_145849_e & 0xF);
            } else if (this.field_145848_d == height - 1) {
                relightMethod.invoke((Object)chunk, this.field_145851_c & 0xF, this.field_145848_d, this.field_145849_e & 0xF);
            }
            propagateSkylightOcclusionMethod.invoke((Object)chunk, this.field_145851_c & 0xF, this.field_145849_e & 0xF);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.field_145850_b.func_147451_t(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public void onNetworkEvent(int event) {
        if (event == 0) {
            this.field_145850_b.func_72908_a((double)((float)this.field_145851_c + 0.5f), (double)((float)this.field_145848_d + 0.5f), (double)((float)this.field_145849_e + 0.5f), "random.fizz", 0.5f, 2.6f + (this.field_145850_b.field_73012_v.nextFloat() - this.field_145850_b.field_73012_v.nextFloat()) * 0.8f);
            for (int l = 0; l < 8; ++l) {
                this.field_145850_b.func_72869_a("largesmoke", (double)this.field_145851_c + Math.random(), (double)this.field_145848_d + 1.2, (double)this.field_145849_e + Math.random(), 0.0, 0.0, 0.0);
            }
            return;
        }
        IC2.platform.displayError("An unknown event type was received over multiplayer.\nThis could happen due to corrupted data or a bug.\n\n(Technical information: event ID " + event + ", tile entity below)\nT: " + (Object)((Object)this) + " (" + this.field_145851_c + ", " + this.field_145848_d + ", " + this.field_145849_e + ")", new Object[0]);
    }

    public float getWrenchDropRate() {
        return 0.0f;
    }

    private boolean changeFoam(byte foamed1, boolean duringLoad) {
        if (this.foamed == foamed1 && !duringLoad) {
            return false;
        }
        if (!IC2.platform.isSimulating()) {
            return true;
        }
        byte prevFoamed1 = this.foamed;
        this.foamed = foamed1;
        if (this.continuousTickCallback != null) {
            IC2.tickHandler.removeContinuousTickCallback(this.field_145850_b, this.continuousTickCallback);
            this.continuousTickCallback = null;
        }
        if (foamed1 == 0 || foamed1 == 1) {
            if (this.retextureRef != null) {
                this.clearRetexture();
                if (!duringLoad) {
                    ((NetworkManager)IC2.network.get()).updateTileEntityField((TileEntity)this, "retextureRef");
                    ((NetworkManager)IC2.network.get()).updateTileEntityField((TileEntity)this, "retextureRefMeta");
                    ((NetworkManager)IC2.network.get()).updateTileEntityField((TileEntity)this, "retextureRefSide");
                }
            }
            if (this.foamColor != 7) {
                this.foamColor = (byte)7;
                if (!duringLoad) {
                    ((NetworkManager)IC2.network.get()).updateTileEntityField((TileEntity)this, "foamColor");
                }
            }
        }
        if (foamed1 == 0 && prevFoamed1 != 1 || foamed1 == 2) {
            this.relight();
        } else if (foamed1 == 1) {
            this.continuousTickCallback = world -> {
                if (world.field_73012_v.nextInt(500) == 0 && world.func_72957_l(this.field_145851_c, this.field_145848_d, this.field_145849_e) * 6 >= this.func_145831_w().field_73012_v.nextInt(1000)) {
                    this.changeFoam((byte)2);
                }
            };
            IC2.tickHandler.addContinuousTickCallback(this.field_145850_b, this.continuousTickCallback);
        }
        if (!duringLoad) {
            ((NetworkManager)IC2.network.get()).updateTileEntityField((TileEntity)this, "foamed");
        }
        return true;
    }

    public boolean retexture(int side, Block referencedBlock, int referencedMeta, int referencedSide) {
        if (this.foamed != 2) {
            return false;
        }
        boolean ret = false;
        boolean updateAll = false;
        if (this.retextureRef == null) {
            this.retextureRef = new Block[6];
            this.retextureRefMeta = new int[6];
            this.retextureRefSide = new int[6];
            updateAll = true;
        }
        if (this.retextureRef[side] != referencedBlock || updateAll) {
            this.retextureRef[side] = referencedBlock;
            ((NetworkManager)IC2.network.get()).updateTileEntityField((TileEntity)this, "retextureRef");
            ret = true;
        }
        if (this.retextureRefMeta[side] != referencedMeta || updateAll) {
            this.retextureRefMeta[side] = referencedMeta;
            ((NetworkManager)IC2.network.get()).updateTileEntityField((TileEntity)this, "retextureRefMeta");
            ret = true;
        }
        if (this.retextureRefSide[side] != referencedSide || updateAll) {
            this.retextureRefSide[side] = referencedSide;
            ((NetworkManager)IC2.network.get()).updateTileEntityField((TileEntity)this, "retextureRefSide");
            ret = true;
        }
        return ret;
    }

    public Block getReferencedBlock(int side) {
        if (this.retextureRef != null) {
            return this.retextureRef[side];
        }
        return null;
    }

    public int getReferencedMeta(int side) {
        if (this.retextureRefMeta != null) {
            return this.retextureRefMeta[side];
        }
        return 0;
    }

    public void setColorMultiplier(int colorMultiplier) {
        ((BlockCable)this.func_145838_q()).colorMultiplier = colorMultiplier;
    }

    public void setRenderMask(int mask) {
        ((BlockCable)this.func_145838_q()).renderMask = mask;
    }

    private void clearRetexture() {
        this.retextureRef = null;
        this.retextureRefMeta = null;
        this.retextureRefSide = null;
    }
}

