/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.base;

import com.denfop.container.ContainerCombinerMatter;
import com.denfop.gui.GUICombinerMatter;
import com.denfop.invslot.InvSlotMatter;
import com.denfop.tiles.neutroniumgenerator.TileEntityLiquidTankElectricMachine;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.recipe.RecipeOutput;
import ic2.api.recipe.Recipes;
import ic2.core.ContainerBase;
import ic2.core.IC2;
import ic2.core.IHasGui;
import ic2.core.audio.AudioSource;
import ic2.core.audio.PositionSpec;
import ic2.core.block.TileEntityBlock;
import ic2.core.block.TileEntityInventory;
import ic2.core.block.comp.Redstone;
import ic2.core.block.comp.TileEntityComponent;
import ic2.core.block.invslot.InvSlot;
import ic2.core.block.invslot.InvSlotConsumableLiquid;
import ic2.core.block.invslot.InvSlotConsumableLiquidByList;
import ic2.core.block.invslot.InvSlotOutput;
import ic2.core.block.invslot.InvSlotProcessableGeneric;
import ic2.core.block.invslot.InvSlotUpgrade;
import ic2.core.init.BlocksItems;
import ic2.core.init.InternalName;
import ic2.core.network.NetworkManager;
import ic2.core.upgrade.IUpgradableBlock;
import ic2.core.upgrade.IUpgradeItem;
import ic2.core.upgrade.UpgradableProperty;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import org.apache.commons.lang3.mutable.MutableObject;

public class TileEntityCombinerMatter
extends TileEntityLiquidTankElectricMachine
implements IHasGui,
IUpgradableBlock {
    public final InvSlotMatter inputSlot;
    public final InvSlotUpgrade upgradeSlot;
    public final InvSlotProcessableGeneric amplifierSlot = new InvSlotProcessableGeneric((TileEntityInventory)this, "scrap", 0, 1, Recipes.matterAmplifier);
    public final InvSlotOutput outputSlot = new InvSlotOutput((TileEntityInventory)this, "output", 1, 1);
    public final InvSlotConsumableLiquid containerslot = new InvSlotConsumableLiquidByList((TileEntityInventory)this, "containerslot", 2, InvSlot.Access.I, 1, InvSlot.InvSide.TOP, InvSlotConsumableLiquid.OpType.Fill, new Fluid[]{BlocksItems.getFluid((InternalName)InternalName.fluidUuMatter)});
    protected final Redstone redstone;
    public int scrap;
    private double energycost = 0.0;
    private int state;
    private int prevState;
    private AudioSource audioSource;
    private AudioSource audioSourceScrap;

    public TileEntityCombinerMatter() {
        super(0.0, 14, -1, 0);
        this.upgradeSlot = new InvSlotUpgrade((TileEntityInventory)this, "upgrade", 3, 4);
        this.inputSlot = new InvSlotMatter(this, 8);
        this.redstone = (Redstone)this.addComponent((TileEntityComponent)new Redstone((TileEntityBlock)this));
    }

    private static int applyModifier(int base, int extra) {
        double ret = Math.round((double)(base + extra) * 1.0);
        return ret > 2.147483647E9 ? Integer.MAX_VALUE : (int)ret;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        try {
            this.scrap = nbttagcompound.func_74762_e("scrap");
        }
        catch (Throwable e) {
            this.scrap = nbttagcompound.func_74765_d("scrap");
        }
        this.fluidTank.readFromNBT(nbttagcompound.func_74775_l("fluidTank"));
        this.maxEnergy = nbttagcompound.func_74769_h("maxEnergy");
        this.energy = nbttagcompound.func_74769_h("energy");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74768_a("scrap", this.scrap);
        NBTTagCompound fluidTankTag = new NBTTagCompound();
        this.fluidTank.writeToNBT(fluidTankTag);
        if (fluidTankTag != null) {
            nbttagcompound.func_74782_a("fluidTank", (NBTBase)fluidTankTag);
        }
        nbttagcompound.func_74768_a("amount", this.fluidTank.getFluidAmount());
        nbttagcompound.func_74768_a("maxamount", this.fluidTank.getCapacity());
        nbttagcompound.func_74780_a("maxEnergy", this.inputSlot.getMaxEnergy());
        nbttagcompound.func_74780_a("energy", this.energy);
    }

    public void updateEntityServer() {
        super.updateEntityServer();
        boolean needsInvUpdate = this.onUpdateUpgrade();
        this.maxEnergy = this.inputSlot.getMaxEnergy();
        this.fluidTank.setCapacity(this.inputSlot.getFluidTank(this.inputSlot));
        this.energycost = this.inputSlot.getCostEnergy(this.inputSlot);
        if (this.redstone.hasRedstoneInput() || this.energy <= 0.0) {
            this.setState(0);
            this.setActive(false);
        } else {
            MutableObject output;
            RecipeOutput amplifier;
            this.setState(this.scrap > 0 ? 2 : 1);
            this.setActive(true);
            if (this.scrap < 10000 && (amplifier = this.amplifierSlot.process()) != null) {
                this.amplifierSlot.consume();
                this.scrap += amplifier.metadata.func_74762_e("amplification");
            }
            if (this.energy >= this.energycost) {
                needsInvUpdate = this.attemptGeneration();
            }
            if (this.fluidTank.getFluidAmount() > this.fluidTank.getCapacity()) {
                this.fluidTank.getFluid().amount = this.fluidTank.getCapacity();
            }
            if (this.containerslot.transferFromTank((IFluidTank)this.fluidTank, output = new MutableObject(), true) && (output.getValue() == null || this.outputSlot.canAdd((ItemStack)output.getValue()))) {
                this.containerslot.transferFromTank((IFluidTank)this.fluidTank, output, false);
                if (output.getValue() != null) {
                    this.outputSlot.add((ItemStack)output.getValue());
                }
            }
            if (needsInvUpdate && this.field_145850_b.field_73011_w.getWorldTime() % 5L == 0L) {
                this.func_70296_d();
            }
            if (this.energy > this.maxEnergy) {
                this.energy = this.maxEnergy;
            }
        }
    }

    public boolean onUpdateUpgrade() {
        for (int i = 0; i < this.upgradeSlot.size(); ++i) {
            ItemStack stack = this.upgradeSlot.get(i);
            if (stack == null) continue;
            return ((IUpgradeItem)stack.func_77973_b()).onTick(stack, (IUpgradableBlock)this);
        }
        return false;
    }

    @Override
    public void onUnloaded() {
        if (IC2.platform.isRendering() && this.audioSource != null) {
            IC2.audioManager.removeSources((Object)this);
            this.audioSource = null;
            this.audioSourceScrap = null;
        }
        super.onUnloaded();
    }

    public boolean attemptGeneration() {
        int k = (int)(this.energy / this.energycost);
        this.fluidTank.setCapacity(this.inputSlot.getFluidTank(this.inputSlot));
        if (this.fluidTank.getFluidAmount() + 1 > this.fluidTank.getCapacity()) {
            return false;
        }
        int m = this.fluidTank.getCapacity() - this.fluidTank.getFluidAmount();
        if (k > m) {
            this.fill(null, new FluidStack(BlocksItems.getFluid((InternalName)InternalName.fluidUuMatter), m), true);
            this.energy -= this.energycost * (double)m;
            return true;
        }
        if (m > k) {
            this.fill(null, new FluidStack(BlocksItems.getFluid((InternalName)InternalName.fluidUuMatter), k), true);
            this.energy -= this.energycost * (double)k;
            return true;
        }
        this.fill(null, new FluidStack(BlocksItems.getFluid((InternalName)InternalName.fluidUuMatter), k), true);
        this.energy -= this.energycost * (double)k;
        return true;
    }

    @Override
    public double getDemandedEnergy() {
        if (this.redstone.hasRedstoneInput()) {
            return 0.0;
        }
        return this.maxEnergy - this.energy;
    }

    @Override
    public double injectEnergy(ForgeDirection directionFrom, double amount, double voltage) {
        this.maxEnergy = this.inputSlot.getMaxEnergy();
        if (this.energy >= this.maxEnergy || this.redstone.hasRedstoneInput()) {
            return amount;
        }
        int bonus = Math.min((int)amount, this.scrap);
        this.scrap -= bonus;
        if (this.energy + amount >= this.maxEnergy) {
            double temp = this.maxEnergy - this.energy;
            this.energy += temp;
            return amount - temp;
        }
        this.energy += amount + (double)(5 * bonus);
        return 0.0;
    }

    public ContainerBase<TileEntityCombinerMatter> getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerCombinerMatter(entityPlayer, this);
    }

    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer entityPlayer, boolean isAdmin) {
        return new GUICombinerMatter(new ContainerCombinerMatter(entityPlayer, this));
    }

    public String func_145825_b() {
        return StatCollector.func_74838_a((String)"iu.blockCombMatter.name");
    }

    public void onGuiClosed(EntityPlayer entityPlayer) {
    }

    private void setState(int aState) {
        this.state = aState;
        if (this.prevState != this.state) {
            ((NetworkManager)IC2.network.get()).updateTileEntityField((TileEntity)this, "state");
        }
        this.prevState = this.state;
    }

    public List<String> getNetworkedFields() {
        Vector<String> ret = new Vector<String>(1);
        ret.add("state");
        ret.addAll(super.getNetworkedFields());
        return ret;
    }

    @Override
    public void onNetworkUpdate(String field) {
        if (field.equals("state") && this.prevState != this.state) {
            switch (this.state) {
                case 0: {
                    if (this.audioSource != null) {
                        this.audioSource.stop();
                    }
                    if (this.audioSourceScrap == null) break;
                    this.audioSourceScrap.stop();
                    break;
                }
                case 1: {
                    if (this.audioSource == null) {
                        this.audioSource = IC2.audioManager.createSource((Object)this, PositionSpec.Center, "Generators/MassFabricator/MassFabLoop.ogg", true, false, IC2.audioManager.getDefaultVolume());
                    }
                    if (this.audioSource != null) {
                        this.audioSource.play();
                    }
                    if (this.audioSourceScrap == null) break;
                    this.audioSourceScrap.stop();
                    break;
                }
                case 2: {
                    if (this.audioSource == null) {
                        this.audioSource = IC2.audioManager.createSource((Object)this, PositionSpec.Center, "Generators/MassFabricator/MassFabLoop.ogg", true, false, IC2.audioManager.getDefaultVolume());
                    }
                    if (this.audioSourceScrap == null) {
                        this.audioSourceScrap = IC2.audioManager.createSource((Object)this, PositionSpec.Center, "Generators/MassFabricator/MassFabScrapSolo.ogg", true, false, IC2.audioManager.getDefaultVolume());
                    }
                    if (this.audioSource != null) {
                        this.audioSource.play();
                    }
                    if (this.audioSourceScrap == null) break;
                    this.audioSourceScrap.play();
                }
            }
            this.prevState = this.state;
        }
        super.onNetworkUpdate(field);
    }

    public float getWrenchDropRate() {
        return 0.7f;
    }

    @Override
    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return fluid == BlocksItems.getFluid((InternalName)InternalName.fluidUuMatter);
    }

    @Override
    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return true;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (IC2.platform.isSimulating()) {
            this.setUpgradestat();
        }
    }

    public void func_70296_d() {
        super.func_70296_d();
        if (IC2.platform.isSimulating()) {
            this.setUpgradestat();
        }
    }

    public void setUpgradestat() {
        this.upgradeSlot.onChanged();
        this.setTier(TileEntityCombinerMatter.applyModifier(this.getSinkTier(), this.upgradeSlot.extraTier));
    }

    public double getEnergy() {
        return this.energy;
    }

    public boolean useEnergy(double amount) {
        if (this.energy >= amount) {
            this.energy -= amount;
            return true;
        }
        return false;
    }

    public Set<UpgradableProperty> getUpgradableProperties() {
        return EnumSet.of(UpgradableProperty.RedstoneSensitive, UpgradableProperty.Transformer, UpgradableProperty.ItemConsuming, UpgradableProperty.ItemProducing, UpgradableProperty.FluidProducing);
    }
}

