/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.base;

import com.denfop.container.ContainerCombinerSolidMatter;
import com.denfop.gui.GUICombinerSolidMatter;
import com.denfop.invslot.InvSlotSolidMatter;
import com.denfop.item.mechanism.ItemSolidMatter;
import com.denfop.tiles.base.TileEntityElectricMachine;
import com.denfop.tiles.solidmatter.EnumSolidMatter;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.network.INetworkTileEntityEventListener;
import ic2.core.ContainerBase;
import ic2.core.IC2;
import ic2.core.IHasGui;
import ic2.core.block.TileEntityInventory;
import ic2.core.block.invslot.InvSlotOutput;
import ic2.core.block.invslot.InvSlotUpgrade;
import ic2.core.upgrade.IUpgradableBlock;
import ic2.core.upgrade.UpgradableProperty;
import java.util.EnumSet;
import java.util.Set;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityCombinerSolidMatter
extends TileEntityElectricMachine
implements IHasGui,
INetworkTileEntityEventListener,
IUpgradableBlock {
    public final InvSlotSolidMatter inputSlot = new InvSlotSolidMatter(this, 8);
    public final InvSlotUpgrade upgradeSlot = new InvSlotUpgrade((TileEntityInventory)this, "upgrade", 3, 4);
    public final InvSlotOutput outputSlot = new InvSlotOutput((TileEntityInventory)this, "output", 2, 9);
    private double progress = 0.0;

    public TileEntityCombinerSolidMatter() {
        super(0.0, 14, 0);
    }

    private static int applyModifier(int base, int extra) {
        double ret = Math.round((double)(base + extra) * 1.0);
        return ret > 2.147483647E9 ? Integer.MAX_VALUE : (int)ret;
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        boolean update = this.onUpdateUpgrade();
        this.maxEnergy = this.inputSlot.getMaxEnergy();
        this.progress = this.energy / this.maxEnergy;
        EnumSolidMatter[] solid = new EnumSolidMatter[]{};
        for (int i = 0; i < this.inputSlot.size(); ++i) {
            if (this.inputSlot.get(i) == null) continue;
            EnumSolidMatter[] solid1 = solid;
            solid = new EnumSolidMatter[solid.length + 1];
            solid[solid.length - 1] = ItemSolidMatter.getSolidMatter(this.inputSlot.get(i).func_77960_j());
            System.arraycopy(solid1, 0, solid, 0, solid1.length);
        }
        if (this.energy == this.maxEnergy) {
            for (EnumSolidMatter enumSolidMatter : solid) {
                if (!this.outputSlot.canAdd(enumSolidMatter.stack)) continue;
                this.outputSlot.add(enumSolidMatter.stack);
                this.energy = 0.0;
                this.progress = 0.0;
            }
        }
        if (update) {
            this.func_70296_d();
        }
    }

    public void func_70296_d() {
        super.func_70296_d();
        if (IC2.platform.isSimulating()) {
            this.setUpgradestat();
        }
    }

    public void setUpgradestat() {
        this.upgradeSlot.onChanged();
        this.setTier(TileEntityCombinerSolidMatter.applyModifier(this.getSinkTier(), this.upgradeSlot.extraTier));
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.progress = nbttagcompound.func_74769_h("progress");
        this.maxEnergy = nbttagcompound.func_74769_h("maxEnergy");
        this.energy = nbttagcompound.func_74769_h("energy");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74780_a("progress", this.progress);
        nbttagcompound.func_74780_a("maxEnergy", this.inputSlot.getMaxEnergy());
        nbttagcompound.func_74780_a("energy", this.energy);
    }

    public boolean shouldRenderInPass(int pass) {
        return true;
    }

    public double getEnergy() {
        return 0.0;
    }

    public boolean useEnergy(double v) {
        return false;
    }

    public Set<UpgradableProperty> getUpgradableProperties() {
        return EnumSet.of(UpgradableProperty.Transformer, UpgradableProperty.ItemProducing);
    }

    @Override
    public double injectEnergy(ForgeDirection directionFrom, double amount, double voltage) {
        this.maxEnergy = this.inputSlot.getMaxEnergy();
        if (this.energy >= this.maxEnergy) {
            return amount;
        }
        if (this.energy + amount >= this.maxEnergy) {
            double temp = this.maxEnergy - this.energy;
            this.energy += temp;
            return amount - temp;
        }
        this.energy += amount;
        return 0.0;
    }

    public boolean onUpdateUpgrade() {
        ItemStack stack;
        int i;
        for (i = 0; i < this.upgradeSlot.size(); ++i) {
            stack = this.upgradeSlot.get(i);
            if (stack == null) continue;
            return true;
        }
        for (i = 0; i < this.inputSlot.size(); ++i) {
            stack = this.inputSlot.get(i);
            if (stack == null) continue;
            return true;
        }
        return false;
    }

    public void onNetworkEvent(int event) {
    }

    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer entityPlayer, boolean isAdmin) {
        return new GUICombinerSolidMatter(new ContainerCombinerSolidMatter(entityPlayer, this));
    }

    public ContainerBase<? extends TileEntityCombinerSolidMatter> getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerCombinerSolidMatter(entityPlayer, this);
    }

    public void onGuiClosed(EntityPlayer entityPlayer) {
    }

    public String func_145825_b() {
        return "\u041e\u0431\u044a\u0435\u0434\u0438\u043d\u0438\u0442\u0435\u043b\u044c \u0433\u0435\u043d\u0435\u0440\u0430\u0442\u043e\u0440\u043e\u0432 \u0442\u0432\u0435\u0440\u0434\u043e\u0439 \u043c\u0430\u0442\u0435\u0440\u0438\u0438";
    }

    public double getProgress() {
        return this.progress;
    }
}

