/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.base;

import com.denfop.container.ContainerMultiMatter;
import com.denfop.gui.GUIMultiMatter;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.network.INetworkClientTileEntityEventListener;
import ic2.api.recipe.RecipeOutput;
import ic2.api.recipe.Recipes;
import ic2.core.ContainerBase;
import ic2.core.IC2;
import ic2.core.IHasGui;
import ic2.core.audio.AudioSource;
import ic2.core.audio.PositionSpec;
import ic2.core.block.TileEntityInventory;
import ic2.core.block.TileEntityLiquidTankElectricMachine;
import ic2.core.block.invslot.InvSlot;
import ic2.core.block.invslot.InvSlotConsumableLiquid;
import ic2.core.block.invslot.InvSlotConsumableLiquidByList;
import ic2.core.block.invslot.InvSlotOutput;
import ic2.core.block.invslot.InvSlotProcessableGeneric;
import ic2.core.block.invslot.InvSlotUpgrade;
import ic2.core.init.BlocksItems;
import ic2.core.init.InternalName;
import ic2.core.init.MainConfig;
import ic2.core.network.NetworkManager;
import ic2.core.upgrade.IUpgradableBlock;
import ic2.core.upgrade.IUpgradeItem;
import ic2.core.upgrade.UpgradableProperty;
import ic2.core.util.Config;
import ic2.core.util.ConfigUtil;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import org.apache.commons.lang3.mutable.MutableObject;

public abstract class TileEntityMultiMatter
extends TileEntityLiquidTankElectricMachine
implements IHasGui,
IUpgradableBlock,
INetworkClientTileEntityEventListener {
    public final InvSlotUpgrade upgradeSlot;
    public final InvSlotProcessableGeneric amplifierSlot;
    public final InvSlotOutput outputSlot;
    public final InvSlotConsumableLiquid containerSlot;
    private final double energyCost;
    public int scrap;
    public boolean work;
    private int state;
    private int prevState;
    private AudioSource audioSource;
    private AudioSource audioSourceScrap;

    public TileEntityMultiMatter(double energyCost, int sizeTank, float maxTempEnergy) {
        super(Math.round(maxTempEnergy * ConfigUtil.getFloat((Config)MainConfig.get(), (String)"balance/uuEnergyFactor")), 3, -1, sizeTank);
        this.energyCost = energyCost;
        this.amplifierSlot = new InvSlotProcessableGeneric((TileEntityInventory)this, "scrap", 0, 1, Recipes.matterAmplifier);
        this.outputSlot = new InvSlotOutput((TileEntityInventory)this, "output", 1, 1);
        this.containerSlot = new InvSlotConsumableLiquidByList((TileEntityInventory)this, "containerslot", 2, InvSlot.Access.I, 1, InvSlot.InvSide.TOP, InvSlotConsumableLiquid.OpType.Fill, new Fluid[]{BlocksItems.getFluid((InternalName)InternalName.fluidUuMatter)});
        this.upgradeSlot = new InvSlotUpgrade((TileEntityInventory)this, "upgrade", 3, 4);
        this.work = true;
    }

    private static int applyModifier(int base, int extra) {
        double ret = Math.round((double)(base + extra) * 1.0);
        return ret > 2.147483647E9 ? Integer.MAX_VALUE : (int)ret;
    }

    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        try {
            this.scrap = nbttagcompound.func_74762_e("scrap");
        }
        catch (Throwable e) {
            this.scrap = nbttagcompound.func_74765_d("scrap");
        }
        this.work = nbttagcompound.func_74767_n("work");
    }

    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74768_a("scrap", this.scrap);
        nbttagcompound.func_74757_a("work", this.work);
    }

    public void updateEntityServer() {
        super.updateEntityServer();
        boolean needsInvUpdate = this.onUpdateUpgrade();
        if (!this.work || this.energy <= 0.0) {
            this.setState(0);
            this.setActive(false);
        } else {
            MutableObject output;
            RecipeOutput amplifier;
            this.setState(this.scrap > 0 ? 2 : 1);
            this.setActive(true);
            if (this.scrap < 10000 && (amplifier = this.amplifierSlot.process()) != null) {
                this.amplifierSlot.consume();
                this.scrap += amplifier.metadata.func_74762_e("amplification");
            }
            if (this.energy >= this.energyCost) {
                needsInvUpdate = this.attemptGeneration();
            }
            if (this.containerSlot.transferFromTank((IFluidTank)this.fluidTank, output = new MutableObject(), true) && (output.getValue() == null || this.outputSlot.canAdd((ItemStack)output.getValue()))) {
                this.containerSlot.transferFromTank((IFluidTank)this.fluidTank, output, false);
                if (output.getValue() != null) {
                    this.outputSlot.add((ItemStack)output.getValue());
                }
            }
            if (needsInvUpdate && this.field_145850_b.field_73011_w.getWorldTime() % 10L == 0L) {
                this.func_70296_d();
            }
        }
    }

    public boolean onUpdateUpgrade() {
        for (int i = 0; i < this.upgradeSlot.size(); ++i) {
            ItemStack stack = this.upgradeSlot.get(i);
            if (stack == null || !(stack.func_77973_b() instanceof IUpgradeItem)) continue;
            return ((IUpgradeItem)stack.func_77973_b()).onTick(stack, (IUpgradableBlock)this);
        }
        return false;
    }

    public void onUnloaded() {
        if (IC2.platform.isRendering() && this.audioSource != null) {
            IC2.audioManager.removeSources((Object)this);
            this.audioSource = null;
            this.audioSourceScrap = null;
        }
        super.onUnloaded();
    }

    public boolean attemptGeneration() {
        int k = (int)(this.energy / this.energyCost);
        if (this.fluidTank.getFluidAmount() + 1 > this.fluidTank.getCapacity()) {
            return false;
        }
        int m = this.fluidTank.getCapacity() - this.fluidTank.getFluidAmount();
        this.fill(null, new FluidStack(BlocksItems.getFluid((InternalName)InternalName.fluidUuMatter), Math.min(m, k)), true);
        this.energy -= this.energyCost * (double)Math.min(m, k);
        return true;
    }

    public double getDemandedEnergy() {
        if (!this.work) {
            return 0.0;
        }
        return (double)this.maxEnergy - this.energy;
    }

    public double injectEnergy(ForgeDirection directionFrom, double amount, double voltage) {
        if (this.energy >= (double)this.maxEnergy && !this.work) {
            return amount;
        }
        int bonus = Math.min((int)amount, this.scrap);
        this.scrap -= bonus;
        if (this.energy + amount >= (double)this.maxEnergy) {
            double temp = (double)this.maxEnergy - this.energy;
            this.energy += temp;
            return amount - temp;
        }
        this.energy += amount + (double)(5 * bonus);
        return 0.0;
    }

    public String getProgressAsString() {
        int p = Math.min((int)(this.energy * 100.0 / this.energyCost), 100);
        return p + "%";
    }

    public ContainerBase<TileEntityMultiMatter> getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerMultiMatter(entityPlayer, this);
    }

    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer entityPlayer, boolean isAdmin) {
        return new GUIMultiMatter(new ContainerMultiMatter(entityPlayer, this));
    }

    public void onGuiClosed(EntityPlayer entityPlayer) {
    }

    private void setState(int aState) {
        this.state = aState;
        if (this.prevState != this.state) {
            ((NetworkManager)IC2.network.get()).updateTileEntityField((TileEntity)this, "state");
        }
        this.prevState = this.state;
    }

    public List<String> getNetworkedFields() {
        Vector<String> ret = new Vector<String>(1);
        ret.add("state");
        ret.addAll(super.getNetworkedFields());
        return ret;
    }

    public void onNetworkUpdate(String field) {
        if (field.equals("state") && this.prevState != this.state) {
            switch (this.state) {
                case 0: {
                    if (this.audioSource != null) {
                        this.audioSource.stop();
                    }
                    if (this.audioSourceScrap == null) break;
                    this.audioSourceScrap.stop();
                    break;
                }
                case 1: {
                    if (this.audioSource == null) {
                        this.audioSource = IC2.audioManager.createSource((Object)this, PositionSpec.Center, "Generators/MassFabricator/MassFabLoop.ogg", true, false, IC2.audioManager.getDefaultVolume());
                    }
                    if (this.audioSource != null) {
                        this.audioSource.play();
                    }
                    if (this.audioSourceScrap == null) break;
                    this.audioSourceScrap.stop();
                    break;
                }
                case 2: {
                    if (this.audioSource == null) {
                        this.audioSource = IC2.audioManager.createSource((Object)this, PositionSpec.Center, "Generators/MassFabricator/MassFabLoop.ogg", true, false, IC2.audioManager.getDefaultVolume());
                    }
                    if (this.audioSourceScrap == null) {
                        this.audioSourceScrap = IC2.audioManager.createSource((Object)this, PositionSpec.Center, "Generators/MassFabricator/MassFabScrapSolo.ogg", true, false, IC2.audioManager.getDefaultVolume());
                    }
                    if (this.audioSource != null) {
                        this.audioSource.play();
                    }
                    if (this.audioSourceScrap == null) break;
                    this.audioSourceScrap.play();
                }
            }
            this.prevState = this.state;
        }
        super.onNetworkUpdate(field);
    }

    public float getWrenchDropRate() {
        return 0.7f;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return fluid == BlocksItems.getFluid((InternalName)InternalName.fluidUuMatter);
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public void onLoaded() {
        super.onLoaded();
        if (IC2.platform.isSimulating()) {
            this.setUpgradestat();
        }
    }

    public void func_70296_d() {
        super.func_70296_d();
        if (IC2.platform.isSimulating()) {
            this.setUpgradestat();
        }
    }

    public void setUpgradestat() {
        this.upgradeSlot.onChanged();
        this.setTier(TileEntityMultiMatter.applyModifier(3, this.upgradeSlot.extraTier));
    }

    public double getEnergy() {
        return this.energy;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return !this.canDrain(from, null) ? null : this.getFluidTank().drain(maxDrain, doDrain);
    }

    public boolean useEnergy(double amount) {
        if (this.energy >= amount) {
            this.energy -= amount;
            return true;
        }
        return false;
    }

    public void onNetworkEvent(EntityPlayer player, int event) {
        this.work = !this.work;
    }

    public Set<UpgradableProperty> getUpgradableProperties() {
        return EnumSet.of(UpgradableProperty.RedstoneSensitive, UpgradableProperty.Transformer, UpgradableProperty.ItemConsuming, UpgradableProperty.ItemProducing, UpgradableProperty.FluidProducing);
    }
}

