/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.base;

import com.denfop.IUCore;
import com.denfop.audio.AudioSource;
import com.denfop.block.base.BlocksItems;
import com.denfop.container.ContainerOilGetter;
import com.denfop.gui.GUIOilGetter;
import com.denfop.tiles.base.TileOilBlock;
import com.denfop.tiles.neutroniumgenerator.TileEntityLiquidTankElectricMachine;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.network.INetworkTileEntityEventListener;
import ic2.core.ContainerBase;
import ic2.core.IC2;
import ic2.core.IHasGui;
import ic2.core.block.TileEntityInventory;
import ic2.core.block.invslot.InvSlot;
import ic2.core.block.invslot.InvSlotConsumableLiquid;
import ic2.core.block.invslot.InvSlotConsumableLiquidByList;
import ic2.core.block.invslot.InvSlotOutput;
import ic2.core.block.invslot.InvSlotUpgrade;
import ic2.core.network.NetworkManager;
import ic2.core.upgrade.IUpgradableBlock;
import ic2.core.upgrade.IUpgradeItem;
import ic2.core.upgrade.UpgradableProperty;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import org.apache.commons.lang3.mutable.MutableObject;

public class TileEntityOilGetter
extends TileEntityLiquidTankElectricMachine
implements IHasGui,
IUpgradableBlock,
INetworkTileEntityEventListener {
    public static int heading;
    public final int defaultTier;
    public final InvSlotUpgrade upgradeSlot;
    public final InvSlotOutput outputSlot = new InvSlotOutput((TileEntityInventory)this, "output", 1, 1);
    public final InvSlotConsumableLiquid containerslot = new InvSlotConsumableLiquidByList((TileEntityInventory)this, "containerslot", 2, InvSlot.Access.I, 1, InvSlot.InvSide.TOP, InvSlotConsumableLiquid.OpType.Fill, new Fluid[]{BlocksItems.getFluid("fluidneft")});
    public int number;
    public int max;
    public boolean notoil = true;
    private AudioSource audioSource;

    public TileEntityOilGetter() {
        super(50000.0, 14, -1, 20);
        this.upgradeSlot = new InvSlotUpgrade((TileEntityInventory)this, "upgrade", 3, 4);
        this.defaultTier = 3;
        heading = 2;
    }

    private static int applyModifier(int base, int extra) {
        double ret = Math.round((double)(base + extra) * 1.0);
        return ret > 2.147483647E9 ? Integer.MAX_VALUE : (int)ret;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.fluidTank.readFromNBT(nbttagcompound.func_74775_l("fluidTank"));
        this.number = nbttagcompound.func_74762_e("number");
        this.max = nbttagcompound.func_74762_e("max");
        this.notoil = nbttagcompound.func_74767_n("notoil");
        heading = nbttagcompound.func_74762_e("heading");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        NBTTagCompound fluidTankTag = new NBTTagCompound();
        this.fluidTank.writeToNBT(fluidTankTag);
        nbttagcompound.func_74782_a("fluidTank", (NBTBase)fluidTankTag);
        nbttagcompound.func_74768_a("number", this.number);
        nbttagcompound.func_74768_a("max", this.max);
        nbttagcompound.func_74757_a("notoil", this.notoil);
        nbttagcompound.func_74768_a("heading", heading);
    }

    public String func_145825_b() {
        return null;
    }

    public void updateEntityServer() {
        super.updateEntityServer();
        boolean needsInvUpdate = false;
        for (int i = 0; i < this.upgradeSlot.size(); ++i) {
            ItemStack stack = this.upgradeSlot.get(i);
            if (stack == null || !(stack.func_77973_b() instanceof IUpgradeItem) || !((IUpgradeItem)stack.func_77973_b()).onTick(stack, (IUpgradableBlock)this)) continue;
            needsInvUpdate = true;
        }
        MutableObject output = new MutableObject();
        if (this.containerslot.transferFromTank((IFluidTank)this.fluidTank, output, true) && (output.getValue() == null || this.outputSlot.canAdd((ItemStack)output.getValue()))) {
            this.containerslot.transferFromTank((IFluidTank)this.fluidTank, output, false);
            if (output.getValue() != null) {
                this.outputSlot.add((ItemStack)output.getValue());
            }
        }
        this.get_oil_max();
        if (this.energy >= 10.0 && !this.notoil) {
            this.get_oil();
            this.initiate(0);
        } else {
            this.initiate(2);
        }
        if (this.field_145850_b.field_73011_w.getWorldTime() % 60L == 0L) {
            this.initiate(2);
        }
        if (needsInvUpdate) {
            this.func_70296_d();
        }
    }

    private void get_oil_max() {
        Map map = this.field_145850_b.func_72938_d((int)this.field_145851_c, (int)this.field_145849_e).field_150816_i;
        for (Object o : map.values()) {
            TileEntity tile = (TileEntity)o;
            if (tile instanceof TileOilBlock) {
                TileOilBlock tile1 = (TileOilBlock)tile;
                this.max = tile1.max;
                this.number = tile1.number;
                this.notoil = false;
                return;
            }
            this.notoil = true;
        }
    }

    private void get_oil() {
        Map map = this.field_145850_b.func_72938_d((int)this.field_145851_c, (int)this.field_145849_e).field_150816_i;
        for (Object o : map.values()) {
            TileEntity tile = (TileEntity)o;
            if (!(tile instanceof TileOilBlock)) continue;
            TileOilBlock tile1 = (TileOilBlock)tile;
            if (tile1.number < 1 || this.fluidTank.getFluidAmount() + 1 > this.fluidTank.getCapacity()) continue;
            this.fill(null, new FluidStack(BlocksItems.getFluid("fluidneft"), 1), true);
            --tile1.number;
            this.energy -= 10.0;
        }
    }

    @Override
    public void onUnloaded() {
        if (IC2.platform.isRendering() && this.audioSource != null) {
            IUCore.audioManager.removeSources((Object)this);
            this.audioSource = null;
        }
        super.onUnloaded();
    }

    @Override
    public double getDemandedEnergy() {
        return this.maxEnergy - this.energy;
    }

    @Override
    public double injectEnergy(ForgeDirection directionFrom, double amount, double voltage) {
        if (this.energy >= this.maxEnergy) {
            return amount;
        }
        this.energy += amount;
        return 0.0;
    }

    public ContainerBase<TileEntityOilGetter> getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerOilGetter(entityPlayer, this);
    }

    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer entityPlayer, boolean isAdmin) {
        return new GUIOilGetter(new ContainerOilGetter(entityPlayer, this));
    }

    public void onGuiClosed(EntityPlayer entityPlayer) {
    }

    public boolean shouldRenderInPass(int pass) {
        return true;
    }

    public List<String> getNetworkedFields() {
        Vector<String> ret = new Vector<String>(1);
        ret.addAll(super.getNetworkedFields());
        return ret;
    }

    @Override
    public void onNetworkUpdate(String field) {
        super.onNetworkUpdate(field);
    }

    public float getWrenchDropRate() {
        return 0.7f;
    }

    @Override
    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return fluid == BlocksItems.getFluid("fluidneft");
    }

    @Override
    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return true;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (IC2.platform.isSimulating()) {
            this.setUpgradestat();
        }
    }

    public void func_70296_d() {
        super.func_70296_d();
        if (IC2.platform.isSimulating()) {
            this.setUpgradestat();
        }
    }

    public void setUpgradestat() {
        this.upgradeSlot.onChanged();
        this.setTier(TileEntityOilGetter.applyModifier(this.defaultTier, this.upgradeSlot.extraTier));
    }

    public double getEnergy() {
        return this.energy;
    }

    public boolean useEnergy(double amount) {
        if (this.energy >= amount) {
            this.energy -= amount;
            return true;
        }
        return false;
    }

    private void initiate(int soundEvent) {
        ((NetworkManager)IC2.network.get()).initiateTileEntityEvent((TileEntity)this, soundEvent, true);
    }

    public String getStartSoundFile() {
        return "Machines/oilgetter.ogg";
    }

    public String getInterruptSoundFile() {
        return "Machines/InterruptOne.ogg";
    }

    public void onNetworkEvent(int event) {
        if (this.audioSource == null && this.getStartSoundFile() != null) {
            this.audioSource = IUCore.audioManager.createSource((Object)this, this.getStartSoundFile());
        }
        switch (event) {
            case 0: {
                if (this.audioSource == null) break;
                this.audioSource.play();
                break;
            }
            case 1: {
                if (this.audioSource == null) break;
                this.audioSource.stop();
                if (this.getInterruptSoundFile() == null) break;
                IUCore.audioManager.playOnce((Object)this, this.getInterruptSoundFile());
                break;
            }
            case 2: {
                if (this.audioSource == null) break;
                this.audioSource.stop();
            }
        }
    }

    public Set<UpgradableProperty> getUpgradableProperties() {
        return EnumSet.of(UpgradableProperty.RedstoneSensitive, UpgradableProperty.Transformer, UpgradableProperty.ItemConsuming, UpgradableProperty.ItemProducing, UpgradableProperty.FluidProducing);
    }
}

