/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.base;

import com.denfop.IUItem;
import com.denfop.tiles.base.TileEntityAnalyzer;
import com.denfop.tiles.base.TileEntityElectricMachine;
import com.denfop.tiles.base.TileEntityVein;
import com.denfop.tiles.base.TileOilBlock;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.network.INetworkClientTileEntityEventListener;
import ic2.api.network.INetworkDataProvider;
import ic2.api.network.INetworkUpdateListener;
import ic2.core.ContainerBase;
import ic2.core.IC2;
import ic2.core.IHasGui;
import ic2.core.network.NetworkManager;
import java.util.Random;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.StatCollector;
import net.minecraft.world.biome.BiomeGenBase;

public class TileEntityQuarryVein
extends TileEntityElectricMachine
implements IHasGui,
INetworkUpdateListener,
INetworkDataProvider,
INetworkClientTileEntityEventListener {
    public boolean empty = true;
    public int x = 0;
    public int y = 0;
    public int z = 0;
    public int progress = 0;
    public int number = 0;
    public boolean analysis = true;

    public TileEntityQuarryVein() {
        super(20.0, 14, 1);
    }

    private void updateTileEntityField() {
        ((NetworkManager)IC2.network.get()).updateTileEntityField((TileEntity)this, "x");
        ((NetworkManager)IC2.network.get()).updateTileEntityField((TileEntity)this, "y");
        ((NetworkManager)IC2.network.get()).updateTileEntityField((TileEntity)this, "z");
        ((NetworkManager)IC2.network.get()).updateTileEntityField((TileEntity)this, "analysis");
        ((NetworkManager)IC2.network.get()).updateTileEntityField((TileEntity)this, "empty");
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.field_145850_b.field_73011_w.getWorldTime() % 40L == 0L) {
            this.updateTileEntityField();
        }
        if (this.field_145850_b.field_73011_w.field_76574_g != 0) {
            this.empty = true;
            return;
        }
        int chunkx = this.field_145850_b.func_72938_d((int)this.field_145851_c, (int)this.field_145849_e).func_76632_l().field_77276_a * 16;
        int chunkz = this.field_145850_b.func_72938_d((int)this.field_145851_c, (int)this.field_145849_e).func_76632_l().field_77275_b * 16;
        if (this.field_145850_b.func_147438_o(chunkx, 0, chunkz) != null && (this.field_145850_b.func_147438_o(chunkx, 0, chunkz) instanceof TileOilBlock || this.field_145850_b.func_147438_o(chunkx, 0, chunkz) instanceof TileEntityVein)) {
            TileEntity tileEntity = this.field_145850_b.func_147438_o(chunkx, 0, chunkz);
            if (tileEntity instanceof TileEntityVein) {
                TileEntityVein tile1 = (TileEntityVein)tileEntity;
                if (tile1.change) {
                    this.number = tile1.number;
                    this.analysis = false;
                    this.empty = false;
                    this.progress = 1200;
                    this.x = chunkx;
                    this.y = 0;
                    this.z = chunkz;
                    return;
                }
            } else {
                tileEntity = this.field_145850_b.func_147438_o(chunkx, 0, chunkz);
                if (tileEntity instanceof TileOilBlock) {
                    TileOilBlock tile1 = (TileOilBlock)tileEntity;
                    if (tile1.change && !tile1.empty) {
                        this.number = tile1.number;
                        this.analysis = false;
                        this.progress = 1200;
                        this.x = chunkx;
                        this.y = 0;
                        this.z = chunkz;
                        this.empty = tile1.empty;
                        return;
                    }
                    this.empty = true;
                }
            }
        }
        if (this.analysis && this.energy >= 5.0) {
            ++this.progress;
            this.energy -= 5.0;
            if (this.progress >= 1200) {
                this.analysis = false;
                chunkx = this.field_145850_b.func_72938_d((int)this.field_145851_c, (int)this.field_145849_e).func_76632_l().field_77276_a * 16;
                chunkz = this.field_145850_b.func_72938_d((int)this.field_145851_c, (int)this.field_145849_e).func_76632_l().field_77275_b * 16;
                Random rand = new Random();
                int p = rand.nextInt(100);
                if (p >= 10) {
                    this.field_145850_b.func_147449_b(chunkx, 0, chunkz, IUItem.oilBlock);
                    TileOilBlock oil = (TileOilBlock)this.field_145850_b.func_147438_o(chunkx, 0, chunkz);
                    oil.change = true;
                    this.getNumber(oil);
                    this.x = chunkx;
                    this.y = 0;
                    this.z = chunkz;
                    this.number = oil.number;
                } else if (this.field_145850_b.func_147439_a(chunkx, 0, chunkz) != null && p < 10) {
                    int k = rand.nextInt(12);
                    this.field_145850_b.func_147465_d(chunkx, 0, chunkz, IUItem.vein, k, 3);
                    TileEntityVein vein = (TileEntityVein)this.field_145850_b.func_147438_o(chunkx, 0, chunkz);
                    vein.change = true;
                    vein.meta = k;
                    this.number = vein.number;
                    this.x = chunkx;
                    this.y = 0;
                    this.z = chunkz;
                }
            }
        }
    }

    private void getNumber(TileOilBlock tile) {
        BiomeGenBase biome = this.field_145850_b.func_72807_a(tile.field_145851_c, tile.field_145849_e);
        Random rand = this.field_145850_b.field_73012_v;
        if (BiomeGenBase.field_76769_d.equals(biome)) {
            int random = rand.nextInt(100);
            if (random > 40) {
                tile.number = rand.nextInt(50000) + 20000;
            } else {
                tile.empty = true;
                tile.number = 0;
            }
        } else if (biome.field_76756_M == 130) {
            int random = rand.nextInt(100);
            if (random > 40) {
                tile.number = rand.nextInt(50000) + 20000;
            } else {
                tile.empty = true;
                tile.number = 0;
            }
        } else if (BiomeGenBase.field_76771_b.equals(biome)) {
            int random = rand.nextInt(100);
            if (random > 65) {
                tile.number = rand.nextInt(80000);
            } else {
                tile.empty = true;
                tile.number = 0;
            }
        } else if (BiomeGenBase.field_150575_M.equals(biome)) {
            int random = rand.nextInt(100);
            if (random > 40) {
                tile.number = rand.nextInt(80000);
            } else {
                tile.empty = true;
                tile.number = 0;
            }
        } else if (BiomeGenBase.field_76776_l.equals(biome)) {
            int random = rand.nextInt(100);
            if (random > 65) {
                tile.number = rand.nextInt(80000);
            } else {
                tile.empty = true;
                tile.number = 0;
            }
        } else if (BiomeGenBase.field_76786_s.equals(biome)) {
            int random = rand.nextInt(100);
            if (random > 40) {
                tile.number = rand.nextInt(60000) + 20000;
            } else {
                tile.empty = true;
                tile.number = 0;
            }
        } else if (BiomeGenBase.field_76781_i.equals(biome)) {
            int random = rand.nextInt(100);
            if (random > 55) {
                tile.number = rand.nextInt(20000);
            } else {
                tile.empty = true;
                tile.number = 0;
            }
        } else if (BiomeGenBase.field_150588_X.equals(biome)) {
            int random = rand.nextInt(100);
            if (random > 55) {
                tile.number = rand.nextInt(40000);
            } else {
                tile.empty = true;
                tile.number = 0;
            }
        } else {
            int random = rand.nextInt(100);
            if (random > 75) {
                tile.number = rand.nextInt(20000);
            } else {
                tile.empty = true;
                tile.number = 0;
            }
        }
        tile.max = tile.number;
    }

    public boolean shouldRenderInPass(int pass) {
        return true;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.empty = nbttagcompound.func_74767_n("empty");
        this.analysis = nbttagcompound.func_74767_n("analysis");
        this.progress = nbttagcompound.func_74762_e("progress");
        this.number = nbttagcompound.func_74762_e("number");
        this.x = nbttagcompound.func_74762_e("x1");
        this.y = nbttagcompound.func_74762_e("y1");
        this.z = nbttagcompound.func_74762_e("z1");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74757_a("empty", this.empty);
        nbttagcompound.func_74757_a("analysis", this.analysis);
        nbttagcompound.func_74768_a("progress", this.progress);
        nbttagcompound.func_74768_a("number", this.number);
        nbttagcompound.func_74768_a("x1", this.x);
        nbttagcompound.func_74768_a("y1", this.y);
        nbttagcompound.func_74768_a("z1", this.z);
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer entityPlayer, boolean isAdmin) {
        return null;
    }

    public ContainerBase<? extends TileEntityAnalyzer> getGuiContainer(EntityPlayer entityPlayer) {
        return null;
    }

    public void onNetworkEvent(EntityPlayer player, int event) {
    }

    public float getWrenchDropRate() {
        return 0.85f;
    }

    public void onGuiClosed(EntityPlayer arg0) {
    }

    public String func_145825_b() {
        return StatCollector.func_74838_a((String)"iu.blockAnalyzer.name");
    }
}

