/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.base;

import com.denfop.IUCore;
import com.denfop.audio.AudioSource;
import com.denfop.tiles.base.TileEntityElectricMachine;
import ic2.api.network.INetworkTileEntityEventListener;
import ic2.core.IC2;
import ic2.core.network.NetworkManager;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;

public class TileEntityRadiationPurifier
extends TileEntityElectricMachine
implements INetworkTileEntityEventListener {
    private final int type;
    public AudioSource audioSource;

    public TileEntityRadiationPurifier() {
        super(50000.0, 14, -1);
        this.type = 1;
    }

    @Override
    public void onUnloaded() {
        super.onUnloaded();
        if (IC2.platform.isRendering() && this.audioSource != null) {
            IUCore.audioManager.removeSources((Object)this);
            this.audioSource = null;
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.energy > (double)(10 * this.type)) {
            this.energy -= (double)(10 * this.type);
            this.setActive(true);
            this.initiate(0);
        } else {
            this.initiate(2);
            this.setActive(false);
        }
        if (this.field_145850_b.field_73011_w.getWorldTime() % 300L == 0L) {
            this.initiate(2);
        }
    }

    public float getWrenchDropRate() {
        return 0.85f;
    }

    private void initiate(int soundEvent) {
        ((NetworkManager)IC2.network.get()).initiateTileEntityEvent((TileEntity)this, soundEvent, true);
    }

    public String getStartSoundFile() {
        return "Machines/radiation.ogg";
    }

    public String getInterruptSoundFile() {
        return "Machines/InterruptOne.ogg";
    }

    public void onNetworkEvent(int event) {
        if (this.audioSource == null && this.getStartSoundFile() != null) {
            this.audioSource = IUCore.audioManager.createSource((Object)this, this.getStartSoundFile());
        }
        switch (event) {
            case 0: {
                if (this.audioSource == null) break;
                this.audioSource.play();
                break;
            }
            case 1: {
                if (this.audioSource == null) break;
                this.audioSource.stop();
                if (this.getInterruptSoundFile() == null) break;
                IUCore.audioManager.playOnce((Object)this, this.getInterruptSoundFile());
                break;
            }
            case 2: {
                if (this.audioSource == null) break;
                this.audioSource.stop();
            }
        }
    }

    public String func_145825_b() {
        return null;
    }
}

