/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.base;

import com.denfop.container.ContainerTransformer;
import com.denfop.gui.GUITransformer;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.energy.EnergyNet;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergySource;
import ic2.api.energy.tile.IEnergyTile;
import ic2.api.network.INetworkClientTileEntityEventListener;
import ic2.core.ContainerBase;
import ic2.core.IC2;
import ic2.core.IHasGui;
import ic2.core.block.TileEntityInventory;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class TileEntityTransformer
extends TileEntityInventory
implements IEnergySink,
IEnergySource,
IHasGui,
INetworkClientTileEntityEventListener {
    public final int tier;
    public final double maxStorage;
    public int mode;
    public double power;
    public double energy = 0.0;
    public boolean redstone = false;
    public boolean addedToEnergyNet = false;
    private boolean needrefresh = false;
    private double inputflow = 0.0;
    private double outputflow = 0.0;

    public TileEntityTransformer(int tier) {
        this.tier = tier;
        this.power = EnergyNet.instance.getPowerFromTier(tier);
        this.maxStorage = this.power * 8.0;
    }

    public String func_145825_b() {
        return StatCollector.func_74838_a((String)("Transformer" + this.getType() + ".name"));
    }

    public String getType() {
        String string;
        switch (this.tier) {
            case 5: {
                string = "UMV";
                break;
            }
            case 6: {
                string = "UHV";
                break;
            }
            case 7: {
                string = "UEV";
                break;
            }
            case 8: {
                string = "UMHV";
                break;
            }
            case 9: {
                string = "UMEV";
                break;
            }
            case 10: {
                string = "UHEV";
                break;
            }
            case 11: {
                string = "HEEV";
                break;
            }
            default: {
                string = "";
            }
        }
        return string;
    }

    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.mode = nbttagcompound.func_74762_e("mode");
        this.energy = nbttagcompound.func_74769_h("energy");
    }

    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74780_a("energy", this.energy);
        nbttagcompound.func_74768_a("mode", this.mode);
    }

    public int getMode() {
        return this.mode;
    }

    public void onNetworkEvent(EntityPlayer player, int event) {
        switch (event) {
            case 0: 
            case 1: 
            case 2: {
                this.mode = event;
                break;
            }
            case 3: {
                this.outputflow = EnergyNet.instance.getPowerFromTier(this.getSourceTier());
                this.inputflow = EnergyNet.instance.getPowerFromTier(this.getSinkTier());
                this.needrefresh = true;
            }
        }
    }

    public void onLoaded() {
        super.onLoaded();
        if (IC2.platform.isSimulating()) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)this));
            this.addedToEnergyNet = true;
        }
    }

    public void onUnloaded() {
        if (IC2.platform.isSimulating() && this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)this));
            this.addedToEnergyNet = false;
        }
        super.onUnloaded();
    }

    public void updateEntityServer() {
        super.updateEntityServer();
        this.updateRedstone();
    }

    public void updateRedstone() {
        boolean bl;
        switch (this.mode) {
            case 0: {
                bl = this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                break;
            }
            case 1: {
                bl = false;
                break;
            }
            case 2: {
                bl = true;
                break;
            }
            default: {
                throw new RuntimeException("invalid mode: " + this.mode);
            }
        }
        boolean red = bl;
        if (red != this.redstone) {
            if (this.addedToEnergyNet) {
                MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)this));
            }
            this.addedToEnergyNet = false;
            this.energy = 0.0;
            this.redstone = red;
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)this));
            this.addedToEnergyNet = true;
            this.setActive(this.redstone);
            this.power = EnergyNet.instance.getPowerFromTier(this.getSourceTier());
        }
    }

    public boolean acceptsEnergyFrom(TileEntity emitter, ForgeDirection direction) {
        if (this.redstone) {
            return !this.facingMatchesDirection(direction);
        }
        return this.facingMatchesDirection(direction);
    }

    public boolean emitsEnergyTo(TileEntity receiver, ForgeDirection direction) {
        if (this.redstone) {
            return this.facingMatchesDirection(direction);
        }
        return !this.facingMatchesDirection(direction);
    }

    public boolean facingMatchesDirection(ForgeDirection direction) {
        return direction.ordinal() == this.getFacing();
    }

    public double getOfferedEnergy() {
        return this.energy >= this.power ? this.power : 0.0;
    }

    public void drawEnergy(double amount) {
        this.outputflow = amount;
        this.energy -= amount;
    }

    public double getDemandedEnergy() {
        if (this.needrefresh) {
            this.needrefresh = false;
            return 1.0;
        }
        return this.maxStorage - this.energy;
    }

    public double injectEnergy(ForgeDirection directionFrom, double amount, double voltage) {
        this.inputflow = amount;
        this.energy += amount;
        return 0.0;
    }

    public int getSourceTier() {
        if (this.redstone) {
            return this.tier + 1;
        }
        return this.tier;
    }

    public int getSinkTier() {
        if (this.redstone) {
            return this.tier;
        }
        if (this.tier < 4) {
            return this.tier + 1;
        }
        return Integer.MAX_VALUE;
    }

    public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, int side) {
        return this.getFacing() != side;
    }

    public void setFacing(short side) {
        if (this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)this));
        }
        this.energy = 0.0;
        super.setFacing(side);
        if (this.addedToEnergyNet) {
            this.addedToEnergyNet = false;
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)this));
            this.addedToEnergyNet = true;
        }
    }

    public ContainerBase<TileEntityTransformer> getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerTransformer(entityPlayer, this);
    }

    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer entityPlayer, boolean isAdmin) {
        return new GUITransformer(new ContainerTransformer(entityPlayer, this));
    }

    public void onGuiClosed(EntityPlayer entityPlayer) {
    }

    public double getinputflow() {
        if (!this.redstone) {
            return this.inputflow;
        }
        return this.outputflow;
    }

    public double getoutputflow() {
        if (this.redstone) {
            return this.inputflow;
        }
        return this.outputflow;
    }
}

