/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.mechanism;

import com.denfop.IUCore;
import com.denfop.IUItem;
import com.denfop.audio.AudioSource;
import com.denfop.config.IUConfig;
import com.denfop.container.ContainerQuantumQuarry;
import com.denfop.gui.GUIQuantumQuarry;
import com.denfop.invslot.InvSlotQuantumQuarry;
import com.denfop.item.modules.EnumQuarryModules;
import com.denfop.item.modules.EnumQuarryType;
import com.denfop.tiles.base.TileEntityElectricMachine;
import com.denfop.tiles.base.TileEntityVein;
import com.denfop.utils.SomeUtils;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.Direction;
import ic2.api.network.INetworkTileEntityEventListener;
import ic2.core.ContainerBase;
import ic2.core.IC2;
import ic2.core.IHasGui;
import ic2.core.block.TileEntityInventory;
import ic2.core.block.invslot.InvSlotOutput;
import ic2.core.network.NetworkManager;
import ic2.core.util.StackUtil;
import ic2.core.util.Util;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.oredict.OreDictionary;

public class TileEntityBaseQuantumQuarry
extends TileEntityElectricMachine
implements IHasGui,
INetworkTileEntityEventListener {
    public final Random rand = new Random();
    public final int energyconsume;
    public final InvSlotQuantumQuarry inputslotB;
    public final InvSlotOutput outputSlot;
    public final InvSlotQuantumQuarry inputslot;
    public final InvSlotQuantumQuarry inputslotA;
    private final String name;
    public AudioSource audioSource;
    public double getblock;
    private boolean isAnalyzerInstalled;
    private int progress = 0;

    public TileEntityBaseQuantumQuarry(String name, int amp) {
        super(5.0E7, 14, 1);
        this.name = name;
        this.getblock = 0.0;
        this.energyconsume = IUConfig.quarry_energy_cost * amp;
        this.outputSlot = new InvSlotOutput((TileEntityInventory)this, "output", 2, 24);
        this.inputslot = new InvSlotQuantumQuarry(this, 3, "input", 0);
        this.inputslotA = new InvSlotQuantumQuarry(this, 4, "input1", 1);
        this.inputslotB = new InvSlotQuantumQuarry(this, 5, "input2", 2);
        this.isAnalyzerInstalled = false;
    }

    public static boolean isNotWhitelistedOrBlacklisted(TileEntityBaseQuantumQuarry tile, ItemStack stack1) {
        if (tile.inputslotA.isEmpty()) {
            return false;
        }
        EnumQuarryModules module = IUItem.quarryModules.get(tile.inputslotA.get().func_77960_j());
        EnumQuarryType type = module.type;
        String stack = OreDictionary.getOreName((int)OreDictionary.getOreID((ItemStack)stack1));
        if (type == EnumQuarryType.BLACKLIST) {
            for (int j = 0; j < 9; ++j) {
                String l = "number_" + j;
                String temp = SomeUtils.nbtGetString(tile.inputslotA.get(), l);
                if (!temp.startsWith("ore") && !temp.startsWith("gem") && !temp.startsWith("dust") && !temp.startsWith("shard") || !temp.equals(stack)) continue;
                return true;
            }
            return false;
        }
        if (type == EnumQuarryType.WHITELIST) {
            for (int j = 0; j < 9; ++j) {
                String l = "number_" + j;
                String temp = SomeUtils.nbtGetString(tile.inputslotA.get(), l);
                if (!temp.startsWith("ore") && !temp.startsWith("gem") && !temp.startsWith("dust") && !temp.startsWith("shard") || !temp.equals(stack)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public ItemStack getWrenchDrop(EntityPlayer entityPlayer) {
        EntityItem var16;
        double var14;
        double var12;
        double var10;
        double var8;
        int i;
        ItemStack ret = super.getWrenchDrop(entityPlayer);
        if (this.inputslot.get() != null) {
            double var82 = 0.7;
            double var102 = (double)this.field_145850_b.field_73012_v.nextFloat() * var82 + (1.0 - var82) * 0.5;
            double var122 = (double)this.field_145850_b.field_73012_v.nextFloat() * var82 + (1.0 - var82) * 0.5;
            double var142 = (double)this.field_145850_b.field_73012_v.nextFloat() * var82 + (1.0 - var82) * 0.5;
            EntityItem var162 = new EntityItem(this.field_145850_b, (double)this.field_145851_c + var102, (double)this.field_145848_d + var122, (double)this.field_145849_e + var142, this.inputslot.get());
            var162.field_145804_b = 10;
            this.field_145850_b.func_72838_d((Entity)var162);
        }
        for (i = 0; i < this.inputslotA.size(); ++i) {
            if (this.inputslotA.get(i) == null) continue;
            var8 = 0.7;
            var10 = (double)this.field_145850_b.field_73012_v.nextFloat() * var8 + (1.0 - var8) * 0.5;
            var12 = (double)this.field_145850_b.field_73012_v.nextFloat() * var8 + (1.0 - var8) * 0.5;
            var14 = (double)this.field_145850_b.field_73012_v.nextFloat() * var8 + (1.0 - var8) * 0.5;
            var16 = new EntityItem(this.field_145850_b, (double)this.field_145851_c + var10, (double)this.field_145848_d + var12, (double)this.field_145849_e + var14, this.inputslotA.get(i));
            var16.field_145804_b = 10;
            this.field_145850_b.func_72838_d((Entity)var16);
        }
        for (i = 0; i < this.inputslotB.size(); ++i) {
            if (this.inputslotB.get(i) == null) continue;
            var8 = 0.7;
            var10 = (double)this.field_145850_b.field_73012_v.nextFloat() * var8 + (1.0 - var8) * 0.5;
            var12 = (double)this.field_145850_b.field_73012_v.nextFloat() * var8 + (1.0 - var8) * 0.5;
            var14 = (double)this.field_145850_b.field_73012_v.nextFloat() * var8 + (1.0 - var8) * 0.5;
            var16 = new EntityItem(this.field_145850_b, (double)this.field_145851_c + var10, (double)this.field_145848_d + var12, (double)this.field_145849_e + var14, this.inputslotB.get(i));
            var16.field_145804_b = 10;
            this.field_145850_b.func_72838_d((Entity)var16);
        }
        for (i = 0; i < this.outputSlot.size(); ++i) {
            if (this.outputSlot.get(i) == null) continue;
            var8 = 0.7;
            var10 = (double)this.field_145850_b.field_73012_v.nextFloat() * var8 + (1.0 - var8) * 0.5;
            var12 = (double)this.field_145850_b.field_73012_v.nextFloat() * var8 + (1.0 - var8) * 0.5;
            var14 = (double)this.field_145850_b.field_73012_v.nextFloat() * var8 + (1.0 - var8) * 0.5;
            var16 = new EntityItem(this.field_145850_b, (double)this.field_145851_c + var10, (double)this.field_145848_d + var12, (double)this.field_145849_e + var14, this.outputSlot.get(i));
            var16.field_145804_b = 10;
            this.field_145850_b.func_72838_d((Entity)var16);
        }
        return ret;
    }

    @Override
    public void updateEntityServer() {
        EnumQuarryType type;
        TileEntity cAmount2;
        int z;
        int y;
        int x;
        super.updateEntityServer();
        double percent = this.energyconsume;
        boolean isVeinBlock = false;
        if (this.field_145850_b.field_73011_w.getWorldTime() % 200L == 0L) {
            int amount = Util.saturatedCast((double)this.energy) / 20;
            block9: for (int i = 0; i < this.outputSlot.size(); ++i) {
                if (this.outputSlot.get(i) == null) continue;
                for (StackUtil.AdjacentInv inv : StackUtil.getAdjacentInventories((TileEntity)this)) {
                    int cAmount2 = StackUtil.transfer((IInventory)this, (IInventory)inv.inv, (Direction)inv.dir, (int)amount);
                    if (cAmount2 <= 0 || (amount -= cAmount2) > 0) continue;
                    continue block9;
                }
            }
            this.outputSlot.onChanged();
        }
        if (this.field_145850_b.field_73011_w.getWorldTime() % 20L == 0L) {
            this.isAnalyzerInstalled = !this.inputslotB.isEmpty();
            int chunkx = this.field_145850_b.func_72938_d((int)this.field_145851_c, (int)this.field_145849_e).func_76632_l().field_77276_a * 16;
            int chunkz = this.field_145850_b.func_72938_d((int)this.field_145851_c, (int)this.field_145849_e).func_76632_l().field_77275_b * 16;
            if (this.field_145850_b.func_147438_o(chunkx, 0, chunkz) != null && this.field_145850_b.func_147438_o(chunkx, 0, chunkz) instanceof TileEntityVein) {
                isVeinBlock = true;
            }
        }
        if (this.isAnalyzerInstalled && isVeinBlock && this.field_145850_b.func_147438_o(x = this.field_145850_b.func_72938_d((int)this.field_145851_c, (int)this.field_145849_e).func_76632_l().field_77276_a * 16, y = 0, z = this.field_145850_b.func_72938_d((int)this.field_145851_c, (int)this.field_145849_e).func_76632_l().field_77275_b * 16) != null && (cAmount2 = this.field_145850_b.func_147438_o(x, y, z)) instanceof TileEntityVein) {
            TileEntityVein tile = (TileEntityVein)cAmount2;
            if (tile.number > 0) {
                if (this.inputslot.get() != null) {
                    EnumQuarryModules module = IUItem.quarryModules.get(this.inputslot.get().func_77960_j());
                    type = module.type;
                    if (type == EnumQuarryType.SPEED) {
                        percent = (double)this.energyconsume - (double)this.energyconsume * 0.05 * (double)module.efficiency;
                    }
                }
                if (this.energy >= percent && this.outputSlot.canAdd(new ItemStack(IUItem.heavyOre, 1, this.field_145850_b.func_72805_g(x, y, z)))) {
                    this.setActive(true);
                    this.energy -= percent;
                    this.getblock += 1.0;
                    this.outputSlot.add(new ItemStack(IUItem.heavyOre, 1, this.field_145850_b.func_72805_g(x, y, z)));
                    --tile.number;
                    return;
                }
            }
        }
        if (this.isAnalyzerInstalled && !isVeinBlock && !IUConfig.enable_vein_mode_quarry) {
            double col = 1.0;
            int chance2 = 0;
            boolean hasFurnaceModule = false;
            if (this.inputslot.get() != null) {
                EnumQuarryModules module = IUItem.quarryModules.get(this.inputslot.get().func_77960_j());
                type = module.type;
                switch (type) {
                    case SPEED: {
                        percent = (double)this.energyconsume - (double)this.energyconsume * 0.05 * (double)module.efficiency;
                        break;
                    }
                    case DEPTH: {
                        col = module.efficiency * module.efficiency;
                        percent = (double)this.energyconsume * Math.pow(1.1, module.meta - 8);
                        break;
                    }
                    case LUCKY: {
                        chance2 = module.efficiency;
                        break;
                    }
                    case FURNACE: {
                        hasFurnaceModule = true;
                    }
                }
            }
            EnumQuarryModules list_check = null;
            if (this.inputslotA.get() != null) {
                EnumQuarryModules module = IUItem.quarryModules.get(this.inputslotA.get().func_77960_j());
                EnumQuarryType type2 = module.type;
                switch (type2) {
                    case WHITELIST: 
                    case BLACKLIST: {
                        list_check = module;
                    }
                }
            }
            for (double i = 0.0; i < col; i += 1.0) {
                if (this.energy >= percent) {
                    ItemStack itemStack;
                    int num;
                    this.setActive(true);
                    this.energy -= percent;
                    int chance = this.rand.nextInt(100) + 1;
                    this.getblock += 1.0;
                    this.initiate(0);
                    if (chance <= 95) continue;
                    if (this.isInventoryHasNoEmptySlots()) {
                        return;
                    }
                    if (hasFurnaceModule) {
                        List<ItemStack> miningIngotList = IUCore.miningIngotList;
                        num = miningIngotList.size();
                        int chance1 = this.rand.nextInt(num);
                        itemStack = miningIngotList.get(chance1);
                        if (!this.isNotWhitelistedOrBlacklisted(list_check, itemStack)) {
                            if (!this.outputSlot.canAdd(itemStack)) continue;
                            this.outputSlot.add(itemStack);
                            continue;
                        }
                        return;
                    }
                    List<ItemStack> oreStacks = IUCore.oreStacks;
                    num = oreStacks.size();
                    int oreByChance = this.rand.nextInt(num);
                    itemStack = oreStacks.get(oreByChance);
                    if (OreDictionary.getOreName((int)OreDictionary.getOreID((ItemStack)itemStack)).startsWith("gem") || OreDictionary.getOreName((int)OreDictionary.getOreID((ItemStack)itemStack)).startsWith("shard") || itemStack.func_77973_b() == Items.field_151137_ax || itemStack.func_77973_b() == Items.field_151137_ax || itemStack.func_77973_b() == Items.field_151100_aR || itemStack.func_77973_b() == Items.field_151044_h || itemStack.func_77973_b() == Items.field_151114_aO || chance2 < 0) continue;
                    if (!this.isNotWhitelistedOrBlacklisted(list_check, itemStack)) {
                        if (!this.outputSlot.canAdd(itemStack)) continue;
                        this.outputSlot.add(itemStack);
                        continue;
                    }
                    return;
                }
                this.setActive(false);
                this.initiate(2);
            }
        } else {
            this.initiate(2);
            this.setActive(false);
        }
        if (this.field_145850_b.field_73011_w.getWorldTime() % 200L == 0L) {
            this.initiate(2);
        }
    }

    public boolean isNotWhitelistedOrBlacklisted(EnumQuarryModules type, ItemStack stack1) {
        String oreName = OreDictionary.getOreName((int)OreDictionary.getOreID((ItemStack)stack1));
        if (type == null) {
            return false;
        }
        if (type.type == EnumQuarryType.WHITELIST) {
            for (int j = 0; j < 9; ++j) {
                String l = "number_" + j;
                String temp = SomeUtils.nbtGetString(this.inputslotA.get(), l);
                if (!temp.startsWith("ore") && !temp.startsWith("gem") && !temp.startsWith("dust") && !temp.startsWith("shard") || !temp.equals(oreName)) continue;
                return true;
            }
            return false;
        }
        if (type.type == EnumQuarryType.BLACKLIST) {
            for (int j = 0; j < 9; ++j) {
                String l = "number_" + j;
                String temp = SomeUtils.nbtGetString(this.inputslotA.get(), l);
                if (!temp.startsWith("ore") && !temp.startsWith("gem") && !temp.startsWith("dust") && !temp.startsWith("shard") || !temp.equals(oreName)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean isInventoryHasNoEmptySlots() {
        for (int i = 0; i < this.outputSlot.size(); ++i) {
            if (this.outputSlot.get(i) == null) {
                return false;
            }
            if (this.outputSlot.get((int)i).field_77994_a == 64) continue;
            return false;
        }
        return true;
    }

    @Override
    public double injectEnergy(ForgeDirection directionFrom, double amount, double voltage) {
        if (amount == 0.0) {
            return 0.0;
        }
        if (this.energy >= this.maxEnergy) {
            return amount;
        }
        if (this.energy + amount >= this.maxEnergy) {
            double p = this.maxEnergy - this.energy;
            this.energy += p;
            return amount - p;
        }
        this.energy += amount;
        return 0.0;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.progress = nbttagcompound.func_74762_e("progress");
        this.getblock = nbttagcompound.func_74769_h("getblock");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74780_a("getblock", this.getblock);
        nbttagcompound.func_74768_a("progress", this.progress);
    }

    public boolean func_102008_b(int index, ItemStack itemStack, int side) {
        if (Objects.equals(this.func_70301_a(index).func_77973_b(), IUItem.analyzerModule) || Objects.equals(this.func_70301_a(index).func_77973_b(), IUItem.module9)) {
            return false;
        }
        return super.func_102008_b(index, itemStack, side);
    }

    public int func_70302_i_() {
        return super.func_70302_i_();
    }

    public double getEnergy() {
        return this.energy;
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer entityPlayer, boolean isAdmin) {
        return new GUIQuantumQuarry(new ContainerQuantumQuarry<TileEntityBaseQuantumQuarry>(entityPlayer, this));
    }

    public ContainerBase<? extends TileEntityBaseQuantumQuarry> getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerQuantumQuarry<TileEntityBaseQuantumQuarry>(entityPlayer, this);
    }

    @Override
    public void onUnloaded() {
        super.onUnloaded();
        if (IC2.platform.isRendering() && this.audioSource != null) {
            IUCore.audioManager.removeSources((Object)this);
            this.audioSource = null;
        }
    }

    public String getStartSoundFile() {
        return "Machines/quarry.ogg";
    }

    public String getInterruptSoundFile() {
        return "Machines/InterruptOne.ogg";
    }

    public float getWrenchDropRate() {
        return 0.85f;
    }

    private void initiate(int soundEvent) {
        ((NetworkManager)IC2.network.get()).initiateTileEntityEvent((TileEntity)this, soundEvent, true);
    }

    public void onNetworkEvent(int event) {
        if (this.audioSource == null && this.getStartSoundFile() != null) {
            this.audioSource = IUCore.audioManager.createSource((Object)this, this.getStartSoundFile());
        }
        switch (event) {
            case 0: {
                if (this.audioSource == null) break;
                this.audioSource.play();
                break;
            }
            case 1: {
                if (this.audioSource == null) break;
                this.audioSource.stop();
                if (this.getInterruptSoundFile() == null) break;
                IUCore.audioManager.playOnce((Object)this, this.getInterruptSoundFile());
                break;
            }
            case 2: {
                if (this.audioSource == null) break;
                this.audioSource.stop();
            }
        }
    }

    public void onGuiClosed(EntityPlayer arg0) {
    }

    public String func_145825_b() {
        return StatCollector.func_74838_a((String)this.name);
    }
}

