/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.world;

import com.denfop.IUItem;
import com.denfop.block.ore.BlockEndOre;
import com.denfop.block.ore.BlockEndOre1;
import com.denfop.block.ore.BlockNetherOre;
import com.denfop.block.ore.BlockNetherOre1;
import com.denfop.config.IUConfig;
import com.denfop.config.OreConfig;
import com.denfop.utils.IntegrationsHelper;
import com.denfop.world.WorldGenOil;
import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.Arrays;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;

public class OreGenerator
implements IWorldGenerator {
    FluidStack fluidStack = FluidContainerRegistry.getFluidForFilledItem((ItemStack)IUItem.oilCell);
    Fluid fluid = this.fluidStack.getFluid();
    Block block = this.fluid.getBlock();

    public static void init() {
        GameRegistry.registerWorldGenerator((IWorldGenerator)new OreGenerator(), (int)0);
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        switch (world.field_73011_w.field_76574_g) {
            case 1: {
                this.generateEnd(world, random, chunkX * 16, chunkZ * 16);
                break;
            }
            case -1: {
                this.generateNether(world, random, chunkX * 16, chunkZ * 16);
                break;
            }
            case 0: {
                if (random.nextInt(100) + 1 <= 70 || world.func_72807_a(chunkX * 16, chunkZ * 16) != BiomeGenBase.field_76769_d) break;
                for (int i = 0; i < 1; ++i) {
                    int posX = chunkX * 16 + random.nextInt(16) + 8;
                    int posY = random.nextInt(random.nextInt(random.nextInt(112) + 8) + 8) + 60;
                    int posZ = chunkZ * 16 + random.nextInt(16) + 8;
                    if (this.block == null) continue;
                    new WorldGenOil(this.block, this.block, 3).func_76484_a(world, random, posX, posY, posZ);
                }
                break;
            }
        }
        if (Arrays.asList(IUConfig.dim_ids_to_spawn_ore).contains(String.valueOf(world.field_73011_w.field_76574_g))) {
            this.generateSurface(world, random, chunkX * 16, chunkZ * 16);
        }
    }

    private void generateNether(World world, Random random, int x, int y) {
        if (OreConfig.enable_nether_ore_gen) {
            int i;
            for (i = 0; i < BlockNetherOre.getAll().size(); ++i) {
                if (!OreConfig.enable_iridium_ore_gen && i == 4) continue;
                this.addNetherOreSpawn(IUItem.netherOre, i, world, random, x, y, 16, 16, 3 + random.nextInt(2), 9, 20, 120);
            }
            for (i = 0; i < BlockNetherOre1.getAll().size(); ++i) {
                this.addNetherOreSpawn(IUItem.netherOre1, i, world, random, x, y, 16, 16, 3 + random.nextInt(2), 9, 20, 120);
            }
        }
    }

    private void generateSurface(World world, Random random, int x, int y) {
        if (OreConfig.enable_thorium_ore_gen) {
            this.addOreSpawn(IUItem.thoriumOre, world, random, x, y, 16, 16, 3 + random.nextInt(2), 4, 10, 70);
        }
        if (OreConfig.enable_mikhail_ore_gen) {
            this.addOreSpawn(IUItem.ore, 0, world, random, x, y, 16, 16, 3 + random.nextInt(3), 9, 0, 70);
        }
        if (OreConfig.enable_aluminium_ore_gen) {
            this.addOreSpawn(IUItem.ore, 1, world, random, x, y, 16, 16, 3 + random.nextInt(3), 9, 0, 70);
        }
        if (OreConfig.enable_vanady_ore_gen) {
            this.addOreSpawn(IUItem.ore, 2, world, random, x, y, 16, 16, 3 + random.nextInt(3), 9, 0, 70);
        }
        if (OreConfig.enable_tungsten_ore_gen) {
            this.addOreSpawn(IUItem.ore, 3, world, random, x, y, 16, 16, 3 + random.nextInt(3), 9, 0, 70);
        }
        if (OreConfig.enable_cobalt_ore_gen) {
            this.addOreSpawn(IUItem.ore, 6, world, random, x, y, 16, 16, 3 + random.nextInt(3), 9, 0, 70);
        }
        if (OreConfig.enable_magnesium_ore_gen) {
            this.addOreSpawn(IUItem.ore, 7, world, random, x, y, 16, 16, 3 + random.nextInt(3), 9, 0, 70);
        }
        if (OreConfig.enable_nickel_ore_gen && !IntegrationsHelper.isThermalFoundationLoaded) {
            this.addOreSpawn(IUItem.ore, 8, world, random, x, y, 16, 16, 3 + random.nextInt(3), 9, 0, 70);
        }
        if (OreConfig.enable_platinum_ore_gen && !IntegrationsHelper.isThermalFoundationLoaded) {
            this.addOreSpawn(IUItem.ore, 9, world, random, x, y, 16, 16, 3 + random.nextInt(3), 9, 0, 70);
        }
        if (OreConfig.enable_titanium_ore_gen) {
            this.addOreSpawn(IUItem.ore, 10, world, random, x, y, 16, 16, 3 + random.nextInt(3), 9, 0, 70);
        }
        if (OreConfig.enable_chromium_ore_gen) {
            this.addOreSpawn(IUItem.ore, 11, world, random, x, y, 16, 16, 3 + random.nextInt(3), 9, 0, 70);
        }
        if (OreConfig.enable_spinel_ore_gen) {
            this.addOreSpawn(IUItem.ore, 12, world, random, x, y, 16, 16, 3 + random.nextInt(3), 9, 0, 70);
        }
        if (OreConfig.enable_silver_ore_gen && !IntegrationsHelper.isThermalFoundationLoaded) {
            this.addOreSpawn(IUItem.ore, 14, world, random, x, y, 16, 16, 3 + random.nextInt(3), 9, 0, 70);
        }
        if (OreConfig.enable_zinc_ore_gen) {
            this.addOreSpawn(IUItem.ore, 15, world, random, x, y, 16, 16, 3 + random.nextInt(3), 9, 0, 70);
        }
        if (OreConfig.enable_manganese_ore_gen) {
            this.addOreSpawn(IUItem.ore1, 0, world, random, x, y, 16, 16, 3 + random.nextInt(3), 9, 0, 70);
        }
        if (OreConfig.enable_iridium_ore_gen) {
            this.addOreSpawn(IUItem.ore1, 1, world, random, x, y, 16, 16, 3 + random.nextInt(3), 14, 0, 70);
        }
        if (OreConfig.enable_germanium_ore_gen) {
            this.addOreSpawn(IUItem.ore1, 2, world, random, x, y, 16, 16, 3 + random.nextInt(3), 9, 0, 70);
        }
        if (OreConfig.enable_magnetite_ore_gen) {
            this.addOreSpawn(IUItem.heavyOre, 0, world, random, x, y, 16, 16, 3 + random.nextInt(2), 9, 10, 70);
        }
        if (OreConfig.enable_calaverite_ore_gen) {
            this.addOreSpawn(IUItem.heavyOre, 1, world, random, x, y, 16, 16, 3 + random.nextInt(2), 9, 10, 70);
        }
        if (OreConfig.enable_galena_ore_gen) {
            this.addOreSpawn(IUItem.heavyOre, 2, world, random, x, y, 16, 16, 3 + random.nextInt(2), 9, 10, 70);
        }
        if (OreConfig.enable_nickelite_ore_gen) {
            this.addOreSpawn(IUItem.heavyOre, 3, world, random, x, y, 16, 16, 3 + random.nextInt(2), 9, 10, 70);
        }
        if (OreConfig.enable_pyrite_ore_gen) {
            this.addOreSpawn(IUItem.heavyOre, 4, world, random, x, y, 16, 16, 3 + random.nextInt(2), 9, 10, 70);
        }
        if (OreConfig.enable_quartzite_ore_gen) {
            this.addOreSpawn(IUItem.heavyOre, 5, world, random, x, y, 16, 16, 5 + random.nextInt(2), 11, 10, 70);
        }
        if (OreConfig.enable_uranite_ore_gen) {
            this.addOreSpawn(IUItem.heavyOre, 6, world, random, x, y, 16, 16, 3 + random.nextInt(2), 7, 10, 70);
        }
        if (OreConfig.enable_azurite_ore_gen) {
            this.addOreSpawn(IUItem.heavyOre, 7, world, random, x, y, 16, 16, 3 + random.nextInt(2), 9, 10, 70);
        }
        if (OreConfig.enable_rhodonite_ore_gen) {
            this.addOreSpawn(IUItem.heavyOre, 8, world, random, x, y, 16, 16, 3 + random.nextInt(2), 9, 10, 70);
        }
        if (OreConfig.enable_alfildit_ore_gen) {
            this.addOreSpawn(IUItem.heavyOre, 9, world, random, x, y, 16, 16, 3 + random.nextInt(2), 9, 10, 70);
        }
        if (OreConfig.enable_euxenite_ore_gen) {
            this.addOreSpawn(IUItem.heavyOre, 10, world, random, x, y, 16, 16, 3 + random.nextInt(2), 9, 10, 70);
        }
        if (OreConfig.enable_smithsonite_ore_gen) {
            this.addOreSpawn(IUItem.heavyOre, 11, world, random, x, y, 16, 16, 3 + random.nextInt(2), 9, 10, 70);
        }
        if (OreConfig.enable_americium_ore_gen) {
            this.addOreSpawn(IUItem.radiationOre, 0, world, random, x, y, 16, 16, 2 + random.nextInt(2), 11, 10, 70);
        }
        if (OreConfig.enable_neptunium_ore_gen) {
            this.addOreSpawn(IUItem.radiationOre, 1, world, random, x, y, 16, 16, 2 + random.nextInt(2), 12, 10, 70);
        }
        if (OreConfig.enable_curium_ore_gen) {
            this.addOreSpawn(IUItem.radiationOre, 2, world, random, x, y, 16, 16, 3 + random.nextInt(2), 12, 10, 70);
        }
        if (OreConfig.enable_ruby_ore_gen) {
            this.addOreSpawn(IUItem.preciousOre, 0, world, random, x, y, 16, 16, 3 + random.nextInt(2), 6, 10, 70);
        }
        if (OreConfig.enable_sapphire_ore_gen) {
            this.addOreSpawn(IUItem.preciousOre, 1, world, random, x, y, 16, 16, 3 + random.nextInt(2), 6, 10, 70);
        }
        if (OreConfig.enable_topaz_ore_gen) {
            this.addOreSpawn(IUItem.preciousOre, 2, world, random, x, y, 16, 16, 3 + random.nextInt(2), 6, 10, 70);
        }
    }

    private void generateEnd(World world, Random random, int x, int y) {
        if (OreConfig.enable_end_ore_gen) {
            int i;
            for (i = 0; i < BlockEndOre.getAll().size(); ++i) {
                if (!OreConfig.enable_iridium_ore_gen && i == 4) continue;
                this.addEndOreSpawn(IUItem.endOre, i, world, random, x, y, 16, 16, 3 + random.nextInt(2), 12, 0, 128);
            }
            for (i = 0; i < BlockEndOre1.getAll().size(); ++i) {
                this.addEndOreSpawn(IUItem.endOre1, i, world, random, x, y, 16, 16, 3 + random.nextInt(2), 12, 0, 128);
            }
        }
    }

    public void addOreSpawn(Block block, World world, Random random, int blockXPos, int blockZPos, int maxX, int maxZ, int maxVeinSize, int chancesToSpawn, int minY, int maxY) {
        for (int i = 0; i < chancesToSpawn; ++i) {
            int posX = blockXPos + random.nextInt(maxX);
            int posY = minY + random.nextInt(maxY - minY);
            int posZ = blockZPos + random.nextInt(maxZ);
            new WorldGenMinable(block, 0, maxVeinSize, Blocks.field_150348_b).func_76484_a(world, random, posX, posY, posZ);
        }
    }

    public void addOreSpawn(Block block, int meta, World world, Random random, int blockXPos, int blockZPos, int maxX, int maxZ, int maxVeinSize, int chancesToSpawn, int minY, int maxY) {
        for (int i = 0; i < chancesToSpawn; ++i) {
            int posX = blockXPos + random.nextInt(maxX);
            int posY = minY + random.nextInt(maxY - minY);
            int posZ = blockZPos + random.nextInt(maxZ);
            new WorldGenMinable(block, meta, maxVeinSize, Blocks.field_150348_b).func_76484_a(world, random, posX, posY, posZ);
        }
    }

    public void addNetherOreSpawn(Block block, int meta, World world, Random random, int blockXPos, int blockZPos, int maxX, int maxZ, int maxVeinSize, int chancesToSpawn, int minY, int maxY) {
        for (int i = 0; i < chancesToSpawn; ++i) {
            int posX = blockXPos + random.nextInt(maxX);
            int posY = minY + random.nextInt(maxY - minY);
            int posZ = blockZPos + random.nextInt(maxZ);
            new WorldGenMinable(block, meta, maxVeinSize, Blocks.field_150424_aL).func_76484_a(world, random, posX, posY, posZ);
        }
    }

    public void addEndOreSpawn(Block block, int meta, World world, Random random, int blockXPos, int blockZPos, int maxX, int maxZ, int maxVeinSize, int chancesToSpawn, int minY, int maxY) {
        for (int i = 0; i < chancesToSpawn; ++i) {
            int posX = blockXPos + random.nextInt(maxX);
            int posY = minY + random.nextInt(maxY - minY);
            int posZ = blockZPos + random.nextInt(maxZ);
            new WorldGenMinable(block, meta, maxVeinSize, Blocks.field_150377_bs).func_76484_a(world, random, posX, posY, posZ);
        }
    }
}

