/*
 * Decompiled with CFR 0.152.
 */
package com.gamerforea.iu;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Facing;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.world.ChunkEvent;

public final class TileNeighborsManager {
    private static final Map<Key, Set<TileNeighborsManager>> activeCheckers;
    private WeakReference<TileEntity>[] neighbors;
    private final TileEntity te;
    private boolean neededUpdate = true;
    private boolean init;

    public TileNeighborsManager(@Nonnull TileEntity tile) {
        this.te = tile;
    }

    @Nullable
    public TileEntity getNeighbor(@Nonnull ForgeDirection direction) {
        return this.te.func_145831_w().func_147438_o(this.te.field_145851_c + direction.offsetX, this.te.field_145848_d + direction.offsetY, this.te.field_145849_e + direction.offsetZ);
    }

    public void markDirty() {
        this.neededUpdate = true;
    }

    static {
        MinecraftForge.EVENT_BUS.register((Object)new Handler());
        activeCheckers = new HashMap<Key, Set<TileNeighborsManager>>();
    }

    public static final class Handler {
        private Handler() {
        }

        @SubscribeEvent
        public void onChunkLoad(ChunkEvent.Load event) {
            Chunk chunk = event.getChunk();
            for (int i = 2; i < 6; ++i) {
                Set checkers = (Set)activeCheckers.get(new Key(chunk.field_76637_e.field_73011_w.field_76574_g, chunk.field_76635_g + Facing.field_71586_b[i], chunk.field_76647_h + Facing.field_71585_d[i]));
                if (checkers == null) continue;
                for (TileNeighborsManager manager : checkers) {
                    manager.neededUpdate = true;
                }
            }
        }

        @SubscribeEvent
        public void onChunkUnload(ChunkEvent.Unload event) {
            Chunk chunk = event.getChunk();
            for (int i = 2; i < 6; ++i) {
                Set checkers = (Set)activeCheckers.get(new Key(chunk.field_76637_e.field_73011_w.field_76574_g, chunk.field_76635_g + Facing.field_71586_b[i], chunk.field_76647_h + Facing.field_71585_d[i]));
                if (checkers == null) continue;
                for (TileNeighborsManager manager : checkers) {
                    manager.neededUpdate = true;
                }
            }
            activeCheckers.remove(new Key(chunk.field_76637_e.field_73011_w.field_76574_g, chunk.field_76635_g, chunk.field_76647_h));
        }
    }

    private static final class Key {
        final int dim;
        final int chunkX;
        final int chunkZ;

        private Key(int dim, int chunkX, int chunkZ) {
            this.dim = dim;
            this.chunkX = chunkX;
            this.chunkZ = chunkZ;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (this == o) {
                return true;
            }
            Key key = (Key)o;
            return this.dim == key.dim && this.chunkX == key.chunkX && this.chunkZ == key.chunkZ;
        }

        public int hashCode() {
            int i = 1664525 * this.chunkX + 1013904223;
            int j = 1664525 * (this.chunkZ ^ 0xDEADBEEF) + 1013904223;
            return i ^ j;
        }
    }
}

