/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.log;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import journeymap.client.Constants;
import journeymap.client.JourneymapClient;
import journeymap.client.log.ChatLog;

public class LogFormatter {
    public static final String LINEBREAK = System.getProperty("line.separator");
    private static int OutOfMemoryWarnings = 0;
    private static int LinkageErrorWarnings = 0;

    public static String toString(Throwable thrown) {
        LogFormatter.checkErrors(thrown);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        thrown.printStackTrace(ps);
        ps.flush();
        return baos.toString();
    }

    private static void checkErrors(Throwable thrown) {
        int maxRecursion = 5;
        if (thrown != null && OutOfMemoryWarnings < 5 && LinkageErrorWarnings < 5) {
            while (thrown != null && maxRecursion > 0) {
                if (thrown instanceof StackOverflowError) {
                    return;
                }
                if (thrown instanceof OutOfMemoryError) {
                    ++OutOfMemoryWarnings;
                    ChatLog.announceI18N("jm.common.memory_warning", thrown.toString());
                    thrown.printStackTrace(System.err);
                    break;
                }
                if (thrown instanceof LinkageError) {
                    ++LinkageErrorWarnings;
                    String error = Constants.getString("jm.error.compatability", JourneymapClient.MOD_NAME, "10.13.4.1614");
                    thrown.printStackTrace(System.err);
                    thrown.printStackTrace(System.err);
                    break;
                }
                if (!(thrown instanceof Exception)) continue;
                thrown = ((Exception)thrown).getCause();
                --maxRecursion;
            }
        }
    }

    public static String toPartialString(Throwable t) {
        StringBuilder sb = new StringBuilder(t.toString());
        StackTraceElement caller = Thread.currentThread().getStackTrace()[2];
        for (StackTraceElement ste : t.getStackTrace()) {
            sb.append("\n\tat " + ste);
            if (ste.getClassName().equals(caller.getClassName()) && ste.getMethodName().equals(caller.getMethodName())) break;
        }
        return sb.toString();
    }
}

