/*
 * Decompiled with CFR 0.152.
 */
package journeymap.shadow.org.eclipse.jetty.client.http;

import java.io.IOException;
import java.util.Map;
import journeymap.shadow.org.eclipse.jetty.client.AbstractConnectorHttpClientTransport;
import journeymap.shadow.org.eclipse.jetty.client.DuplexConnectionPool;
import journeymap.shadow.org.eclipse.jetty.client.HttpDestination;
import journeymap.shadow.org.eclipse.jetty.client.Origin;
import journeymap.shadow.org.eclipse.jetty.client.api.Connection;
import journeymap.shadow.org.eclipse.jetty.client.http.HttpConnectionOverHTTP;
import journeymap.shadow.org.eclipse.jetty.client.http.HttpDestinationOverHTTP;
import journeymap.shadow.org.eclipse.jetty.io.EndPoint;
import journeymap.shadow.org.eclipse.jetty.util.Callback;
import journeymap.shadow.org.eclipse.jetty.util.ProcessorUtils;
import journeymap.shadow.org.eclipse.jetty.util.Promise;
import journeymap.shadow.org.eclipse.jetty.util.annotation.ManagedAttribute;
import journeymap.shadow.org.eclipse.jetty.util.annotation.ManagedObject;

@ManagedObject(value="The HTTP/1.1 client transport")
public class HttpClientTransportOverHTTP
extends AbstractConnectorHttpClientTransport {
    private int headerCacheSize = 1024;

    public HttpClientTransportOverHTTP() {
        this(Math.max(1, ProcessorUtils.availableProcessors() / 2));
    }

    public HttpClientTransportOverHTTP(int selectors) {
        super(selectors);
        this.setConnectionPoolFactory(destination -> new DuplexConnectionPool(destination, this.getHttpClient().getMaxConnectionsPerDestination(), (Callback)destination));
    }

    @Override
    public HttpDestination newHttpDestination(Origin origin) {
        return new HttpDestinationOverHTTP(this.getHttpClient(), origin);
    }

    @Override
    public journeymap.shadow.org.eclipse.jetty.io.Connection newConnection(EndPoint endPoint, Map<String, Object> context) throws IOException {
        HttpDestination destination = (HttpDestination)context.get("http.destination");
        Promise promise = (Promise)context.get("http.connection.promise");
        HttpConnectionOverHTTP connection = this.newHttpConnection(endPoint, destination, promise);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Created {}", connection);
        }
        return this.customize(connection, context);
    }

    protected HttpConnectionOverHTTP newHttpConnection(EndPoint endPoint, HttpDestination destination, Promise<Connection> promise) {
        return new HttpConnectionOverHTTP(endPoint, destination, promise);
    }

    @ManagedAttribute(value="The maximum allowed size in bytes for an HTTP header field cache")
    public int getHeaderCacheSize() {
        return this.headerCacheSize;
    }

    public void setHeaderCacheSize(int headerCacheSize) {
        this.headerCacheSize = headerCacheSize;
    }
}

