/*
 * Decompiled with CFR 0.152.
 */
package by.fxg.mwicontent.ae2.blocks;

import appeng.block.crafting.BlockCraftingUnit;
import appeng.tile.crafting.TileCraftingTile;
import appeng.util.Platform;
import by.fxg.mwintegration.common.ContentManager;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import ru.justagod.cutter.invoke.Invoke;

public class BlockCraftingCPU
extends BlockCraftingUnit {
    protected static final int FLAG_FORMED = 8;
    private final int subtypes;
    private final int subtypeOffset;
    private final String blockName;
    private final String[] unlocalizedNames;
    @SideOnly(value=Side.CLIENT)
    private IIcon[] blockTextures;

    public BlockCraftingCPU(String name, int subtypes, int subtypeOffset, Class<? extends TileCraftingTile> tileClass) {
        this.hasSubtypes = true;
        this.func_149663_c(name);
        this.func_149711_c(2.2f);
        this.func_149752_b(50.0f);
        this.setTileEntity(tileClass);
        this.func_149647_a(ContentManager.tabMWIntegration);
        this.blockName = name;
        this.subtypes = subtypes;
        this.subtypeOffset = subtypeOffset;
        this.unlocalizedNames = new String[subtypes];
        for (int subtype = 0; subtype < subtypes; ++subtype) {
            this.unlocalizedNames[subtype] = "tile." + name + "Mk" + (subtype + subtypeOffset);
        }
        if (subtypes > 8) {
            throw new RuntimeException("Idiot! Subtype can't be over 8 because it will overdrive getIcon()");
        }
    }

    public String[] getUnlocalizedNames() {
        return this.unlocalizedNames;
    }

    public boolean onActivated(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        if (Platform.isClient()) {
            return true;
        }
        return Invoke.serverValue(() -> false);
    }

    @SideOnly(value=Side.CLIENT)
    public void getCheckedSubBlocks(Item item, CreativeTabs tabs, List<ItemStack> stacks) {
        for (int meta = 0; meta < this.subtypes; ++meta) {
            stacks.add(new ItemStack((Block)this, 1, meta));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister register) {
        this.blockTextures = new IIcon[8 + this.subtypes];
        for (int idx = 0; idx < this.subtypes; ++idx) {
            this.blockTextures[idx] = register.func_94245_a("mwi:ae2/" + this.blockName + "Mk" + (idx + this.subtypeOffset));
            this.blockTextures[idx + 8] = register.func_94245_a("mwi:ae2/" + this.blockName + "Mk" + (idx + this.subtypeOffset) + "Frame");
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int dir, int meta) {
        return meta > -1 && meta < this.blockTextures.length ? this.blockTextures[meta] : this.blockTextures[0];
    }

    public int func_149692_a(int meta) {
        int rounded = meta & 3;
        return rounded > -1 && rounded < this.subtypes ? rounded : 0;
    }

    public int func_149643_k(World w, int x, int y, int z) {
        int rounded = w.func_72805_g(x, y, z) & 3;
        return rounded > -1 && rounded < this.subtypes ? rounded : 0;
    }
}

