/*
 * Decompiled with CFR 0.152.
 */
package by.fxg.mwicontent.ae2.blocks.parts;

import appeng.api.parts.IBoxProvider;
import appeng.api.parts.IPartRenderHelper;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.ITerminalHost;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.util.IConfigManager;
import appeng.apiext.gui.IGuiCraftConfirmGuiBridgeProvider;
import appeng.client.texture.CableBusTextures;
import appeng.core.sync.GuiBridge;
import appeng.me.GridAccessException;
import appeng.parts.reporting.AbstractPartDisplay;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.tile.inventory.IAEAppEngInventory;
import appeng.tile.inventory.InvOperation;
import appeng.util.ConfigManager;
import appeng.util.IConfigManagerHost;
import appeng.util.Platform;
import by.fxg.mwicontent.ae2.blocks.parts.EnumPartTexture;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.Vec3;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class PartAbstractTerminal
extends AbstractPartDisplay
implements ITerminalHost,
IConfigManagerHost,
IAEAppEngInventory,
IGuiCraftConfirmGuiBridgeProvider {
    protected final ConfigManager configManager = new ConfigManager((IConfigManagerHost)this);
    protected final AppEngInternalInventory inventoryViewCells = new AppEngInternalInventory((IAEAppEngInventory)this, 5);
    protected final ItemStack stack;
    protected final Item stackItem;

    public PartAbstractTerminal(ItemStack stack) {
        super(stack);
        this.stack = stack;
        this.stackItem = stack.func_77973_b();
    }

    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        this.configManager.writeToNBT(data);
        this.inventoryViewCells.writeToNBT(data, "mwiivc");
    }

    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.configManager.readFromNBT(data);
        this.inventoryViewCells.readFromNBT(data, "mwiivc");
    }

    public void getDrops(List<ItemStack> drops, boolean wrenched) {
        super.getDrops(drops, wrenched);
        for (ItemStack stack : this.inventoryViewCells) {
            if (stack == null) continue;
            drops.add(stack);
        }
    }

    public boolean onPartActivate(EntityPlayer player, Vec3 pos) {
        if (!super.onPartActivate(player, pos) && !player.func_70093_af()) {
            if (Platform.isClient()) {
                return true;
            }
            Platform.openGUI((EntityPlayer)player, (TileEntity)this.getHost().getTile(), (ForgeDirection)this.getSide(), (GuiBridge)this.getGuiBridge(player));
            return true;
        }
        return false;
    }

    protected GuiBridge getGuiBridge(EntityPlayer player) {
        return GuiBridge.GUI_ME;
    }

    public IConfigManager getConfigManager() {
        return this.configManager;
    }

    public void updateSetting(IConfigManager manager, Enum settingName, Enum newValue) {
    }

    public void onChangeInventory(IInventory inv, int slot, InvOperation mc, ItemStack removedStack, ItemStack newStack) {
        this.getHost().markForSave();
    }

    public IMEMonitor<IAEItemStack> getItemInventory() {
        try {
            return this.getProxy().getStorage().getItemInventory();
        }
        catch (GridAccessException gridAccessException) {
            return null;
        }
    }

    public IMEMonitor<IAEFluidStack> getFluidInventory() {
        try {
            return this.getProxy().getStorage().getFluidInventory();
        }
        catch (GridAccessException gridAccessException) {
            return null;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void renderInventory(IPartRenderHelper helper, RenderBlocks renderer) {
        IIcon sideTexture = CableBusTextures.PartMonitorSides.getIcon();
        IIcon backTexture = CableBusTextures.PartMonitorBack.getIcon();
        helper.setBounds(2.0f, 2.0f, 14.0f, 14.0f, 14.0f, 16.0f);
        helper.setTexture(sideTexture, sideTexture, backTexture, EnumPartTexture.Background.icon, sideTexture, sideTexture);
        helper.renderInventoryBox(renderer);
        helper.setInvColor(this.getColor().whiteVariant);
        helper.renderInventoryFace(this.getTextureBright().icon, ForgeDirection.SOUTH, renderer);
        helper.setInvColor(this.getColor().mediumVariant);
        helper.renderInventoryFace(this.getTextureDark().icon, ForgeDirection.SOUTH, renderer);
        helper.setInvColor(this.getColor().blackVariant);
        helper.renderInventoryFace(this.getTextureColored().icon, ForgeDirection.SOUTH, renderer);
        helper.setBounds(4.0f, 4.0f, 13.0f, 12.0f, 12.0f, 14.0f);
        helper.renderInventoryBox(renderer);
    }

    @SideOnly(value=Side.CLIENT)
    public void renderStatic(int x, int y, int z, IPartRenderHelper helper, RenderBlocks renderer) {
        Tessellator tessellator = Tessellator.field_78398_a;
        IIcon sideTexture = CableBusTextures.PartMonitorSides.getIcon();
        IIcon backTexture = CableBusTextures.PartMonitorBack.getIcon();
        IIcon sideStatusTexture = CableBusTextures.PartMonitorSidesStatus.getIcon();
        IIcon sideStatusLightTexture = CableBusTextures.PartMonitorSidesStatusLights.getIcon();
        this.setRenderCache(helper.useSimplifiedRendering(x, y, z, (IBoxProvider)this, this.getRenderCache()));
        helper.setTexture(sideTexture, sideTexture, backTexture, EnumPartTexture.Background.icon, sideTexture, sideTexture);
        helper.setBounds(2.0f, 2.0f, 14.0f, 14.0f, 14.0f, 16.0f);
        helper.renderBlock(x, y, z, renderer);
        if (this.getLightLevel() > 0) {
            int l = 13;
            tessellator.func_78380_c(0xD000D0);
        }
        byte by = this.getSpin();
        renderer.field_147873_r = by;
        renderer.field_147867_u = by;
        renderer.field_147871_s = by;
        renderer.field_147869_t = by;
        renderer.field_147875_q = by;
        renderer.field_147865_v = by;
        tessellator.func_78378_d(this.getColor().whiteVariant);
        helper.renderFace(x, y, z, this.getTextureBright().icon, ForgeDirection.SOUTH, renderer);
        tessellator.func_78378_d(this.getColor().mediumVariant);
        helper.renderFace(x, y, z, this.getTextureDark().icon, ForgeDirection.SOUTH, renderer);
        tessellator.func_78378_d(this.getColor().blackVariant);
        helper.renderFace(x, y, z, this.getTextureColored().icon, ForgeDirection.SOUTH, renderer);
        renderer.field_147873_r = 0;
        renderer.field_147867_u = 0;
        renderer.field_147871_s = 0;
        renderer.field_147869_t = 0;
        renderer.field_147875_q = 0;
        renderer.field_147865_v = 0;
        helper.setTexture(sideStatusTexture, sideStatusTexture, backTexture, this.getItemStack().func_77954_c(), sideStatusTexture, sideStatusTexture);
        helper.setBounds(4.0f, 4.0f, 13.0f, 12.0f, 12.0f, 14.0f);
        helper.renderBlock(x, y, z, renderer);
        int clientFlags = this.getClientFlags();
        if ((clientFlags & 0x14) == 20) {
            int l = 14;
            tessellator.func_78380_c(0xE000E0);
            tessellator.func_78378_d(this.getColor().blackVariant);
        } else if ((clientFlags & 4) == 4) {
            int l = 9;
            tessellator.func_78380_c(0x900090);
            tessellator.func_78378_d(this.getColor().whiteVariant);
        } else {
            tessellator.func_78380_c(0);
            tessellator.func_78378_d(0);
        }
        helper.renderFace(x, y, z, sideStatusLightTexture, ForgeDirection.EAST, renderer);
        helper.renderFace(x, y, z, sideStatusLightTexture, ForgeDirection.WEST, renderer);
        helper.renderFace(x, y, z, sideStatusLightTexture, ForgeDirection.UP, renderer);
        helper.renderFace(x, y, z, sideStatusLightTexture, ForgeDirection.DOWN, renderer);
    }

    public abstract EnumPartTexture getTextureBright();

    public abstract EnumPartTexture getTextureDark();

    public abstract EnumPartTexture getTextureColored();

    public final CableBusTextures getFrontBright() {
        return null;
    }

    public final CableBusTextures getFrontColored() {
        return null;
    }

    public final CableBusTextures getFrontDark() {
        return null;
    }
}

