/*
 * Decompiled with CFR 0.152.
 */
package by.fxg.mwicontent.ae2.blocks.parts;

import appeng.api.implementations.ICraftingPatternItem;
import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.storage.data.IAEItemStack;
import appeng.core.sync.GuiBridge;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.tile.inventory.IAEAppEngInventory;
import appeng.tile.inventory.InvOperation;
import by.fxg.mwicontent.ae2.ContentAE2;
import by.fxg.mwicontent.ae2.blocks.parts.EnumPartTexture;
import by.fxg.mwicontent.ae2.blocks.parts.PartAbstractTerminal;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;

public class PartPatternTerminalExtCrafting
extends PartAbstractTerminal {
    private final AppEngInternalInventory craftingGrid = new AppEngInternalInventory((IAEAppEngInventory)this, 81);
    private final AppEngInternalInventory craftingGridOutput = new AppEngInternalInventory((IAEAppEngInventory)this, 1);
    private final AppEngInternalInventory inventoryPatterns = new AppEngInternalInventory((IAEAppEngInventory)this, 2);
    private boolean canSubstitute = false;

    public PartPatternTerminalExtCrafting(ItemStack stack) {
        super(stack);
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74757_a("mwis", this.canSubstitute);
        this.craftingGrid.writeToNBT(data, "mwicg");
        this.craftingGridOutput.writeToNBT(data, "mwicgo");
        this.inventoryPatterns.writeToNBT(data, "mwiip");
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.setCanSubstitute(data.func_74767_n("mwis"));
        this.craftingGrid.readFromNBT(data, "mwicg");
        this.craftingGridOutput.readFromNBT(data, "mwicgo");
        this.inventoryPatterns.readFromNBT(data, "mwiip");
    }

    @Override
    public void getDrops(List<ItemStack> drops, boolean wrenched) {
        super.getDrops(drops, wrenched);
        for (ItemStack stack : this.inventoryPatterns) {
            if (stack == null) continue;
            drops.add(stack);
        }
    }

    @Override
    public void onChangeInventory(IInventory inv, int slot, InvOperation mc, ItemStack removedStack, ItemStack newStack) {
        if (inv == this.inventoryPatterns && slot == 1) {
            ICraftingPatternItem pattern;
            ICraftingPatternDetails details;
            ItemStack is = this.inventoryPatterns.func_70301_a(1);
            if (is != null && is.func_77973_b() instanceof ICraftingPatternItem && (details = (pattern = (ICraftingPatternItem)is.func_77973_b()).getPatternForItem(is, this.getHost().getTile().func_145831_w())) != null) {
                IAEItemStack item;
                int idx;
                this.setCanSubstitute(details.canSubstitute());
                for (idx = 0; idx < this.craftingGrid.func_70302_i_() && idx < details.getInputs().length; ++idx) {
                    item = details.getInputs()[idx];
                    this.craftingGrid.func_70299_a(idx, item == null ? null : item.getItemStack());
                }
                for (idx = 0; idx < this.craftingGridOutput.func_70302_i_() && idx < details.getOutputs().length; ++idx) {
                    item = details.getOutputs()[idx];
                    this.craftingGridOutput.func_70299_a(idx, item == null ? null : item.getItemStack());
                }
            }
        } else if (inv == this.craftingGrid) {
            for (int idx = 0; idx < this.craftingGrid.func_70302_i_(); ++idx) {
                ItemStack is = this.craftingGrid.func_70301_a(idx);
                if (is == null) continue;
                is.field_77994_a = 1;
            }
        }
        this.getHost().markForSave();
    }

    @Override
    public GuiBridge getGuiBridge(EntityPlayer player) {
        int x = (int)player.field_70165_t;
        int y = (int)player.field_70163_u;
        int z = (int)player.field_70161_v;
        if (this.getHost().getTile() != null) {
            TileEntity tile = this.getTile();
            x = tile.field_145851_c;
            y = tile.field_145848_d;
            z = tile.field_145849_e;
        }
        if (ContentAE2.gbPatternTerminalExtCrafting.hasPermissions(this.getHost().getTile(), x, y, z, this.getSide(), player)) {
            return ContentAE2.gbPatternTerminalExtCrafting;
        }
        return GuiBridge.GUI_ME;
    }

    public GuiBridge getGuiBridge() {
        return ContentAE2.gbPatternTerminalExtCrafting;
    }

    public boolean isCanSubstitute() {
        return this.canSubstitute;
    }

    public void setCanSubstitute(boolean canSubstitute) {
        this.canSubstitute = canSubstitute;
    }

    public IInventory getInventoryByName(String name) {
        switch (name) {
            case "crafting": {
                return this.craftingGrid;
            }
            case "output": {
                return this.craftingGridOutput;
            }
            case "pattern": {
                return this.inventoryPatterns;
            }
        }
        return super.getInventoryByName(name);
    }

    @Override
    public EnumPartTexture getTextureBright() {
        return EnumPartTexture.PatTerm_ExtCrafting_Bright;
    }

    @Override
    public EnumPartTexture getTextureDark() {
        return EnumPartTexture.PatTerm_ExtCrafting_Dark;
    }

    @Override
    public EnumPartTexture getTextureColored() {
        return EnumPartTexture.PatTerm_ExtCrafting_Colored;
    }
}

