/*
 * Decompiled with CFR 0.152.
 */
package by.fxg.mwicontent.ae2.blocks.parts;

import appeng.api.implementations.ICraftingPatternItem;
import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.storage.data.IAEItemStack;
import appeng.core.sync.GuiBridge;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.tile.inventory.IAEAppEngInventory;
import appeng.tile.inventory.InvOperation;
import by.fxg.mwicontent.ae2.ContentAE2;
import by.fxg.mwicontent.ae2.blocks.parts.EnumPartTexture;
import by.fxg.mwicontent.ae2.blocks.parts.PartAbstractTerminal;
import by.fxg.mwicontent.ae2.util.PatternDetailsMatter;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;

public class PartPatternTerminalReplication
extends PartAbstractTerminal {
    private final AppEngInternalInventory craftingGrid = new AppEngInternalInventory((IAEAppEngInventory)this, 1);
    private final AppEngInternalInventory inventoryPatterns = new AppEngInternalInventory((IAEAppEngInventory)this, 2);

    public PartPatternTerminalReplication(ItemStack stack) {
        super(stack);
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        this.craftingGrid.writeToNBT(data, "mwicg");
        this.inventoryPatterns.writeToNBT(data, "mwiip");
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.craftingGrid.readFromNBT(data, "mwicg");
        this.inventoryPatterns.readFromNBT(data, "mwiip");
    }

    @Override
    public void getDrops(List<ItemStack> drops, boolean wrenched) {
        super.getDrops(drops, wrenched);
        for (ItemStack stack : this.inventoryPatterns) {
            if (stack == null) continue;
            drops.add(stack);
        }
    }

    @Override
    public void onChangeInventory(IInventory inv, int slot, InvOperation mc, ItemStack removedStack, ItemStack newStack) {
        ICraftingPatternItem pattern;
        ICraftingPatternDetails patternDetails;
        ItemStack is;
        if (inv == this.inventoryPatterns && slot == 1 && (is = this.inventoryPatterns.func_70301_a(1)) != null && is.func_77973_b() instanceof ICraftingPatternItem && (patternDetails = (pattern = (ICraftingPatternItem)is.func_77973_b()).getPatternForItem(is, this.getHost().getTile().func_145831_w())) instanceof PatternDetailsMatter) {
            for (int idx = 0; idx < this.craftingGrid.func_70302_i_() && idx < patternDetails.getOutputs().length; ++idx) {
                IAEItemStack item = patternDetails.getOutputs()[idx];
                this.craftingGrid.func_70299_a(idx, item == null ? null : item.getItemStack());
                this.craftingGrid.markDirty(idx);
            }
        }
        this.getHost().markForSave();
    }

    @Override
    public GuiBridge getGuiBridge(EntityPlayer player) {
        int x = (int)player.field_70165_t;
        int y = (int)player.field_70163_u;
        int z = (int)player.field_70161_v;
        if (this.getHost().getTile() != null) {
            TileEntity tile = this.getTile();
            x = tile.field_145851_c;
            y = tile.field_145848_d;
            z = tile.field_145849_e;
        }
        if (ContentAE2.gbPatternTerminalReplication.hasPermissions(this.getHost().getTile(), x, y, z, this.getSide(), player)) {
            return ContentAE2.gbPatternTerminalReplication;
        }
        return GuiBridge.GUI_ME;
    }

    public GuiBridge getGuiBridge() {
        return ContentAE2.gbPatternTerminalReplication;
    }

    public IInventory getInventoryByName(String name) {
        switch (name) {
            case "crafting": {
                return this.craftingGrid;
            }
            case "pattern": {
                return this.inventoryPatterns;
            }
        }
        return super.getInventoryByName(name);
    }

    @Override
    public EnumPartTexture getTextureBright() {
        return EnumPartTexture.PatTerm_Matter_Bright;
    }

    @Override
    public EnumPartTexture getTextureDark() {
        return EnumPartTexture.PatTerm_Matter_Dark;
    }

    @Override
    public EnumPartTexture getTextureColored() {
        return EnumPartTexture.PatTerm_Matter_Colored;
    }
}

