/*
 * Decompiled with CFR 0.152.
 */
package by.fxg.mwicontent.ae2.tile;

import appeng.api.AEApi;
import appeng.api.implementations.tiles.IChestOrDrive;
import appeng.api.networking.GridFlags;
import appeng.api.networking.events.MENetworkCellArrayUpdate;
import appeng.api.networking.events.MENetworkEvent;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.MachineSource;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.storage.ICellHandler;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.ISaveProvider;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.util.AECableType;
import appeng.api.util.DimensionalCoord;
import appeng.helpers.IPriorityHost;
import appeng.me.GridAccessException;
import appeng.me.storage.DriveWatcher;
import appeng.me.storage.MEInventoryHandler;
import appeng.tile.TileEvent;
import appeng.tile.events.TileEventType;
import appeng.tile.grid.AENetworkInvTile;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.tile.inventory.IAEAppEngInventory;
import appeng.tile.inventory.InvOperation;
import appeng.util.Platform;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import ru.justagod.cutter.invoke.Invoke;

@Deprecated
public class TileDriveExtended
extends AENetworkInvTile
implements IChestOrDrive,
IPriorityHost {
    private static final int[] ACCESSIBLE_SIDES = new int[0];
    private static final int CELLS_COUNT = 30;
    private final AppEngInternalInventory inventory = new AppEngInternalInventory((IAEAppEngInventory)this, 30);
    private final BaseActionSource actionSource;
    private final ICellHandler[] cellHandlersBySlot = new ICellHandler[30];
    private final DriveWatcher<IAEItemStack>[] driveWatcherBySlot = new DriveWatcher[30];
    private List<MEInventoryHandler<?>> cachedItems = new LinkedList();
    private List<MEInventoryHandler<?>> cachedFluids = new LinkedList();
    private boolean isCached = false;
    private boolean wasActive = false;
    private final int[] state = new int[]{0, 0, 0};
    private long lastStateChange = 0L;
    private int priority = 0;
    private int recalculateDisplayTimer = 10;

    public TileDriveExtended() {
        this.actionSource = new MachineSource((IActionHost)this);
        this.getProxy().setFlags(new GridFlags[]{GridFlags.REQUIRE_CHANNEL});
    }

    public int getCellCount() {
        return 30;
    }

    public int getCellStatus(int slot) {
        if (Platform.isClient()) {
            return this.state[slot / 10] >> slot % 10 * 3 & 3;
        }
        ItemStack cell = this.inventory.func_70301_a(2);
        ICellHandler ch = this.cellHandlersBySlot[slot];
        DriveWatcher<IAEItemStack> handler = this.driveWatcherBySlot[slot];
        if (handler == null) {
            return 0;
        }
        if (handler.getChannel() == StorageChannel.ITEMS && ch != null) {
            return ch.getStatusForCell(cell, handler.getInternal());
        }
        if (handler.getChannel() == StorageChannel.FLUIDS && ch != null) {
            return ch.getStatusForCell(cell, handler.getInternal());
        }
        return 0;
    }

    public boolean isPowered() {
        if (Platform.isClient()) {
            return (this.state[0] & Integer.MIN_VALUE) == Integer.MIN_VALUE;
        }
        return this.getProxy().isActive();
    }

    public boolean isCellBlinking(int slot) {
        long now = this.field_145850_b.func_82737_E();
        if (now - this.lastStateChange > 8L) {
            return false;
        }
        int i = slot / 10;
        return (this.state[i] >> slot % 10 * 3 + 2 & 1) == 1;
    }

    @TileEvent(value=TileEventType.NETWORK_READ)
    public boolean readFromStream_TileDrive(ByteBuf data) {
        int i;
        int[] oldState = new int[3];
        System.arraycopy(this.state, 0, oldState, 0, 3);
        for (i = 0; i < 3; ++i) {
            this.state[i] = data.readInt();
        }
        this.lastStateChange = this.field_145850_b.func_82737_E();
        for (i = 0; i < 3; ++i) {
            if ((this.state[i] & 0xDB6DB6DB) == (oldState[i] & 0xDB6DB6DB)) continue;
            return true;
        }
        return false;
    }

    public AECableType getCableConnectionType(ForgeDirection dir) {
        return AECableType.SMART;
    }

    public DimensionalCoord getLocation() {
        return new DimensionalCoord((TileEntity)this);
    }

    public IInventory getInternalInventory() {
        return this.inventory;
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return itemstack != null && AEApi.instance().registries().cell().isCellHandled(itemstack);
    }

    public void onChangeInventory(IInventory inv, int slot, InvOperation mc, ItemStack removed, ItemStack added) {
        if (this.isCached) {
            this.isCached = false;
            this.updateState();
        }
        try {
            this.getProxy().getGrid().postEvent((MENetworkEvent)new MENetworkCellArrayUpdate());
            IStorageGrid gs = this.getProxy().getStorage();
            Platform.postChanges((IStorageGrid)gs, (ItemStack)removed, (ItemStack)added, (BaseActionSource)this.actionSource);
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
        this.markForUpdate();
    }

    public int[] getAccessibleSlotsBySide(ForgeDirection side) {
        return ACCESSIBLE_SIDES;
    }

    private void updateState() {
        if (!this.isCached) {
            this.cachedItems = new LinkedList();
            this.cachedFluids = new LinkedList();
            double power = 2.0;
            for (int x = 0; x < this.inventory.func_70302_i_(); ++x) {
                DriveWatcher ih;
                ItemStack is = this.inventory.func_70301_a(x);
                this.driveWatcherBySlot[x] = null;
                this.cellHandlersBySlot[x] = null;
                if (is == null) continue;
                this.cellHandlersBySlot[x] = AEApi.instance().registries().cell().getHandler(is);
                if (this.cellHandlersBySlot[x] == null) continue;
                IMEInventoryHandler cell = this.cellHandlersBySlot[x].getCellInventory(is, (ISaveProvider)this, StorageChannel.ITEMS);
                if (cell != null) {
                    power += this.cellHandlersBySlot[x].cellIdleDrain(is, (IMEInventory)cell);
                    ih = new DriveWatcher((IMEInventory)cell, is, this.cellHandlersBySlot[x], (IChestOrDrive)this);
                    ih.setPriority(this.priority);
                    this.driveWatcherBySlot[x] = ih;
                    this.cachedItems.add((MEInventoryHandler<?>)ih);
                    continue;
                }
                cell = this.cellHandlersBySlot[x].getCellInventory(is, (ISaveProvider)this, StorageChannel.FLUIDS);
                if (cell == null) continue;
                power += this.cellHandlersBySlot[x].cellIdleDrain(is, (IMEInventory)cell);
                ih = new DriveWatcher((IMEInventory)cell, is, this.cellHandlersBySlot[x], (IChestOrDrive)this);
                ih.setPriority(this.priority);
                this.driveWatcherBySlot[x] = ih;
                this.cachedFluids.add((MEInventoryHandler<?>)ih);
            }
            this.getProxy().setIdlePowerUsage(power);
            this.isCached = true;
        }
    }

    public void onReady() {
        super.onReady();
        this.updateState();
    }

    public List<IMEInventoryHandler> getCellArray(StorageChannel channel) {
        if (this.getProxy().isActive()) {
            this.updateState();
            return channel == StorageChannel.ITEMS ? this.cachedItems : this.cachedFluids;
        }
        return new ArrayList<IMEInventoryHandler>();
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int newValue) {
        this.priority = newValue;
        this.func_70296_d();
        this.isCached = false;
        this.updateState();
        try {
            this.getProxy().getGrid().postEvent((MENetworkEvent)new MENetworkCellArrayUpdate());
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }

    public void blinkCell(int slot) {
        long now = this.field_145850_b.func_82737_E();
        if (now - this.lastStateChange > 8L) {
            if (now - this.lastStateChange > 20L) {
                for (int i = 0; i < 3; ++i) {
                    this.state[i] = 0;
                }
            }
            this.lastStateChange = now;
            int n = slot / 10;
            this.state[n] = this.state[n] | 1 << slot % 10 * 3 + 2;
            if (!this.field_145850_b.field_72995_K) {
                Invoke.server(() -> {});
            }
        }
    }

    public void saveChanges(IMEInventory cellInventory) {
        this.field_145850_b.func_147476_b(this.field_145851_c, this.field_145848_d, this.field_145849_e, (TileEntity)this);
    }
}

