/*
 * Decompiled with CFR 0.152.
 */
package by.fxg.mwicontent.ae2.tile.assemblers;

import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.implementations.IPowerChannelState;
import appeng.api.networking.GridFlags;
import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.networking.crafting.ICraftingProvider;
import appeng.api.networking.crafting.ICraftingProviderHelper;
import appeng.api.networking.events.MENetworkChannelsChanged;
import appeng.api.networking.events.MENetworkCraftingPatternChange;
import appeng.api.networking.events.MENetworkEvent;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.MachineSource;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.util.AECableType;
import appeng.api.util.DimensionalCoord;
import appeng.apiext.IAdvancedCraftingProvider;
import appeng.me.GridAccessException;
import appeng.me.helpers.AENetworkProxy;
import appeng.tile.TileEvent;
import appeng.tile.events.TileEventType;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.tile.inventory.IAEAppEngInventory;
import by.fxg.basicfml.collections.GDXArray;
import by.fxg.mwicontent.ae2.tile.TileAEGridTickableInv;
import by.fxg.mwicontent.ae2.util.PatternDetailsMagical;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import vazkii.botania.api.internal.IManaBurst;
import vazkii.botania.api.mana.IManaCollector;
import vazkii.botania.api.mana.IManaPool;
import vazkii.botania.client.core.handler.HUDHandler;

public abstract class TileMagicalAssembler
extends TileAEGridTickableInv
implements IAdvancedCraftingProvider,
IPowerChannelState,
IManaPool,
IManaCollector {
    private static final int[] ACCESSIBLE_SIDES = new int[0];
    protected final AppEngInternalInventory inventoryPatterns;
    protected final GDXArray<PatternDetailsMagical> craftingList;
    protected final GDXArray<IAEItemStack> craftArray;
    protected final MachineSource actionSource;
    protected final boolean acceptsMana;
    protected int mana = 0;
    protected PatternDetailsMagical currentPatternDetails = null;
    protected boolean isPowered = false;

    public TileMagicalAssembler(int patternInvSlots, int craftArraySlots, boolean acceptsMana) {
        this.inventoryPatterns = new AppEngInternalInventory((IAEAppEngInventory)this, patternInvSlots);
        this.craftingList = new GDXArray(true, false, patternInvSlots);
        this.craftArray = new GDXArray(true, false, craftArraySlots);
        this.actionSource = new MachineSource((IActionHost)this);
        this.acceptsMana = acceptsMana;
        this.getProxy().setFlags(new GridFlags[]{GridFlags.REQUIRE_CHANNEL});
    }

    public TileMagicalAssembler(boolean acceptsMana) {
        this(27, 16, acceptsMana);
    }

    @TileEvent(value=TileEventType.WORLD_NBT_WRITE)
    public void writeToNBTAssembler(NBTTagCompound compound) {
        compound.func_74768_a("mwim", this.mana);
    }

    @TileEvent(value=TileEventType.WORLD_NBT_READ)
    public void readFromNBTAssembler(NBTTagCompound compound) {
        this.mana = compound.func_74762_e("mwim");
    }

    @TileEvent(value=TileEventType.NETWORK_READ)
    public boolean readFromStreamAssembler(ByteBuf data) {
        boolean oldPower = this.isPowered;
        this.mana = data.readInt();
        this.isPowered = data.readBoolean();
        return this.isPowered != oldPower;
    }

    @TileEvent(value=TileEventType.NETWORK_WRITE)
    public void writeToStreamAssembler(ByteBuf data) {
        data.writeInt(this.mana);
        data.writeBoolean(this.isPowered);
    }

    @MENetworkEventSubscribe
    public void onChannelsChanged(MENetworkChannelsChanged c) {
        try {
            AENetworkProxy proxy = this.getProxy();
            this.checkPowerChanges(proxy);
            proxy.getGrid().postEvent((MENetworkEvent)new MENetworkCraftingPatternChange((ICraftingProvider)this, proxy.getNode()));
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }

    @MENetworkEventSubscribe
    public void onPowerStatusChange(MENetworkPowerStatusChange c) {
        try {
            AENetworkProxy proxy = this.getProxy();
            this.checkPowerChanges(proxy);
            proxy.getGrid().postEvent((MENetworkEvent)new MENetworkCraftingPatternChange((ICraftingProvider)this, proxy.getNode()));
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }

    protected void checkPowerChanges(AENetworkProxy proxy) throws GridAccessException {
        boolean newState;
        boolean bl = newState = proxy.isActive() && proxy.getEnergy().extractAEPower(1.0, Actionable.SIMULATE, PowerMultiplier.CONFIG) > 1.0E-4;
        if (this.isPowered != newState) {
            this.isPowered = newState;
            this.markForUpdate();
        }
    }

    protected boolean isPatternValid(ICraftingPatternDetails details) {
        return details != null && details.isCraftable();
    }

    public abstract String getUnlocalizedName();

    public boolean isAcceptsMana() {
        return this.acceptsMana;
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return false;
    }

    public boolean isBusy() {
        return this.currentPatternDetails != null;
    }

    public boolean isPowered() {
        return this.isPowered;
    }

    public boolean isActive() {
        return this.isPowered;
    }

    public IInventory getInternalInventory() {
        return this.inventoryPatterns;
    }

    public DimensionalCoord getLocation() {
        return new DimensionalCoord((TileEntity)this);
    }

    public AECableType getCableConnectionType(ForgeDirection dir) {
        return AECableType.SMART;
    }

    public final int[] getAccessibleSlotsBySide(ForgeDirection whichSide) {
        return ACCESSIBLE_SIDES;
    }

    public int getCurrentMana() {
        return this.mana;
    }

    public float getManaYieldMultiplier(IManaBurst burst) {
        return 1.0f;
    }

    public boolean isFull() {
        return this.mana == this.getMaxMana();
    }

    public boolean canRecieveManaFromBursts() {
        return this.acceptsMana;
    }

    public void recieveMana(int mana) {
        this.mana = Math.max(0, Math.min(this.mana + mana, this.getMaxMana()));
    }

    public boolean isOutputtingPower() {
        return false;
    }

    public void onClientDisplayTick() {
    }

    @SideOnly(value=Side.CLIENT)
    public void renderBotaniaOverlay(Minecraft mc, ScaledResolution res) {
        HUDHandler.drawSimpleManaHUD((int)0xEEEEEE, (int)this.mana, (int)this.getMaxMana(), (String)StatCollector.func_74838_a((String)this.getUnlocalizedName()), (ScaledResolution)res);
    }

    private /* synthetic */ void lambda$provideCrafting$0(ICraftingProviderHelper craftingTracker) {
    }
}

