/*
 * Decompiled with CFR 0.152.
 */
package by.fxg.mwicontent.ae2.tile.assemblers;

import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.implementations.IPowerChannelState;
import appeng.api.networking.GridFlags;
import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.networking.crafting.ICraftingProvider;
import appeng.api.networking.crafting.ICraftingProviderHelper;
import appeng.api.networking.events.MENetworkChannelsChanged;
import appeng.api.networking.events.MENetworkCraftingPatternChange;
import appeng.api.networking.events.MENetworkEvent;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.MachineSource;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.util.AECableType;
import appeng.api.util.DimensionalCoord;
import appeng.apiext.IAdvancedCraftingProvider;
import appeng.me.GridAccessException;
import appeng.me.helpers.AENetworkProxy;
import appeng.tile.TileEvent;
import appeng.tile.events.TileEventType;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.tile.inventory.IAEAppEngInventory;
import by.fxg.basicfml.collections.GDXArray;
import by.fxg.mwicontent.ae2.items.patterns.ItemCraftingPatternThaumic;
import by.fxg.mwicontent.ae2.tile.TileAEGridTickableInv;
import by.fxg.mwicontent.ae2.util.PatternDetailsThaumic;
import by.fxg.mwicontent.thaumcraft.util.AspectArray;
import io.netty.buffer.ByteBuf;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.aspects.IAspectContainer;
import thaumicenergistics.common.integration.tc.DigiVisSourceData;

public class TileThaumicAssembler
extends TileAEGridTickableInv
implements IAdvancedCraftingProvider,
IPowerChannelState,
IAspectContainer {
    private static final String UNLOCALIZED_NAME = "text.blockThaumicAssembler.name";
    private static final int[] ACCESSIBLE_SIDES = new int[0];
    protected final DigiVisSourceData visSourceData = new DigiVisSourceData();
    protected final AppEngInternalInventory inventoryPatterns;
    protected final GDXArray<PatternDetailsThaumic> craftingList;
    protected final GDXArray<IAEItemStack> craftArray;
    protected final MachineSource actionSource;
    protected PatternDetailsThaumic currentPatternDetails = null;
    protected AspectArray aspectArray = new AspectArray();
    protected boolean isPowered = false;

    public TileThaumicAssembler(int patternInvSlots, int craftArraySlots) {
        this.inventoryPatterns = new AppEngInternalInventory((IAEAppEngInventory)this, patternInvSlots);
        this.craftingList = new GDXArray(true, false, patternInvSlots);
        this.craftArray = new GDXArray(true, false, craftArraySlots);
        this.actionSource = new MachineSource((IActionHost)this);
        this.getProxy().setFlags(new GridFlags[]{GridFlags.REQUIRE_CHANNEL});
    }

    public TileThaumicAssembler() {
        this(27, 16);
    }

    @TileEvent(value=TileEventType.WORLD_NBT_WRITE)
    public void writeToNBTAssembler(NBTTagCompound compound) {
        this.aspectArray.writeToNBT(compound);
    }

    @TileEvent(value=TileEventType.WORLD_NBT_READ)
    public void readFromNBTAssembler(NBTTagCompound compound) {
        this.aspectArray.readFromNBT(compound);
    }

    @TileEvent(value=TileEventType.NETWORK_READ)
    public boolean readFromStreamAssembler(ByteBuf data) {
        boolean oldPower = this.isPowered;
        this.isPowered = data.readBoolean();
        return this.isPowered != oldPower;
    }

    @TileEvent(value=TileEventType.NETWORK_WRITE)
    public void writeToStreamAssembler(ByteBuf data) {
        data.writeBoolean(this.isPowered);
    }

    @MENetworkEventSubscribe
    public void onChannelsChanged(MENetworkChannelsChanged c) {
        try {
            AENetworkProxy proxy = this.getProxy();
            this.checkPowerChanges(proxy);
            proxy.getGrid().postEvent((MENetworkEvent)new MENetworkCraftingPatternChange((ICraftingProvider)this, proxy.getNode()));
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }

    @MENetworkEventSubscribe
    public void onPowerStatusChange(MENetworkPowerStatusChange c) {
        try {
            AENetworkProxy proxy = this.getProxy();
            this.checkPowerChanges(proxy);
            proxy.getGrid().postEvent((MENetworkEvent)new MENetworkCraftingPatternChange((ICraftingProvider)this, proxy.getNode()));
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }

    protected void checkPowerChanges(AENetworkProxy proxy) throws GridAccessException {
        boolean newState;
        boolean bl = newState = proxy.isActive() && proxy.getEnergy().extractAEPower(1.0, Actionable.SIMULATE, PowerMultiplier.CONFIG) > 1.0E-4;
        if (this.isPowered != newState) {
            this.isPowered = newState;
            this.markForUpdate();
        }
    }

    protected boolean isPatternValid(ICraftingPatternDetails details) {
        return details instanceof PatternDetailsThaumic && ((PatternDetailsThaumic)details).getPatternType() == PatternDetailsThaumic.ThaumicPatternType.INFUSION;
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return stack != null && stack.func_77973_b() instanceof ItemCraftingPatternThaumic && stack.func_77960_j() == 1;
    }

    public boolean isBusy() {
        return this.currentPatternDetails != null;
    }

    public boolean isPowered() {
        return this.isPowered;
    }

    public boolean isActive() {
        return this.isPowered;
    }

    public IInventory getInternalInventory() {
        return this.inventoryPatterns;
    }

    public DimensionalCoord getLocation() {
        return new DimensionalCoord((TileEntity)this);
    }

    public AECableType getCableConnectionType(ForgeDirection dir) {
        return AECableType.SMART;
    }

    public final int[] getAccessibleSlotsBySide(ForgeDirection whichSide) {
        return ACCESSIBLE_SIDES;
    }

    public int addToContainer(Aspect aspect, int arg1) {
        return 0;
    }

    public int containerContains(Aspect aspect) {
        return 0;
    }

    public boolean doesContainerAccept(Aspect aspect) {
        return false;
    }

    public boolean doesContainerContain(AspectList aspect) {
        return false;
    }

    public boolean doesContainerContainAmount(Aspect aspect, int arg1) {
        return false;
    }

    public AspectList getAspects() {
        return null;
    }

    public void setAspects(AspectList aspect) {
    }

    public boolean takeFromContainer(AspectList aspect) {
        return false;
    }

    public boolean takeFromContainer(Aspect aspect, int arg1) {
        return false;
    }

    public String getUnlocalizedName() {
        return UNLOCALIZED_NAME;
    }

    private /* synthetic */ void lambda$provideCrafting$0(ICraftingProviderHelper craftingTracker) {
    }
}

