/*
 * Decompiled with CFR 0.152.
 */
package by.fxg.mwicontent.ae2.tile.patternproviders;

import appeng.api.networking.GridFlags;
import appeng.api.networking.crafting.ICraftingMedium;
import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.networking.crafting.ICraftingProvider;
import appeng.api.networking.crafting.ICraftingProviderHelper;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.MachineSource;
import appeng.api.networking.ticking.TickingRequest;
import appeng.me.GridAccessException;
import appeng.me.helpers.AENetworkProxy;
import appeng.tile.TileEvent;
import appeng.tile.events.TileEventType;
import by.fxg.mwicontent.ae2.tile.TileAEGridTickable;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public abstract class TilePatternProvider
extends TileAEGridTickable
implements ICraftingProvider {
    protected static final TickingRequest TICKING_REQUEST = new TickingRequest(5, 20, false, false);
    protected final MachineSource actionSource;
    protected List<ICraftingPatternDetails> patternDetails = Collections.emptyList();
    protected boolean isWorking = false;
    protected int assignedIndex = -1;

    public TilePatternProvider() {
        this.actionSource = new MachineSource((IActionHost)this);
        this.getProxy().setFlags(new GridFlags[]{GridFlags.REQUIRE_CHANNEL});
    }

    public TilePatternProvider(List<ICraftingPatternDetails> patternDetails) {
        this.actionSource = new MachineSource((IActionHost)this);
        this.patternDetails = patternDetails;
    }

    public TilePatternProvider(ICraftingPatternDetails ... patternDetails) {
        this.actionSource = new MachineSource((IActionHost)this);
        this.patternDetails = Lists.newArrayList((Object[])patternDetails);
    }

    @TileEvent(value=TileEventType.WORLD_NBT_READ)
    public void readFromNBT_AENetwork(NBTTagCompound data) {
        this.isWorking = data.func_74767_n("ppIsW");
        this.assignedIndex = data.func_74762_e("ppIdx");
        super.readFromNBT_AENetwork(data);
    }

    @TileEvent(value=TileEventType.WORLD_NBT_WRITE)
    public void writeToNBT_AENetwork(NBTTagCompound data) {
        data.func_74757_a("ppIsW", this.isWorking);
        data.func_74768_a("ppIdx", this.assignedIndex);
        super.writeToNBT_AENetwork(data);
    }

    public void provideCrafting(ICraftingProviderHelper craftingTracker) {
        for (ICraftingPatternDetails patternDetails : this.patternDetails) {
            craftingTracker.addCraftingOption((ICraftingMedium)this, patternDetails);
        }
    }

    public boolean pushPattern(ICraftingPatternDetails patternDetails, InventoryCrafting table) {
        if (this.patternDetails.isEmpty() || patternDetails == null) {
            return false;
        }
        if (this.patternDetails.contains(patternDetails)) {
            int index = this.patternDetails.indexOf(patternDetails);
            if (index > -1) {
                try {
                    AENetworkProxy proxy = this.getProxy();
                    if (proxy.getTick().wakeDevice(proxy.getNode())) {
                        this.isWorking = true;
                        this.assignedIndex = index;
                        return true;
                    }
                }
                catch (GridAccessException gridAccessException) {
                    // empty catch block
                }
            }
            return false;
        }
        return false;
    }

    public boolean isBusy() {
        return this.isWorking;
    }

    protected ItemStack getItemFromTile(Object obj) {
        return this.getTileItemStack();
    }

    public ItemStack getCrafterIcon() {
        return this.getTileItemStack();
    }

    protected abstract ItemStack getTileItemStack();
}

