/*
 * Decompiled with CFR 0.152.
 */
package by.fxg.mwicontent.botania;

import by.fxg.basicfml.configv2.BasicPartedConfigPart;
import by.fxg.basicfml.configv2.intermediary.IntermediaryCompound;
import by.fxg.basicfml.util.IProxy;
import by.fxg.mwicontent.botania.ContentBotaniaConfig;
import by.fxg.mwicontent.botania.ContentBotaniaProxyClient;
import by.fxg.mwicontent.botania.blocks.BlockCatalystTable;
import by.fxg.mwicontent.botania.blocks.BlockManaPool;
import by.fxg.mwicontent.botania.blocks.BlockManaSpreader;
import by.fxg.mwicontent.botania.blocks.BlockMultiFlower;
import by.fxg.mwicontent.botania.gui.GuiCatalystTable;
import by.fxg.mwicontent.botania.gui.GuiMultiFlower;
import by.fxg.mwicontent.botania.signatures.FlowerSignature;
import by.fxg.mwicontent.botania.signatures.FlowerSignatureType;
import by.fxg.mwicontent.botania.tile.TileAlchemyCatalystTable;
import by.fxg.mwicontent.botania.tile.TileCatalystTable;
import by.fxg.mwicontent.botania.tile.TileInfusionCatalystTable;
import by.fxg.mwicontent.botania.tile.TileWitcheryCatalystTable;
import by.fxg.mwicontent.botania.tile.flowers.FlowerTileAsgardDandelion;
import by.fxg.mwicontent.botania.tile.flowers.FlowerTileCeliaFlos;
import by.fxg.mwicontent.botania.tile.flowers.FlowerTileFeistyPoisonIvy;
import by.fxg.mwicontent.botania.tile.flowers.FlowerTileFlowey;
import by.fxg.mwicontent.botania.tile.flowers.FlowerTileHelheimWeed;
import by.fxg.mwicontent.botania.tile.flowers.FlowerTileMidgardSunflower;
import by.fxg.mwicontent.botania.tile.multi.TileMultiFlower;
import by.fxg.mwicontent.botania.tile.pools.TileAsgardManaPool;
import by.fxg.mwicontent.botania.tile.pools.TileHelheimManaPool;
import by.fxg.mwicontent.botania.tile.pools.TileMidgardManaPool;
import by.fxg.mwicontent.botania.tile.spreaders.TileAsgardManaSpreader;
import by.fxg.mwicontent.botania.tile.spreaders.TileHelheimManaSpreader;
import by.fxg.mwicontent.botania.tile.spreaders.TileMidgardManaSpreader;
import by.fxg.mwintegration.common.ContentManager;
import by.fxg.mwintegration.common.integrations.ContentIntegration;
import by.fxg.mwintegration.common.integrations.IntegrationConfig;
import by.fxg.mwintegration.common.integrations.IntegrationGuiHandler;
import by.fxg.mwintegration.common.integrations.IntegrationProxy;
import com.google.common.collect.Lists;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.brew.Brew;
import vazkii.botania.api.subtile.SubTileEntity;
import vazkii.botania.api.subtile.signature.SubTileSignature;

public class ContentBotania
extends ContentIntegration
implements IntegrationConfig,
IntegrationGuiHandler,
IntegrationProxy {
    public static final String MODID = "Botania";
    public static final int GuiIDCatalystTable = 769;
    public static final int GuiIDMultiFlower = 770;
    public static Block blockMidgardManaPool;
    public static Block blockHelheimManaPool;
    public static Block blockAsgardManaPool;
    public static Block blockMidgardManaSpreader;
    public static Block blockHelheimManaSpreader;
    public static Block blockAsgardManaSpreader;
    public static Block blockInfusionCatalystTable;
    public static Block blockAlchemyCatalystTable;
    public static Block blockWitcheryCatalystTable;
    public static Block blockMultiFlower;
    public static List<Brew> botaniaBrews;

    @Override
    @Optional.Method(modid="Botania")
    public void onInitialization(ContentManager contentManager, FMLInitializationEvent event) {
        if (!ContentBotaniaConfig.ENABLED) {
            return;
        }
        if (ContentBotaniaConfig.ENABLE_flowerMidgardSunflower) {
            this.registerFlower("midgardSunflower", new FlowerSignature("midgardSunflower", FlowerSignatureType.PASSIVE_GENERATING), FlowerTileMidgardSunflower.class);
        }
        if (ContentBotaniaConfig.ENABLE_flowerHelheimWeed) {
            this.registerFlower("helheimWeed", new FlowerSignature("helheimWeed", FlowerSignatureType.PASSIVE_GENERATING), FlowerTileHelheimWeed.class);
        }
        if (ContentBotaniaConfig.ENABLE_flowerAsgardDandelion) {
            this.registerFlower("asgardDandelion", new FlowerSignature("asgardDandelion", FlowerSignatureType.PASSIVE_GENERATING), FlowerTileAsgardDandelion.class);
        }
        if (ContentBotaniaConfig.ENABLE_flowerFeistyPoisonIvy) {
            this.registerFlower("feistyPoisonIvy", new FlowerSignature("feistyPoisonIvy", FlowerSignatureType.FUNCTIONAL), FlowerTileFeistyPoisonIvy.class);
        }
        if (ContentBotaniaConfig.ENABLE_flowerCeliaFlos) {
            this.registerFlower("celiaFlos", new FlowerSignature("celiaFlos", FlowerSignatureType.FUNCTIONAL), FlowerTileCeliaFlos.class);
        }
        if (ContentBotaniaConfig.ENABLE_flowerFlowey) {
            this.registerFlower("flowey", new FlowerSignature("flowey", FlowerSignatureType.CREATIVE), FlowerTileFlowey.class);
        }
        if (ContentBotaniaConfig.ENABLE_blockMidgardManaPool) {
            blockMidgardManaPool = new BlockManaPool("blockMidgardManaPool", TileMidgardManaPool::new);
            this.registerBlock("blockMidgardManaPool", blockMidgardManaPool, TileMidgardManaPool.class);
        }
        if (ContentBotaniaConfig.ENABLE_blockHelheimManaPool) {
            blockHelheimManaPool = new BlockManaPool("blockHelheimManaPool", TileHelheimManaPool::new);
            this.registerBlock("blockHelheimManaPool", blockHelheimManaPool, TileHelheimManaPool.class);
        }
        if (ContentBotaniaConfig.ENABLE_blockAsgardManaPool) {
            blockAsgardManaPool = new BlockManaPool("blockAsgardManaPool", TileAsgardManaPool::new);
            this.registerBlock("blockAsgardManaPool", blockAsgardManaPool, TileAsgardManaPool.class);
        }
        if (ContentBotaniaConfig.ENABLE_blockMidgardManaSpreader) {
            blockMidgardManaSpreader = new BlockManaSpreader("blockMidgardManaSpreader", TileMidgardManaSpreader::new);
            this.registerBlock("blockMidgardManaSpreader", blockMidgardManaSpreader, TileMidgardManaSpreader.class);
        }
        if (ContentBotaniaConfig.ENABLE_blockHelheimManaSpreader) {
            blockHelheimManaSpreader = new BlockManaSpreader("blockHelheimManaSpreader", TileHelheimManaSpreader::new);
            this.registerBlock("blockHelheimManaSpreader", blockHelheimManaSpreader, TileHelheimManaSpreader.class);
        }
        if (ContentBotaniaConfig.ENABLE_blockAsgardManaSpreader) {
            blockAsgardManaSpreader = new BlockManaSpreader("blockAsgardManaSpreader", TileAsgardManaSpreader::new);
            this.registerBlock("blockAsgardManaSpreader", blockAsgardManaSpreader, TileAsgardManaSpreader.class);
        }
        if (ContentBotaniaConfig.ENABLE_blockInfusionCatalystTable) {
            blockInfusionCatalystTable = new BlockCatalystTable("blockInfusionCatalystTable", TileInfusionCatalystTable::new);
            this.registerBlock("blockInfusionCatalystTable", blockInfusionCatalystTable, TileInfusionCatalystTable.class);
        }
        if (ContentBotaniaConfig.ENABLE_blockAlchemyCatalystTable) {
            blockAlchemyCatalystTable = new BlockCatalystTable("blockAlchemyCatalystTable", TileAlchemyCatalystTable::new);
            this.registerBlock("blockAlchemyCatalystTable", blockAlchemyCatalystTable, TileAlchemyCatalystTable.class);
        }
        if (ContentBotaniaConfig.ENABLE_blockWitcheryCatalystTable) {
            blockWitcheryCatalystTable = new BlockCatalystTable("blockWitcheryCatalystTable", TileWitcheryCatalystTable::new);
            this.registerBlock("blockWitcheryCatalystTable", blockWitcheryCatalystTable, TileWitcheryCatalystTable.class);
        }
        if (ContentBotaniaConfig.ENABLE_blockMultiFlower) {
            blockMultiFlower = new BlockMultiFlower();
            this.registerBlock("blockMultiFlower", blockMultiFlower, TileMultiFlower.class);
        }
    }

    @Override
    public void onPostInitialization(ContentManager contentManager, FMLPostInitializationEvent event) {
        botaniaBrews = Lists.newArrayList(BotaniaAPI.brewMap.values());
    }

    @Override
    public BasicPartedConfigPart<IntermediaryCompound> getConfiguration() {
        return new ContentBotaniaConfig();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Object getClientGui(int ID, EntityPlayer player, World world, TileEntity tileEntity, int x, int y, int z) {
        if (ID == 769 && tileEntity instanceof TileCatalystTable) {
            return new GuiCatalystTable(player, (TileCatalystTable)tileEntity);
        }
        if (ID == 770 && tileEntity instanceof TileMultiFlower) {
            return new GuiMultiFlower(player, (TileMultiFlower)tileEntity);
        }
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IProxy createClientProxy(ContentManager contentManager) {
        return new ContentBotaniaProxyClient();
    }

    private void registerFlower(String flowerName, FlowerSignature flowerSignature, Class<? extends SubTileEntity> tileEntityClass) {
        BotaniaAPI.registerSubTile((String)flowerName, tileEntityClass);
        BotaniaAPI.registerSubTileSignature(tileEntityClass, (SubTileSignature)flowerSignature);
        BotaniaAPI.addSubTileToCreativeMenu((String)flowerName);
    }
}

