/*
 * Decompiled with CFR 0.152.
 */
package by.fxg.mwicontent.botania.tile.multi;

import by.fxg.basicfml.inventory.Inventory;
import by.fxg.basicfml.tileentity.TileEntityInventory;
import by.fxg.mwicontent.botania.ContentBotaniaConfig;
import by.fxg.mwicontent.botania.tile.multi.EitherCustomOrNormalSubTile;
import by.fxg.mwicontent.botania.tile.multi.EntityPlayerMultiFlower;
import by.fxg.mwicontent.botania.tile.multi.SubTileBehaviourOverride;
import by.fxg.mwicontent.botania.tile.multi.customs.EuclidaisyOverride;
import by.fxg.mwicontent.botania.tile.multi.customs.HellOrechidBehaviour;
import by.fxg.mwicontent.botania.tile.multi.customs.HiveacynthBehaviour;
import by.fxg.mwicontent.botania.tile.multi.customs.LooniumOverride;
import by.fxg.mwicontent.botania.tile.multi.customs.MarimorphosisOverride;
import by.fxg.mwicontent.botania.tile.multi.customs.OrechidBehaviour;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import ru.justagod.cutter.invoke.Invoke;
import vazkii.botania.api.internal.IManaBurst;
import vazkii.botania.api.mana.IManaCollector;
import vazkii.botania.api.mana.IManaPool;
import vazkii.botania.common.item.block.ItemBlockSpecialFlower;

public class TileMultiFlower
extends TileEntityInventory<Inventory>
implements ISidedInventory,
IManaPool,
IManaCollector {
    public static final HashMap<String, Supplier<SubTileBehaviourOverride>> OVERRIDES = new HashMap();
    public static final int FLOWER_SLOTS = 6;
    public static final int FIRST_OUTPUT_SLOT = 0;
    public static final int LAST_OUTPUT_SLOT = 53;
    public static final int FIRST_INPUT_BLOCKS = 54;
    public static final int LAST_INPUT_BLOCKS = 65;
    public static final int FIRST_INPUT_FLOWER = 66;
    public static final int LAST_INPUT_FLOWER = 71;
    public static final int[] ACCESSIBLE_SLOTS;
    private EitherCustomOrNormalSubTile[] flowers = new EitherCustomOrNormalSubTile[6];
    private int mana = 0;
    private EntityPlayerMultiFlower binder;

    public TileMultiFlower() {
        this.inventory = new Inventory(72);
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.mana = compound.func_74762_e("mana");
        Invoke.server(() -> {});
        if (compound.func_74764_b("subTileData")) {
            NBTTagList tagList = compound.func_150295_c("subTileData", (int)compound.func_74732_a());
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                NBTTagCompound upTag = tagList.func_150305_b(i);
                int slot = upTag.func_74762_e("index");
                NBTTagCompound inTag = upTag.func_74775_l("data");
                EitherCustomOrNormalSubTile flower = this.flowers[slot];
                if (flower == null || inTag == null) continue;
                flower.readFromPacketNBT(inTag);
            }
        }
    }

    public void func_145841_b(NBTTagCompound compound) {
        super.func_145841_b(compound);
        compound.func_74768_a("mana", this.mana);
        NBTTagList inventory = new NBTTagList();
        for (int i = 0; i < this.flowers.length; ++i) {
            EitherCustomOrNormalSubTile flower = this.flowers[i];
            if (flower == null) continue;
            NBTTagCompound upTag = new NBTTagCompound();
            upTag.func_74768_a("index", i);
            NBTTagCompound inTag = new NBTTagCompound();
            flower.writeToPacketNBT(inTag);
            upTag.func_74782_a("data", (NBTBase)inTag);
            inventory.func_74742_a((NBTBase)upTag);
        }
        compound.func_74782_a("subTileData", (NBTBase)inventory);
    }

    public void onBlockPlacedBy(World world, int x, int y, int z, EntityLivingBase entity, ItemStack stack) {
        Arrays.stream(this.flowers).filter(Objects::nonNull).forEach(it -> it.onBlockPlacedBy(world, x, y, z, entity, stack));
    }

    public void onBlockAdded(World world, int x, int y, int z) {
        Arrays.stream(this.flowers).filter(Objects::nonNull).forEach(it -> it.onBlockAdded(world, x, y, z));
    }

    public void onBlockHarvested(World world, int x, int y, int z, int side, EntityPlayer player) {
        Arrays.stream(this.flowers).filter(Objects::nonNull).forEach(it -> it.onBlockHarvested(world, x, y, z, side, player));
    }

    public void onClientDisplayTick() {
    }

    public float getManaYieldMultiplier(IManaBurst iManaBurst) {
        return 1.0f;
    }

    public int getMaxMana() {
        return ContentBotaniaConfig.MULTI_FLOWER_CAPACITY;
    }

    public boolean isOutputtingPower() {
        return false;
    }

    public boolean isFull() {
        return this.mana == this.getMaxMana();
    }

    public void recieveMana(int mana) {
        if (mana > 0) {
            mana = (int)Math.ceil((double)mana * ContentBotaniaConfig.MULTI_FLOWER_MANA_LOSS);
        }
        this.mana = Math.max(0, Math.min(this.getCurrentMana() + mana, this.getMaxMana()));
        this.func_70296_d();
        this.markToSync();
    }

    public boolean canRecieveManaFromBursts() {
        return true;
    }

    public int getCurrentMana() {
        return this.mana;
    }

    public int[] func_94128_d(int p_94128_1_) {
        return ACCESSIBLE_SLOTS;
    }

    public boolean func_102007_a(int slot, ItemStack item, int side) {
        if (slot >= 0 && slot <= 53) {
            return false;
        }
        return this.func_94041_b(slot, item);
    }

    public boolean func_102008_b(int slot, ItemStack item, int side) {
        return slot < 54 || slot > 65;
    }

    public int func_70302_i_() {
        return ((Inventory)this.inventory).func_70302_i_();
    }

    public ItemStack func_70301_a(int slot) {
        return ((Inventory)this.inventory).func_70301_a(slot);
    }

    public ItemStack func_70298_a(int slot, int size) {
        ItemStack result = ((Inventory)this.inventory).func_70298_a(slot, size);
        Invoke.server(() -> {});
        return result;
    }

    public ItemStack func_70304_b(int slot) {
        return ((Inventory)this.inventory).func_70304_b(slot);
    }

    public void func_70299_a(int slot, ItemStack stack) {
        ((Inventory)this.inventory).func_70299_a(slot, stack);
        Invoke.server(() -> {});
    }

    public String func_145825_b() {
        return ((Inventory)this.inventory).func_145825_b();
    }

    public boolean func_145818_k_() {
        return ((Inventory)this.inventory).func_145818_k_();
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return ((Inventory)this.inventory).func_70300_a(player);
    }

    public void func_70295_k_() {
        ((Inventory)this.inventory).func_70295_k_();
    }

    public void func_70305_f() {
        ((Inventory)this.inventory).func_70305_f();
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        if (slot >= 66 && slot <= 71) {
            return stack.func_77973_b() instanceof ItemBlockSpecialFlower;
        }
        return true;
    }

    static {
        OVERRIDES.put("orechidIgnem", HellOrechidBehaviour::new);
        OVERRIDES.put("orechid", OrechidBehaviour::new);
        OVERRIDES.put("loonium", LooniumOverride::new);
        OVERRIDES.put("marimorphosis", MarimorphosisOverride::new);
        OVERRIDES.put("euclidaisy", EuclidaisyOverride::new);
        OVERRIDES.put("hiveacynth", HiveacynthBehaviour::new);
        ACCESSIBLE_SLOTS = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 52, 63, 64, 65};
    }
}

