/*
 * Decompiled with CFR 0.152.
 */
package by.fxg.mwicontent.draconicevolution;

import by.fxg.basicfml.collections.GDXArray;
import by.fxg.basicfml.configv2.BasicPartedConfigPart;
import by.fxg.basicfml.configv2.intermediary.IntermediaryCompound;
import by.fxg.basicfml.util.IProxy;
import by.fxg.mwicontent.draconicevolution.ContentDraconicEvolutionConfig;
import by.fxg.mwicontent.draconicevolution.ContentDraconicEvolutionProxyClient;
import by.fxg.mwicontent.draconicevolution.block.BlockAutoKiller;
import by.fxg.mwicontent.draconicevolution.block.BlockAutoKillerSpawner;
import by.fxg.mwicontent.draconicevolution.block.BlockEnergyTransceiver;
import by.fxg.mwicontent.draconicevolution.gui.GuiAutoKiller;
import by.fxg.mwicontent.draconicevolution.item.ItemBlockEnergyTransceiver;
import by.fxg.mwicontent.draconicevolution.tile.TileAdvEnergyRelay;
import by.fxg.mwicontent.draconicevolution.tile.TileAdvEnergyTransceiver;
import by.fxg.mwicontent.draconicevolution.tile.TileAdvEnergyTransceiverWireless;
import by.fxg.mwicontent.draconicevolution.tile.TileAutoKiller;
import by.fxg.mwicontent.draconicevolution.tile.TileAutoKillerSpawner;
import by.fxg.mwicontent.draconicevolution.util.FluidTankExperience;
import by.fxg.mwintegration.common.ContentManager;
import by.fxg.mwintegration.common.integrations.ContentIntegration;
import by.fxg.mwintegration.common.integrations.IntegrationConfig;
import by.fxg.mwintegration.common.integrations.IntegrationGuiHandler;
import by.fxg.mwintegration.common.integrations.IntegrationProxy;
import by.fxg.mwintegration.common.utils.UtilsMWI;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidRegistry;
import ru.justagod.cutter.invoke.Invoke;
import thaumcraft.common.config.ConfigItems;
import thaumcraft.common.entities.monster.EntityEldritchCrab;
import thaumcraft.common.entities.monster.EntityInhabitedZombie;
import thaumcraft.common.entities.monster.boss.EntityEldritchGolem;

public class ContentDraconicEvolution
extends ContentIntegration
implements IntegrationConfig,
IntegrationGuiHandler,
IntegrationProxy {
    public static final String MODID = "DraconicEvolution";
    public static final int GuiIDAutoKiller = 1025;
    public static final GDXArray<ItemStack> ITEM_BUFFER = new GDXArray(true, false, 54);
    public static boolean isThermalFoundationLoaded = false;
    public static boolean isThaumcraftLoaded = false;
    public static Block blockAutoKiller;
    public static Block blockAutoKillerSpawner;
    public static Item itemInfinitySpawnerCore;
    public static Block blockEnergyTransceiver;

    @Override
    @Optional.Method(modid="DraconicEvolution")
    public void onInitialization(ContentManager contentManager, FMLInitializationEvent event) {
        if (!ContentDraconicEvolutionConfig.ENABLED) {
            return;
        }
        isThermalFoundationLoaded = contentManager.isLoaded("ThermalFoundation");
        isThaumcraftLoaded = contentManager.isLoaded("Thaumcraft");
        if (ContentDraconicEvolutionConfig.ENABLE_blockAutoKillerStuff) {
            Invoke.server(() -> {});
            blockAutoKiller = new BlockAutoKiller();
            this.registerBlock("blockAutoKiller", blockAutoKiller, TileAutoKiller.class);
            blockAutoKillerSpawner = new BlockAutoKillerSpawner();
            this.registerBlock("blockAutoKillerSpawner", blockAutoKillerSpawner, TileAutoKillerSpawner.class);
            itemInfinitySpawnerCore = new Item().func_77655_b("itemInfinitySpawnerCore");
            itemInfinitySpawnerCore.func_111206_d("mwi:draconicevolution/itemInfinitySpawnerCore");
            itemInfinitySpawnerCore.func_77637_a(ContentManager.tabMWIntegration);
            this.registerItem("itemInfinitySpawnerCore", itemInfinitySpawnerCore);
        }
        if (contentManager.isIntegrationPresent("IC2")) {
            this.initIC2();
        }
    }

    @Override
    @Optional.Method(modid="DraconicEvolution")
    public void onPostInitialization(ContentManager contentManager, FMLPostInitializationEvent event) {
        if (!ContentDraconicEvolutionConfig.ENABLED) {
            return;
        }
        FluidTankExperience.fluidXP = FluidRegistry.getFluid((String)"xpjuice");
    }

    @Optional.Method(modid="IC2")
    public void initIC2() {
        if (ContentDraconicEvolutionConfig.ENABLE_blockEnergyTransceiver) {
            blockEnergyTransceiver = new BlockEnergyTransceiver();
            GameRegistry.registerBlock((Block)blockEnergyTransceiver, ItemBlockEnergyTransceiver.class, (String)"blockEnergyTransceiver");
            GameRegistry.registerTileEntity(TileAdvEnergyRelay.class, (String)"blockEnergyTransceiver.taer");
            GameRegistry.registerTileEntity(TileAdvEnergyTransceiver.class, (String)"blockEnergyTransceiver.taet");
            GameRegistry.registerTileEntity(TileAdvEnergyTransceiverWireless.class, (String)"blockEnergyTransceiver.taetw");
        }
    }

    @Override
    public BasicPartedConfigPart<IntermediaryCompound> getConfiguration() {
        return new ContentDraconicEvolutionConfig();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Object getClientGui(int ID, EntityPlayer player, World world, TileEntity tileEntity, int x, int y, int z) {
        if (ID == 1025 && tileEntity instanceof TileAutoKiller) {
            return new GuiAutoKiller(player, (TileAutoKiller)tileEntity);
        }
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IProxy createClientProxy(ContentManager contentManager) {
        return new ContentDraconicEvolutionProxyClient();
    }

    @Optional.Method(modid="Thaumcraft")
    private void onLivingDropsThaumcraft(Entity entity, GDXArray<ItemStack> dropsCache, int lootingModifier) {
        if (entity instanceof EntityEldritchCrab || entity instanceof EntityInhabitedZombie) {
            if (UtilsMWI.getRandom(entity.field_70170_p.field_73012_v, 0.2 * (double)lootingModifier)) {
                dropsCache.add((Object)new ItemStack(Items.field_151079_bi, 1, 0));
            }
        } else if (entity instanceof EntityEldritchGolem && UtilsMWI.getRandom(entity.field_70170_p.field_73012_v, 0.02 * (double)lootingModifier)) {
            dropsCache.add((Object)new ItemStack(ConfigItems.itemEldritchObject, 1, 3));
        }
    }
}

