/*
 * Decompiled with CFR 0.152.
 */
package by.fxg.mwicontent.draconicevolution.util;

import io.netty.buffer.ByteBuf;
import java.security.InvalidParameterException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;

public class FluidTankExperience
extends FluidTank {
    public static final int XP_RATIO = 20;
    public static Fluid fluidXP;
    private int experienceLevel;
    private float experience;
    private int experienceTotal;
    private boolean xpDirty;
    private final int maxXp;

    public FluidTankExperience() {
        this(Integer.MAX_VALUE);
    }

    public FluidTankExperience(int maxStored) {
        super(null, 0);
        this.maxXp = maxStored;
    }

    public int getMaximumExperiance() {
        return this.maxXp;
    }

    public int getExperienceLevel() {
        return this.experienceLevel;
    }

    public float getExperience() {
        return this.experience;
    }

    public int getExperienceTotal() {
        return this.experienceTotal;
    }

    public boolean isDirty() {
        return this.xpDirty;
    }

    public void setDirty(boolean isDirty) {
        this.xpDirty = isDirty;
    }

    public void set(FluidTankExperience xpCon) {
        this.experienceTotal = xpCon.experienceTotal;
        this.experienceLevel = xpCon.experienceLevel;
        this.experience = xpCon.experience;
    }

    public int addExperience(int xpToAdd) {
        int j = this.maxXp - this.experienceTotal;
        if (j == 0) {
            return 0;
        }
        if (xpToAdd > j) {
            xpToAdd = j;
        }
        this.experience += (float)xpToAdd / (float)this.getXpBarCapacity();
        this.experienceTotal += xpToAdd;
        while (this.experience >= 1.0f) {
            this.experience = (this.experience - 1.0f) * (float)this.getXpBarCapacity();
            ++this.experienceLevel;
            this.experience /= (float)this.getXpBarCapacity();
        }
        this.xpDirty = true;
        return xpToAdd;
    }

    private int getXpBarCapacity() {
        return FluidTankExperience.getXpBarCapacity(this.experienceLevel);
    }

    public int getXpBarScaled(int scale) {
        return (int)(this.experience * (float)scale);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (resource == null || !this.canDrain(from, resource.getFluid())) {
            return null;
        }
        return this.drain(from, resource.amount, doDrain);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        if (fluidXP == null) {
            return null;
        }
        int available = this.getFluidAmount();
        int canDrain = Math.min(available, maxDrain);
        int xpAskedToExtract = canDrain / 20;
        int fluidToExtract = FluidTankExperience.experienceToLiquid(xpAskedToExtract);
        int xpToExtract = fluidToExtract / 20;
        if (doDrain) {
            int newXp = this.experienceTotal - xpToExtract;
            this.experience = 0.0f;
            this.experienceLevel = 0;
            this.experienceTotal = 0;
            this.addExperience(newXp);
        }
        return new FluidStack(fluidXP, fluidToExtract);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return fluid != null && fluidXP != null && fluid.getID() == fluidXP.getID();
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (resource == null) {
            return 0;
        }
        if (resource.amount <= 0) {
            return 0;
        }
        if (!this.canFill(from, resource.getFluid())) {
            return 0;
        }
        int xp = resource.amount / 20;
        int xpSpace = this.getMaximumExperiance() - this.getExperienceTotal();
        int canFillXP = Math.min(xp, xpSpace);
        if (canFillXP <= 0) {
            return 0;
        }
        if (doFill) {
            this.addExperience(canFillXP);
        }
        return FluidTankExperience.experienceToLiquid(canFillXP);
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return fluid != null && fluidXP != null && fluid.getID() == fluidXP.getID();
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        if (fluidXP == null) {
            return new FluidTankInfo[0];
        }
        return new FluidTankInfo[]{new FluidTankInfo(new FluidStack(fluidXP, this.getFluidAmount()), this.getCapacity())};
    }

    public int getCapacity() {
        if (this.maxXp == Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return FluidTankExperience.experienceToLiquid(this.maxXp);
    }

    public int getFluidAmount() {
        return FluidTankExperience.experienceToLiquid(this.experienceTotal);
    }

    public FluidTank readFromNBT(NBTTagCompound nbtRoot) {
        this.experienceLevel = nbtRoot.func_74762_e("ftxpl");
        this.experienceTotal = nbtRoot.func_74762_e("ftxpt");
        this.experience = nbtRoot.func_74760_g("ftxp");
        if (this.experienceLevel > this.maxXp) {
            this.experience = 0.0f;
            this.experienceLevel = 0;
            this.experienceTotal = 0;
            this.addExperience(this.maxXp);
        }
        return this;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbtRoot) {
        nbtRoot.func_74768_a("ftxpl", this.experienceLevel);
        nbtRoot.func_74768_a("ftxpt", this.experienceTotal);
        nbtRoot.func_74776_a("ftxp", this.experience);
        return nbtRoot;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.experienceTotal);
        buf.writeInt(this.experienceLevel);
        buf.writeFloat(this.experience);
    }

    public void fromBytes(ByteBuf buf) {
        this.experienceTotal = buf.readInt();
        this.experienceLevel = buf.readInt();
        this.experience = buf.readFloat();
    }

    public FluidStack getFluid() {
        return new FluidStack(fluidXP, this.getFluidAmount());
    }

    public FluidTankInfo getInfo() {
        return this.getTankInfo(ForgeDirection.UNKNOWN)[0];
    }

    public int fill(FluidStack resource, boolean doFill) {
        return this.fill(ForgeDirection.UNKNOWN, resource, doFill);
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        return this.drain(ForgeDirection.UNKNOWN, maxDrain, doDrain);
    }

    public void setFluid(FluidStack fluid) {
        this.experience = 0.0f;
        this.experienceLevel = 0;
        this.experienceTotal = 0;
        if (fluid != null && fluid.getFluid() != null) {
            if (fluidXP == fluid.getFluid()) {
                this.addExperience(fluid.amount / 20);
            } else {
                throw new InvalidParameterException(fluid.getFluid() + " is no XP juice");
            }
        }
        this.xpDirty = true;
    }

    public void setCapacity(int capacity) {
        throw new InvalidParameterException();
    }

    private static int experienceToLiquid(int xp) {
        if (Math.abs(xp) >= 0x6666667) {
            return Integer.MAX_VALUE;
        }
        return xp * 20;
    }

    private static int getXpBarCapacity(int level) {
        if (level >= 306783400) {
            return Integer.MAX_VALUE;
        }
        if (level >= 30) {
            return 62 + (level - 30) * 7;
        }
        if (level >= 15) {
            return 17 + (level - 15) * 3;
        }
        return 17;
    }

    public static int getExperienceForLevel(int level) {
        if (level < -24748 || level > 24791) {
            return Integer.MAX_VALUE;
        }
        if (level == 0) {
            return 0;
        }
        if (level > 0 && level < 16) {
            return level * 17;
        }
        if (level > 15 && level < 31) {
            return (int)((1.5 * (double)level - 29.5) * (double)level) + 360;
        }
        return (int)((3.5 * (double)level - 151.5) * (double)level) + 2220;
    }
}

