/*
 * Decompiled with CFR 0.152.
 */
package by.fxg.mwicontent.ic2.block;

import by.fxg.basicfml.block.BlockContainerInteractable;
import by.fxg.mwicontent.ic2.tile.TileMatterGenerator;
import by.fxg.mwintegration.common.ContentManager;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.tile.IWrenchable;
import ic2.core.IC2;
import ic2.core.block.BlockBase;
import ic2.core.block.BlockTextureStitched;
import ic2.core.block.TileEntityBlock;
import ic2.core.util.LogCategory;
import ic2.core.util.Util;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockMatterGenerator
extends BlockContainerInteractable {
    private final String name;
    private final Supplier<? extends TileMatterGenerator> tileEntitySupplier;
    private final Class<? extends TileMatterGenerator> tileEntityClass;
    private final IIcon[] icons = new IIcon[12];

    public BlockMatterGenerator(String name, Supplier<? extends TileMatterGenerator> tileEntitySupplier, Class<? extends TileMatterGenerator> tileEntityClass) {
        super(Material.field_151573_f);
        this.func_149663_c(name);
        this.func_149711_c(2.2f);
        this.func_149752_b(1000.0f);
        this.func_149647_a(ContentManager.tabMWIntegration);
        this.name = name;
        this.tileEntitySupplier = tileEntitySupplier;
        this.tileEntityClass = tileEntityClass;
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entityliving, ItemStack itemStack) {
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (tileEntity instanceof IWrenchable) {
            IWrenchable tileWrenchable = (IWrenchable)tileEntity;
            if (entityliving == null) {
                tileWrenchable.setFacing((short)2);
            } else {
                int side = MathHelper.func_76128_c((double)((double)(entityliving.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
                switch (side) {
                    case 0: {
                        tileWrenchable.setFacing((short)2);
                        break;
                    }
                    case 1: {
                        tileWrenchable.setFacing((short)5);
                        break;
                    }
                    case 2: {
                        tileWrenchable.setFacing((short)3);
                        break;
                    }
                    case 3: {
                        tileWrenchable.setFacing((short)4);
                    }
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister register) {
        String name = "mwi:ic2/" + this.name;
        for (int types = 0; types < 2; ++types) {
            for (int sides = 0; sides < 6; ++sides) {
                int subIndex = types * 6 + sides;
                BlockTextureStitched sprite = new BlockTextureStitched(name + ":" + subIndex, subIndex);
                this.icons[subIndex] = sprite;
                ((TextureMap)register).setTextureEntry(name + ":" + subIndex, (TextureAtlasSprite)sprite);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess iBlockAccess, int x, int y, int z, int side) {
        int facing = this.getFacing(iBlockAccess, x, y, z);
        boolean active = this.isActive(iBlockAccess, x, y, z);
        int meta = iBlockAccess.func_72805_g(x, y, z);
        int index = meta;
        if (index >= this.icons.length) {
            return null;
        }
        int subIndex = BlockBase.getTextureSubIndex((int)facing, (int)side);
        if (active) {
            subIndex += 6;
        }
        try {
            return this.icons[subIndex];
        }
        catch (Exception var12) {
            IC2.platform.displayError(var12, "Coordinates: %d/%d/%d\nSide: %d\nBlock: %s\nMeta: %d\nFacing: %d\nActive: %s\nIndex: %d\nSubIndex: %d", new Object[]{x, y, z, side, this, meta, facing, active, index, subIndex});
            return null;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        int facing = 3;
        int index = meta;
        int subIndex = BlockBase.getTextureSubIndex((int)facing, (int)side);
        if (index >= this.icons.length) {
            return null;
        }
        try {
            return this.icons[subIndex];
        }
        catch (Exception var7) {
            IC2.platform.displayError(var7, "Side: " + side + "\nBlock: " + (Object)((Object)this) + "\nMeta: " + meta + "\nFacing: " + facing + "\nIndex: " + index + "\nSubIndex: " + subIndex, new Object[0]);
            return null;
        }
    }

    public boolean rotateBlock(World world, int x, int y, int z, ForgeDirection axis) {
        int newFacing;
        IWrenchable tileWrenchable;
        if (axis == ForgeDirection.UNKNOWN) {
            return false;
        }
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (tileEntity instanceof IWrenchable && (tileWrenchable = (IWrenchable)tileEntity).wrenchCanSetFacing(null, newFacing = ForgeDirection.getOrientation((int)tileWrenchable.getFacing()).getRotation(axis).ordinal())) {
            tileWrenchable.setFacing((short)newFacing);
        }
        return false;
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        TileEntity tileEntity = this.getOwnTe((IBlockAccess)world, x, y, z);
        if (tileEntity instanceof TileEntityBlock) {
            ((TileEntityBlock)tileEntity).onNeighborUpdate(block);
        }
    }

    public int getFacing(IBlockAccess iBlockAccess, int x, int y, int z) {
        TileEntity te = iBlockAccess.func_147438_o(x, y, z);
        if (te instanceof TileEntityBlock) {
            return ((TileEntityBlock)te).getFacing();
        }
        int meta = iBlockAccess.func_72805_g(x, y, z);
        return 3;
    }

    private boolean isActive(IBlockAccess iba, int x, int y, int z) {
        return ((TileEntityBlock)iba.func_147438_o(x, y, z)).getActive();
    }

    public TileEntity createTile(World world, int metadata) {
        return (TileEntity)this.tileEntitySupplier.get();
    }

    @Deprecated
    public TileEntity getOwnTe(IBlockAccess blockAccess, int x, int y, int z) {
        Class<?> actualClass;
        TileEntity te;
        int meta;
        Block block;
        if (blockAccess instanceof World) {
            Chunk chunk = Util.getLoadedChunk((World)((World)blockAccess), (int)(x >> 4), (int)(z >> 4));
            if (chunk == null) {
                return null;
            }
            block = chunk.func_150810_a(x & 0xF, y, z & 0xF);
            meta = chunk.func_76628_c(x & 0xF, y, z & 0xF);
            te = blockAccess.func_147438_o(x, y, z);
        } else {
            block = blockAccess.func_147439_a(x, y, z);
            meta = blockAccess.func_72805_g(x, y, z);
            te = blockAccess.func_147438_o(x, y, z);
        }
        Class<?> clazz = actualClass = te != null ? te.getClass() : null;
        if (actualClass != this.tileEntityClass) {
            if (block != this) {
                if (Util.inDev()) {
                    StackTraceElement[] st = new Throwable().getStackTrace();
                    IC2.log.warn(LogCategory.Block, "Own tile entity query from %s to foreign block %s instead of %s at %s.", new Object[]{st.length > 1 ? st[1] : "?", block != null ? block.getClass() : null, ((Object)((Object)this)).getClass(), Util.formatPosition((IBlockAccess)blockAccess, (int)x, (int)y, (int)z)});
                }
                return null;
            }
            IC2.log.warn(LogCategory.Block, "Mismatched tile entity at %s, got %s, expected %s.", new Object[]{Util.formatPosition((IBlockAccess)blockAccess, (int)x, (int)y, (int)z), actualClass, this.tileEntityClass});
            if (!(blockAccess instanceof World)) {
                return null;
            }
            World world = (World)blockAccess;
            te = this.createTileEntity(world, meta);
            world.func_147455_a(x, y, z, te);
        }
        return te;
    }
}

