/*
 * Decompiled with CFR 0.152.
 */
package by.fxg.mwicontent.thaumcraft;

import by.fxg.basicfml.configv2.BasicPartedConfigPart;
import by.fxg.basicfml.configv2.intermediary.IntermediaryCompound;
import by.fxg.basicfml.configv2.intermediary.IntermediaryWrapper;

public class ContentThaumcraftConfig
implements BasicPartedConfigPart<IntermediaryCompound> {
    public static boolean ENABLED = true;
    public static boolean ENABLE_blockMatrixStabilizer = true;
    public static boolean ENABLE_blockAdvancedAlchemyFurnace = true;
    public static boolean MATRIX_STABILIZER_USE_MAIN_TICKRATE = false;
    public static int MATRIX_STABILIZER_TICKRATE = 4;
    public static int MATRIX_STABILIZER_SPEED = 2;
    public static int MATRIX_STABILIZER_SEARCH_TICKRATE = 40;
    public static int MATRIX_STABILIZER_SEARCH_RADIUS = 3;
    public static int MATRIX_STABILIZER_LIMIT = 4;
    public static float MATRIX_STABILIZER_STABILIZATION_VALUE = 4.0f;
    public static float MATRIX_STABILIZER_DESTABILIZATION_VALUE = 1.0f;
    public static int ADV_ALCHEMY_FURNACE_TICKRATE = 10;
    public static int ADV_ALCHEMY_FURNACE_MAX_VIS = 1500;
    public static int ADV_ALCHEMY_FURNACE_MAX_HEAT = 1500;
    public static int ADV_ALCHEMY_FURNACE_ASPECT_CONSUMPTION = 75;
    public static float ADV_ALCHEMY_FURNACE_HEAT_MODIFIER_FIRE = 1.0f;
    public static float ADV_ALCHEMY_FURNACE_HEAT_MODIFIER_WATER = 0.75f;
    public static float ADV_ALCHEMY_FURNACE_HEAT_MODIFIER_ENTROPY = 2.0f;
    public static boolean ADV_ALCHEMY_FURNACE_CONSTANT_PROCESSING = false;
    public static int ADV_ALCHEMY_FURNACE_CONSTANT_PROCESSING_HEAT_THRESHOLD = 500;

    public String getPartName() {
        return "Thaumcraft";
    }

    public IntermediaryCompound serializePart() {
        IntermediaryCompound compound = new IntermediaryCompound();
        compound.append("enable", ENABLED, "\u0412\u043a\u043b\u044e\u0447\u0438\u0442\u044c \u0438\u043d\u0442\u0435\u0433\u0440\u0430\u0446\u0438\u044e");
        IntermediaryCompound content = new IntermediaryCompound();
        content.append("blockMatrixStabilizer", ENABLE_blockMatrixStabilizer);
        content.append("blockAdvancedAlchemyFurnace", ENABLE_blockAdvancedAlchemyFurnace);
        compound.append("content", (IntermediaryWrapper)content, "\u0412\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0435/\u0432\u044b\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0435 \u043a\u043e\u043d\u0442\u0435\u043d\u0442\u0430");
        IntermediaryCompound balance = new IntermediaryCompound();
        IntermediaryCompound matrixStabilizer = new IntermediaryCompound();
        matrixStabilizer.append("tickrate", (Number)MATRIX_STABILIZER_TICKRATE, "\u0422\u0438\u043a\u0440\u0435\u0439\u0442 \u0446\u0438\u043a\u043b\u043e\u0432 \u0432\u044b\u0447\u0438\u0442\u0430\u043d\u0438\u044f \u0430\u0441\u043f\u0435\u043a\u0442\u043e\u0432, n \u0442\u0438\u043a\u043e\u0432 = 1 \u0446\u0438\u043a\u043b");
        matrixStabilizer.append("speed", (Number)MATRIX_STABILIZER_SPEED, "\u0421\u043a\u043e\u0440\u043e\u0441\u0442\u044c \u0432\u044b\u0447\u0438\u0442\u0430\u043d\u0438\u044f \u0430\u0441\u043f\u0435\u043a\u0442\u043e\u0432(\u043b\u0443\u0447\u0448\u0435 \u043c\u0435\u043d\u044f\u0442\u044c \u044d\u0442\u043e \u0431\u0430\u0437\u0438\u0440\u0443\u044f\u0441\u044c \u043d\u0430 \u0442\u0438\u043a\u0440\u0435\u0439\u0442\u0435)");
        matrixStabilizer.append("search_tickrate", (Number)MATRIX_STABILIZER_SEARCH_TICKRATE, "\u0422\u0438\u043a\u0440\u0435\u0439\u0442 \u043f\u043e\u0438\u0441\u043a\u0430 \u043c\u0430\u0442\u0440\u0438\u0446\u044b");
        matrixStabilizer.append("search_radius", (Number)MATRIX_STABILIZER_SEARCH_RADIUS, "\u0420\u0430\u0434\u0438\u0443\u0441 \u043f\u043e\u0438\u0441\u043a\u0430 \u043c\u0430\u0442\u0440\u0438\u0446\u044b");
        matrixStabilizer.append("limit", (Number)MATRIX_STABILIZER_LIMIT, "\u041b\u0438\u043c\u0438\u0442 \u0441\u0442\u0430\u0431\u0438\u043b\u0438\u0437\u0430\u0442\u043e\u0440\u043e\u0432 \u0434\u043b\u044f 1 \u043c\u0430\u0442\u0440\u0438\u0446\u044b");
        matrixStabilizer.append("stabilization_value", (Number)Float.valueOf(MATRIX_STABILIZER_STABILIZATION_VALUE), "\u0421\u0442\u0430\u0431\u0438\u043b\u0438\u0437\u0430\u0446\u0438\u044f \u043e\u0442 1 \u0441\u0442\u0430\u0431\u0438\u043b\u0438\u0437\u0430\u0442\u043e\u0440\u0430");
        matrixStabilizer.append("destabilization_value", (Number)Float.valueOf(MATRIX_STABILIZER_DESTABILIZATION_VALUE), "\u0414\u0435\u0441\u0442\u0430\u0431\u0438\u043b\u0438\u0437\u0430\u0446\u0438\u044f \u043e\u0442 1 \u0441\u0442\u0430\u0431\u0438\u043b\u0438\u0437\u0430\u0442\u043e\u0440\u0430, \u0432 \u0441\u043b\u0443\u0447\u0430\u0435 \u0435\u0441\u043b\u0438 \u0441\u0442\u0430\u0431\u0438\u043b\u0438\u0437\u0430\u0442\u043e\u0440\u044b \u0441\u0442\u043e\u044f\u0442 \u043d\u0435 \u0441\u0438\u043c\u043c\u0435\u0442\u0440\u0438\u0447\u043d\u043e");
        balance.append("matrixStabilizer", (IntermediaryWrapper)matrixStabilizer, "\u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 \u0431\u0430\u043b\u0430\u043d\u0441\u0430 \u0441\u0442\u0430\u0431\u0438\u043b\u0438\u0437\u0430\u0442\u043e\u0440\u043e\u0432 \u043c\u0430\u0442\u0440\u0438\u0446\u044b (\u0438\u043d\u0444\u0443\u0437\u0438\u0438)");
        IntermediaryCompound advanced_alchemy_furnace = new IntermediaryCompound();
        advanced_alchemy_furnace.append("tickrate", (Number)ADV_ALCHEMY_FURNACE_TICKRATE, "\u0422\u0438\u043a\u0440\u0435\u0439\u0442 \u0432\u044b\u0441\u0430\u0441\u044b\u0432\u0430\u043d\u0438\u044f \u0430\u0441\u043f\u0435\u043a\u0442\u043e\u0432 \u0438 \u0441\u0436\u0438\u0433\u0430\u043d\u0438\u044f \u043f\u0440\u0435\u0434\u043c\u0435\u0442\u043e\u0432, n \u0442\u0438\u043a\u043e\u0432 = 1 \u0446\u0438\u043a\u043b (\u0423 \u043e\u0440\u0438\u0433\u0438\u043d\u0430\u043b\u044c\u043d\u043e\u0439 - \u0425\u0443\u0439 \u0437\u043d\u0430\u0435\u0442 :/)");
        advanced_alchemy_furnace.append("max_vis", (Number)ADV_ALCHEMY_FURNACE_MAX_VIS, "\u041c\u0430\u043a\u0441. \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u0432\u0438\u0441 \u043a\u043e\u0442\u043e\u0440\u043e\u0435 \u043c\u043e\u0436\u0435\u0442 \u0445\u0440\u0430\u043d\u0438\u0442\u044c \u0432 \u0441\u0435\u0431\u0435 \u043f\u0435\u0447\u044c (\u0423 \u043e\u0440\u0438\u0433\u0438\u043d\u0430\u043b\u044c\u043d\u043e\u0439 - 500)");
        advanced_alchemy_furnace.append("max_heat", (Number)ADV_ALCHEMY_FURNACE_MAX_HEAT, "\u041c\u0430\u043a\u0441. \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u0442\u0435\u043f\u043b\u0430 \u043a\u043e\u0442\u043e\u0440\u043e\u0435 \u043c\u043e\u0436\u0435\u0442 \u043d\u0430\u043a\u043e\u043f\u0438\u0442\u044c \u0432 \u0441\u0435\u0431\u0435 \u043f\u0435\u0447\u044c (\u0423 \u043e\u0440\u0438\u0433\u0438\u043d\u0430\u043b\u044c\u043d\u043e\u0439 - 500)");
        advanced_alchemy_furnace.append("aspect_consumtion", (Number)ADV_ALCHEMY_FURNACE_ASPECT_CONSUMPTION, "\u041c\u0430\u043a\u0441. \u043f\u043e\u0442\u0440\u0435\u0431\u043b\u0435\u043d\u0438\u0435 \u0430\u0441\u043f\u0435\u043a\u0442\u043e\u0432 \u0437\u0430 \u0446\u0438\u043a\u043b (\u0423 \u043e\u0440\u0438\u0433\u0438\u043d\u0430\u043b\u044c\u043d\u043e\u0439 - 50)");
        advanced_alchemy_furnace.append("heat_modifier_fire", (Number)Float.valueOf(ADV_ALCHEMY_FURNACE_HEAT_MODIFIER_FIRE), "\u041a\u043e\u043b-\u0432\u043e \u0442\u0435\u043f\u043b\u0430 \u043e\u0442 1 \u0432\u0438\u0441 \u0430\u0441\u043f\u0435\u043a\u0442\u0430 \u043e\u0433\u043d\u044f (ignis); (\u0423 \u043e\u0440\u0438\u0433\u0438\u043d\u0430\u043b\u044c\u043d\u043e\u0439 - 1.0)");
        advanced_alchemy_furnace.append("heat_modifier_water", (Number)Float.valueOf(ADV_ALCHEMY_FURNACE_HEAT_MODIFIER_WATER), "\u041a\u043e\u043b-\u0432\u043e \u0442\u0435\u043f\u043b\u0430 \u043e\u0442 1 \u0432\u0438\u0441 \u0430\u0441\u043f\u0435\u043a\u0442\u0430 \u0432\u043e\u0434\u044b (aqua); (\u0423 \u043e\u0440\u0438\u0433\u0438\u043d\u0430\u043b\u044c\u043d\u043e\u0439 - 1.0)");
        advanced_alchemy_furnace.append("heat_modifier_entropy", (Number)Float.valueOf(ADV_ALCHEMY_FURNACE_HEAT_MODIFIER_ENTROPY), "\u041a\u043e\u043b-\u0432\u043e \u0442\u0435\u043f\u043b\u0430 \u043e\u0442 1 \u0432\u0438\u0441 \u0430\u0441\u043f\u0435\u043a\u0442\u0430 \u044d\u043d\u0442\u0440\u043e\u043f\u0438\u0438 (perditio); (\u0423 \u043e\u0440\u0438\u0433\u0438\u043d\u0430\u043b\u044c\u043d\u043e\u0439 - 1.0)");
        advanced_alchemy_furnace.append("constant_processing", ADV_ALCHEMY_FURNACE_CONSTANT_PROCESSING, "\u041f\u043e\u0441\u0442\u043e\u044f\u043d\u043d\u0430\u044f \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0430, \u043e\u0431\u0440\u0430\u0431\u0430\u0442\u044b\u0432\u0430\u0435\u0442 \u0441\u0440\u0430\u0437\u0443 \u043d\u0435\u0441\u043a\u043e\u043b\u044c\u043a\u043e \u043f\u0440\u0435\u0434\u043c\u0435\u0442\u043e\u0432 \u0437\u0430 \u0446\u0438\u043a\u043b\n\u043e\u0433\u0440\u0430\u043d\u0438\u0447\u0438\u0432\u0430\u0435\u0442\u0441\u044f \u043c\u0430\u043a\u0441. \u043f\u043e\u0442\u0440\u0435\u0431\u043b\u0435\u043d\u0438\u0435\u043c \u0442\u0435\u043f\u043b\u0430 \u0437\u0430 \u0446\u0438\u043a\u043b");
        advanced_alchemy_furnace.append("constproc_heat_threshold", (Number)ADV_ALCHEMY_FURNACE_CONSTANT_PROCESSING_HEAT_THRESHOLD, "\u041c\u0430\u043a\u0441. \u043f\u043e\u0442\u0440\u0435\u0431\u043b\u0435\u043d\u0438\u0435 \u0446\u0438\u043a\u043b\u0430 \u0437\u0430 \u0446\u0438\u043a\u043b \u043f\u0440\u0438 \u043f\u043e\u0441\u0442\u043e\u044f\u043d\u043d\u043e\u0439 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0435 (constant_processing)");
        balance.append("advanced_alchemy_furnace", (IntermediaryWrapper)advanced_alchemy_furnace, "\u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 \u0431\u0430\u043b\u0430\u043d\u0441\u0430 \u0443\u043b\u0443\u0447\u0448\u0435\u043d\u043d\u044b\u0445 \u0430\u043b\u0445\u0438\u043c\u0438\u0447\u0435\u0441\u043a\u0438\u0445 \u043f\u0435\u0447\u0435\u0439");
        compound.append("balance", (IntermediaryWrapper)balance, "\u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 \u0431\u0430\u043b\u0430\u043d\u0441\u0430");
        return compound;
    }

    public boolean deserializePart(IntermediaryCompound compound) {
        if (compound != null) {
            IntermediaryCompound balance;
            ENABLED = compound.getBoolean("enable", ENABLED);
            IntermediaryCompound content = compound.getCompound("content");
            if (content != null) {
                ENABLE_blockMatrixStabilizer = content.getBoolean("blockMatrixStabilizer", ENABLE_blockMatrixStabilizer);
                ENABLE_blockAdvancedAlchemyFurnace = content.getBoolean("blockAdvancedAlchemyFurnace", ENABLE_blockAdvancedAlchemyFurnace);
            }
            if ((balance = compound.getCompound("balance")) != null) {
                IntermediaryCompound advanced_alchemy_furnace;
                IntermediaryCompound matrixStabilizer = balance.getCompound("matrixStabilizer");
                if (matrixStabilizer != null) {
                    MATRIX_STABILIZER_TICKRATE = matrixStabilizer.getInteger("tickrate", MATRIX_STABILIZER_TICKRATE);
                    MATRIX_STABILIZER_SPEED = matrixStabilizer.getInteger("speed", MATRIX_STABILIZER_SPEED);
                    MATRIX_STABILIZER_SEARCH_TICKRATE = matrixStabilizer.getInteger("search_tickrate", MATRIX_STABILIZER_SEARCH_TICKRATE);
                    MATRIX_STABILIZER_SEARCH_RADIUS = matrixStabilizer.getInteger("search_radius", MATRIX_STABILIZER_SEARCH_RADIUS);
                    MATRIX_STABILIZER_LIMIT = matrixStabilizer.getInteger("limit", MATRIX_STABILIZER_LIMIT);
                    MATRIX_STABILIZER_STABILIZATION_VALUE = matrixStabilizer.getFloat("stabilization_value", MATRIX_STABILIZER_STABILIZATION_VALUE);
                    MATRIX_STABILIZER_DESTABILIZATION_VALUE = matrixStabilizer.getFloat("destabilization_value", MATRIX_STABILIZER_DESTABILIZATION_VALUE);
                    boolean bl = MATRIX_STABILIZER_USE_MAIN_TICKRATE = MATRIX_STABILIZER_TICKRATE > MATRIX_STABILIZER_SEARCH_TICKRATE;
                }
                if ((advanced_alchemy_furnace = balance.getCompound("advanced_alchemy_furnace")) != null) {
                    ADV_ALCHEMY_FURNACE_TICKRATE = advanced_alchemy_furnace.getInteger("tickrate", ADV_ALCHEMY_FURNACE_TICKRATE);
                    ADV_ALCHEMY_FURNACE_MAX_VIS = advanced_alchemy_furnace.getInteger("max_vis", ADV_ALCHEMY_FURNACE_MAX_VIS);
                    ADV_ALCHEMY_FURNACE_MAX_HEAT = advanced_alchemy_furnace.getInteger("max_heat", ADV_ALCHEMY_FURNACE_MAX_HEAT);
                    ADV_ALCHEMY_FURNACE_ASPECT_CONSUMPTION = advanced_alchemy_furnace.getInteger("aspect_consumtion", ADV_ALCHEMY_FURNACE_ASPECT_CONSUMPTION);
                    ADV_ALCHEMY_FURNACE_HEAT_MODIFIER_FIRE = Math.max(advanced_alchemy_furnace.getFloat("heat_modifier_fire", ADV_ALCHEMY_FURNACE_HEAT_MODIFIER_FIRE), 0.0f);
                    ADV_ALCHEMY_FURNACE_HEAT_MODIFIER_WATER = Math.max(advanced_alchemy_furnace.getFloat("heat_modifier_water", ADV_ALCHEMY_FURNACE_HEAT_MODIFIER_WATER), 0.0f);
                    ADV_ALCHEMY_FURNACE_HEAT_MODIFIER_ENTROPY = Math.max(advanced_alchemy_furnace.getFloat("heat_modifier_entropy", ADV_ALCHEMY_FURNACE_HEAT_MODIFIER_ENTROPY), 0.0f);
                    ADV_ALCHEMY_FURNACE_CONSTANT_PROCESSING = advanced_alchemy_furnace.getBoolean("constant_processing", ADV_ALCHEMY_FURNACE_CONSTANT_PROCESSING);
                    ADV_ALCHEMY_FURNACE_CONSTANT_PROCESSING_HEAT_THRESHOLD = advanced_alchemy_furnace.getInteger("constproc_heat_threshold", ADV_ALCHEMY_FURNACE_CONSTANT_PROCESSING_HEAT_THRESHOLD);
                }
            }
            return true;
        }
        return false;
    }
}

