/*
 * Decompiled with CFR 0.152.
 */
package by.fxg.mwicontent.thaumcraft.render;

import by.fxg.mwicontent.thaumcraft.tile.TileMatrixStabilizer;
import by.fxg.mwintegration.client.ClientProxy;
import gnu.trove.map.hash.THashMap;
import java.util.Map;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.model.AdvancedModelLoader;
import net.minecraftforge.client.model.IModelCustom;
import org.lwjgl.opengl.GL11;

public class RenderBlockMatrixStabilizer
extends TileEntitySpecialRenderer
implements IItemRenderer {
    private final Map<String, Integer> glLists = new THashMap();
    private final ResourceLocation texture = new ResourceLocation("mwi", "textures/models/thaumcraft/blockMatrixStabilizer.png");
    private final IModelCustom model = AdvancedModelLoader.loadModel((ResourceLocation)new ResourceLocation("mwi", "models/thaumcraft/blockMatrixStabilizer.obj"));

    public RenderBlockMatrixStabilizer() {
        this.createList("core");
        this.createList("crystall_crystall2");
        this.createList("firstring");
        this.createList("secondring");
        this.createList("thirdring");
    }

    public boolean handleRenderType(ItemStack stack, IItemRenderer.ItemRenderType type) {
        return true;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack stack, IItemRenderer.ItemRendererHelper helper) {
        return true;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack stack, Object ... data) {
        GL11.glPushMatrix();
        if (type == IItemRenderer.ItemRenderType.ENTITY) {
            GL11.glTranslatef((float)0.0f, (float)-0.5f, (float)0.0f);
        } else {
            GL11.glTranslatef((float)0.5f, (float)0.0f, (float)0.5f);
        }
        this.func_147499_a(this.texture);
        this.model.renderAll();
        GL11.glPopMatrix();
    }

    public void func_147500_a(TileEntity tileEntity, double x, double y, double z, float partialTick) {
        TileMatrixStabilizer tile = (TileMatrixStabilizer)tileEntity;
        boolean isMatrixValid = tile.isMatrixValid();
        this.func_147499_a(this.texture);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y), (float)((float)z + 0.5f));
        this.renderPart("core");
        GL11.glPushMatrix();
        if (isMatrixValid) {
            GL11.glRotatef((float)(-(((float)ClientProxy.rotationCycle360 + partialTick) * 4.0f)), (float)0.0f, (float)1.0f, (float)0.0f);
        }
        this.renderPart("secondring");
        this.renderPart("crystall_crystall2");
        GL11.glPopMatrix();
        if (isMatrixValid) {
            GL11.glRotatef((float)(((float)ClientProxy.rotationCycle360 + partialTick) * 3.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        }
        this.renderPart("firstring");
        if (isMatrixValid) {
            GL11.glRotatef((float)(((float)ClientProxy.rotationCycle360 + partialTick) * 3.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        }
        this.renderPart("thirdring");
        GL11.glPopMatrix();
    }

    protected void createList(String part) {
        int listID = GLAllocation.func_74526_a((int)1);
        GL11.glNewList((int)listID, (int)4864);
        if (part == null || part.equals("all")) {
            part = "all";
            this.model.renderAll();
        } else {
            this.model.renderPart(part);
        }
        GL11.glEndList();
        this.glLists.put(part, listID);
    }

    protected void renderPart(String part) {
        Integer listID;
        if (part == null) {
            part = "all";
        }
        if ((listID = this.glLists.get(part)) != null) {
            GL11.glCallList((int)listID);
        }
    }
}

