/*
 * Decompiled with CFR 0.152.
 */
package by.fxg.mwintegration.common.utils;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gnu.trove.list.array.TByteArrayList;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.util.IIcon;

public class BlockTextureMapping {
    private static final String[] SUFFIXES = new String[]{"Bottom", "Top", "North", "South", "West", "East", "Horizontal", "Vertical", ""};
    public static final byte SUFFIX_DOWN = 0;
    public static final byte SUFFIX_UP = 1;
    public static final byte SUFFIX_NORTH = 2;
    public static final byte SUFFIX_SOUTH = 3;
    public static final byte SUFFIX_WEST = 4;
    public static final byte SUFFIX_EAST = 5;
    public static final byte SUFFIX_HORIZONTAL = 6;
    public static final byte SUFFIX_VERTICAL = 7;
    public static final byte SUFFIX_NONE = 8;
    public static final byte SIDE_DOWN = 1;
    public static final byte SIDE_UP = 2;
    public static final byte SIDE_NORTH = 4;
    public static final byte SIDE_SOUTH = 8;
    public static final byte SIDE_WEST = 16;
    public static final byte SIDE_EAST = 32;
    public static final byte SIDE_HORIZONTAL = 60;
    public static final byte SIDE_VERTICAL = 3;
    public static final BlockTextureMapping VERTICAL_HORIZONTAL = new BlockTextureMapping().bind(3, (byte)7).bind(60, (byte)6).build();
    public static final BlockTextureMapping TOP_DOWN_HORIZONTAL = new BlockTextureMapping().bind(2, (byte)1).bind(1, (byte)0).bind(60, (byte)6).build();
    private byte[] redirectArray = null;
    private byte[] textureSuffixes = null;
    private byte[] textureRegistrySuffixes = new byte[]{8, 8, 8, 8, 8, 8};

    @SideOnly(value=Side.CLIENT)
    public IIcon[] getIcons(IIconRegister register, String texturePath) {
        if (this.redirectArray == null) {
            throw new RuntimeException("BlockTextureMapping is not built!");
        }
        IIcon[] icons = new IIcon[6];
        String path = "mwi:" + texturePath;
        for (int suffixArrIdx = 0; suffixArrIdx < this.textureSuffixes.length; ++suffixArrIdx) {
            byte suffixIdx = this.textureSuffixes[suffixArrIdx];
            IIcon icon = register.func_94245_a(path + SUFFIXES[suffixIdx]);
            for (int idx = 0; idx < icons.length; ++idx) {
                if (this.redirectArray[idx] != suffixIdx) continue;
                icons[idx] = icon;
            }
        }
        return icons;
    }

    public BlockTextureMapping bind(int mask, byte suffixIndex) {
        if (this.redirectArray != null) {
            throw new RuntimeException("BlockTextureMapping is already built and cannot be rebound.");
        }
        for (int i = 0; i != 6; ++i) {
            int subMask = 1 << i;
            if ((mask & subMask) != subMask) continue;
            this.textureRegistrySuffixes[i] = suffixIndex;
        }
        return this;
    }

    public BlockTextureMapping build() {
        int i;
        TByteArrayList idxList = new TByteArrayList();
        for (i = 0; i < this.textureRegistrySuffixes.length; ++i) {
            if (idxList.contains(this.textureRegistrySuffixes[i])) continue;
            idxList.add(this.textureRegistrySuffixes[i]);
        }
        this.textureSuffixes = new byte[idxList.size()];
        for (i = 0; i < idxList.size(); ++i) {
            this.textureSuffixes[i] = idxList.get(i);
        }
        this.redirectArray = new byte[this.textureRegistrySuffixes.length];
        for (i = 0; i < this.redirectArray.length; ++i) {
            this.redirectArray[i] = (byte)idxList.indexOf(this.textureRegistrySuffixes[i]);
        }
        this.textureRegistrySuffixes = null;
        return this;
    }
}

