/*
 * Decompiled with CFR 0.152.
 */
package by.fxg.pluginforgery;

import by.fxg.modernbus.ModernBus;
import by.fxg.pluginforgery.EssentialsIntegration;
import by.fxg.pluginforgery.ForgeryAPI;
import by.fxg.pluginforgery.OWIntegration;
import by.fxg.pluginforgery.VaultIntegration;
import by.fxg.pluginforgery.WorldGuardIntegration;
import by.fxg.pluginforgery.abuse.BukkitAbuse;
import by.fxg.pluginforgery.abuse.IBukkitAbuse;
import by.fxg.pluginforgery.api.PluginForgeryMail;
import by.fxg.pluginforgery.impl.BukkitForgeryPlayer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;

public class PluginForgery
extends JavaPlugin {
    public static final Logger LOGGER = LogManager.getLogger((String)"PluginForgery");
    private static IBukkitAbuse bukkitAbuse;
    private final ForgeryAPI api = new ForgeryAPI();
    private final VaultIntegration vault = new VaultIntegration();
    private final WorldGuardIntegration worldGuard = new WorldGuardIntegration();
    private final OWIntegration onlineWatcher = new OWIntegration();
    private final EssentialsIntegration essentials = new EssentialsIntegration();
    private boolean isEnabled = false;

    public PluginForgery() {
        bukkitAbuse = new BukkitAbuse();
    }

    public static IBukkitAbuse getBukkitAbuseInterface() {
        return bukkitAbuse;
    }

    public void onEnable() {
        LOGGER.info("Enabling PluginForgery");
        ModernBus.register(PluginForgeryMail.PluginRespondRequest.class, this::respondRequest);
        this.vault.onEnable(this);
        this.worldGuard.onEnable(this);
        this.onlineWatcher.onEnable(this);
        this.essentials.onEnable(this);
        this.api.player = new BukkitForgeryPlayer();
        this.api.register();
        this.isEnabled = true;
        ModernBus.post(new PluginForgeryMail.PluginEnabled());
        LOGGER.info("PluginForgery enabled!");
    }

    public void onDisable() {
        LOGGER.info("Disabling PluginForgery");
        this.isEnabled = false;
        this.api.unregister();
        this.worldGuard.onDisable();
        this.vault.onDisable();
        this.onlineWatcher.onDisable();
        this.essentials.onDisable();
        ModernBus.post(new PluginForgeryMail.PluginDisabled());
        LOGGER.info("PluginForgery disabled!");
    }

    protected <T> T getService(Class<T> typeClass, String name) {
        RegisteredServiceProvider rsp = this.getServer().getServicesManager().getRegistration(typeClass);
        if (rsp.getProvider() != null) {
            return (T)rsp.getProvider();
        }
        this.getLogger().warning("PluginForgery not found " + name + ", " + name + " extension will not be loaded.");
        return null;
    }

    private void respondRequest(PluginForgeryMail.PluginRespondRequest mail) {
        mail.isResponded = true;
        mail.isForgeryEnabled = this.isEnabled;
    }
}

