/*
 * Decompiled with CFR 0.152.
 */
package by.fxg.pluginforgery;

import by.fxg.pluginforgery.ForgeryAPI;
import by.fxg.pluginforgery.PluginForgery;
import by.fxg.pluginforgery.impl.vault.VaultForgeryChat;
import by.fxg.pluginforgery.impl.vault.VaultForgeryEconomy;
import by.fxg.pluginforgery.impl.vault.VaultForgeryPermissions;
import net.milkbowl.vault.chat.Chat;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.permission.Permission;

public class VaultIntegration {
    public void onEnable(PluginForgery plugin) {
        Permission permission = plugin.getService(Permission.class, "Vault-Permissions");
        if (permission != null) {
            ForgeryAPI.INSTANCE.permissions = new VaultForgeryPermissions(permission);
            PluginForgery.LOGGER.info("Vault Permissions is loaded!");
        } else {
            PluginForgery.LOGGER.warn("Unable to setup Vault Permissions!");
        }
        Chat chat = plugin.getService(Chat.class, "Vault-Chat");
        if (chat != null) {
            ForgeryAPI.INSTANCE.chat = new VaultForgeryChat(chat);
            PluginForgery.LOGGER.info("Vault Chat is loaded!");
        } else {
            PluginForgery.LOGGER.warn("Unable to setup Vault Chat!");
        }
        Economy economy = plugin.getService(Economy.class, "Vault-Economy");
        if (economy != null) {
            ForgeryAPI.INSTANCE.economy = new VaultForgeryEconomy(economy);
            PluginForgery.LOGGER.info("Vault Economy is loaded!");
        } else {
            PluginForgery.LOGGER.warn("Unable to setup Vault Economy!");
        }
    }

    public void onDisable() {
        if (ForgeryAPI.INSTANCE.economy instanceof VaultForgeryEconomy) {
            ForgeryAPI.INSTANCE.economy = null;
        }
        if (ForgeryAPI.INSTANCE.permissions instanceof VaultForgeryPermissions) {
            ForgeryAPI.INSTANCE.permissions = null;
        }
        if (ForgeryAPI.INSTANCE.chat instanceof VaultForgeryChat) {
            ForgeryAPI.INSTANCE.chat = null;
        }
    }
}

