/*
 * Decompiled with CFR 0.152.
 */
package by.fxg.pluginforgery.impl.worldguard;

import by.fxg.pluginforgery.PluginForgery;
import by.fxg.pluginforgery.abuse.IBukkitAbuse;
import by.fxg.pluginforgery.api.regions.IForgeryRegions;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldguard.LocalPlayer;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.entity.Player;

public class WorldGuardForgeryRegions
implements IForgeryRegions {
    private final WorldGuardPlugin worldGuard;
    private final IBukkitAbuse bukkitAbuse;

    public WorldGuardForgeryRegions(WorldGuardPlugin worldGuardPlugin) {
        this.worldGuard = worldGuardPlugin;
        this.bukkitAbuse = PluginForgery.getBukkitAbuseInterface();
    }

    @Override
    public String getName() {
        return "WorldGuard";
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public boolean isPointInRegion(String world, int x, int y, int z) {
        World worldObj = Bukkit.getWorld((String)world);
        if (world != null) {
            Vector location = new Vector(x, y, z);
            for (ProtectedRegion region : this.worldGuard.getRegionManager(worldObj).getApplicableRegions(location)) {
                if (region.getId().equals("__global__")) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isPlayerPointMember(Object EntityPlayer2, int x, int y, int z) {
        Player player = this.bukkitAbuse.getBukkitPlayerExplicit(EntityPlayer2);
        return player != null ? Boolean.valueOf(this.isPlayerPointMember(player, player.getWorld(), x, y, z)) : null;
    }

    @Override
    public boolean isPlayerPointMember(String username, int x, int y, int z) {
        Player player = Bukkit.getPlayer((String)username);
        return player != null ? Boolean.valueOf(this.isPlayerPointMember(player, player.getWorld(), x, y, z)) : null;
    }

    @Override
    public boolean isPlayerPointMember(UUID playerUniqueID, int x, int y, int z) {
        Player player = Bukkit.getPlayer((UUID)playerUniqueID);
        return player != null ? Boolean.valueOf(this.isPlayerPointMember(player, player.getWorld(), x, y, z)) : null;
    }

    @Override
    public boolean isPlayerPointMember(Object EntityPlayer2, String world, int x, int y, int z) {
        return this.isPlayerPointMember(this.bukkitAbuse.getBukkitPlayerExplicit(EntityPlayer2), Bukkit.getWorld((String)world), x, y, z);
    }

    @Override
    public boolean isPlayerPointMember(String username, String world, int x, int y, int z) {
        return this.isPlayerPointMember(Bukkit.getPlayer((String)username), Bukkit.getWorld((String)world), x, y, z);
    }

    @Override
    public boolean isPlayerPointMember(UUID playerUniqueID, String world, int x, int y, int z) {
        return this.isPlayerPointMember(Bukkit.getPlayer((UUID)playerUniqueID), Bukkit.getWorld((String)world), x, y, z);
    }

    private boolean isPlayerPointMember(Player player, World world, int x, int y, int z) {
        if (player != null && world != null) {
            Vector location = new Vector(x, y, z);
            LocalPlayer localPlayer = this.worldGuard.wrapPlayer(player, true);
            return this.worldGuard.getRegionManager(world).getApplicableRegions(location).isMemberOfAll(localPlayer);
        }
        return false;
    }

    @Override
    public boolean isPlayerPointOwner(Object EntityPlayer2, int x, int y, int z) {
        Player player = this.bukkitAbuse.getBukkitPlayerExplicit(EntityPlayer2);
        return player != null && this.isPlayerPointOwner(player, player.getWorld(), x, y, z);
    }

    @Override
    public boolean isPlayerPointOwner(String username, int x, int y, int z) {
        Player player = Bukkit.getPlayer((String)username);
        return player != null && this.isPlayerPointOwner(player, player.getWorld(), x, y, z);
    }

    @Override
    public boolean isPlayerPointOwner(UUID playerUniqueID, int x, int y, int z) {
        Player player = Bukkit.getPlayer((UUID)playerUniqueID);
        return player != null && this.isPlayerPointOwner(player, player.getWorld(), x, y, z);
    }

    @Override
    public boolean isPlayerPointOwner(Object EntityPlayer2, String world, int x, int y, int z) {
        return this.isPlayerPointOwner(this.bukkitAbuse.getBukkitPlayerExplicit(EntityPlayer2), Bukkit.getWorld((String)world), x, y, z);
    }

    @Override
    public boolean isPlayerPointOwner(String username, String world, int x, int y, int z) {
        return this.isPlayerPointOwner(Bukkit.getPlayer((String)username), Bukkit.getWorld((String)world), x, y, z);
    }

    @Override
    public boolean isPlayerPointOwner(UUID playerUniqueID, String world, int x, int y, int z) {
        return this.isPlayerPointOwner(Bukkit.getPlayer((UUID)playerUniqueID), Bukkit.getWorld((String)world), x, y, z);
    }

    private boolean isPlayerPointOwner(Player player, World world, int x, int y, int z) {
        if (player != null && world != null) {
            Vector location = new Vector(x, y, z);
            LocalPlayer localPlayer = this.worldGuard.wrapPlayer(player, true);
            return this.worldGuard.getRegionManager(world).getApplicableRegions(location).isOwnerOfAll(localPlayer);
        }
        return false;
    }
}

